% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-poly.R
\name{read_poly}
\alias{read_poly}
\title{Read a \code{.poly} file.}
\usage{
read_poly(input, crs = "OGC:CRS84", ...)
}
\arguments{
\item{input}{Character vector representing a polygon object saved using the
\code{.poly} format. Can be also a path to a file or a URL pointing to a valid
\code{.poly} file.}

\item{crs}{The Coordinate Reference System (CRS) of the input polygon.}

\item{...}{Further arguments passed to \code{readLines()} (which is the function
used to read external \code{.poly} files).}
}
\value{
A \code{sfc_MULTIPOLYGON}/\code{sfc} object.
}
\description{
Read a \code{.poly} file.
}
\details{
The Polygon Filter File Format (\code{.poly}) is defined
\href{https://wiki.openstreetmap.org/wiki/Osmosis/Polygon_Filter_File_Format}{here}.
The code behind the function was inspired by the \code{parse_poly} function
defined
\href{https://wiki.openstreetmap.org/wiki/Osmosis/Polygon_Filter_File_Python_Parsing}{here}.

\href{https://download.geofabrik.de/}{Geofabrik} stores the \code{.poly} files used
to generate their extracts. Furthermore, a nice collection of exact-border
poly files created from cities with an OSM Relation ID is available in this
git repository on github: \url{https://github.com/jameschevalier/cities}.

The default value for the \code{crs} argument is "OGC:CRS84" instead of "4326"
or "EPSG:4326" since, by definition, the coordinates are provided as
"longitude, latitude" (but these differences should be relevant only when
\code{sf::st_axis_order()} is \code{TRUE}).
}
\examples{
toy_poly <- c(
  "test_poly",
  "first_area",
  "0 0",
  "0 1",
  "1 1",
  "1 0",
  "0 0",
  "END",
  "END"
)
(out <- read_poly(toy_poly))
plot(out)

\dontrun{
italy_poly <- "https://download.geofabrik.de/europe/italy.poly"
plot(read_poly(italy_poly))}
}
