/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import fr.ird.osmose.School;
import fr.ird.osmose.process.mortality.AbstractMortality;

public class StarvationMortality
extends AbstractMortality {
    private double[] starvMaxRate;
    private double[] criticalPredSuccess;

    public StarvationMortality(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        int nspec = this.getNSpecies();
        this.starvMaxRate = new double[nspec];
        this.criticalPredSuccess = new double[nspec];
        for (int i = 0; i < nspec; ++i) {
            this.starvMaxRate[i] = this.getConfiguration().getDouble("mortality.starvation.rate.max.sp" + i);
            this.criticalPredSuccess[i] = this.getConfiguration().getDouble("predation.efficiency.critical.sp" + i);
        }
    }

    @Override
    public double getRate(School school) {
        if (school.getAgeDt() == 0) {
            return 0.0;
        }
        int iSpec = school.getSpeciesIndex();
        double mortalityRate = 0.0;
        if ((double)school.getPredSuccessRate() <= this.criticalPredSuccess[iSpec]) {
            mortalityRate = Math.max(this.starvMaxRate[iSpec] * (1.0 - (double)school.getPredSuccessRate() / this.criticalPredSuccess[iSpec]), 0.0);
        }
        return mortalityRate / (double)this.getConfiguration().getNStepYear();
    }
}

