/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ltl;

import fr.ird.osmose.ltl.LTLForcingECO3M;

public class LTLFastForcingECO3M
extends LTLForcingECO3M {
    private double[][][][] data;

    public LTLFastForcingECO3M(int rank) {
        super(rank);
    }

    @Override
    public void initLTLGrid() {
        super.initLTLGrid();
        this.loadData();
    }

    private void loadData() {
        this.info("Loading plankton data...");
        this.data = new double[this.getConfiguration().getNStepYear()][this.getConfiguration().getNPlankton()][][];
        for (int iStep = 0; iStep < this.getConfiguration().getNStepYear(); ++iStep) {
            for (int iPlankton = 0; iPlankton < this.getConfiguration().getNPlankton(); ++iPlankton) {
                this.data[iStep][iPlankton] = super.getRawBiomass(iPlankton, iStep);
            }
        }
    }

    @Override
    double[][] getRawBiomass(int iPlankton, int iStepSimu) {
        return this.data[this.getIndexStepLTL(iStepSimu)][iPlankton];
    }
}

