% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest.R
\name{nearest_api_v5}
\alias{nearest_api_v5}
\title{nearest accessible position for OSRM API v5}
\usage{
nearest_api_v5(lat, lng, address)
}
\arguments{
\item{lat, }{A numeric (-90 < lat < 90)}

\item{lng, }{A numeric (-180 < lng < 180)}

\item{address, }{A character specifying the serveraddress (local or online)}
}
\value{
A data.frame with lat and lng
}
\description{
nearest_api_v5() calculates the nearest position to the given coordinates which can be accessed
by car with the OSRM API v5. The coordinate-standard is WGS84.
}
\examples{
\dontrun{
osrmr:::nearest_api_v5(47,9, osrmr:::server_address(FALSE))
Sys.setenv("OSRM_PATH_API_5"="C:/OSRM_API5")
osrmr::run_server(Sys.getenv("OSRM_PATH_API_5"), "switzerland-latest.osrm")
osrmr:::nearest_api_v5(47,9, osrmr:::server_address(TRUE))
osrmr::quit_server()
Sys.unsetenv("OSRM_PATH_API_5")}
}
