% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{log}
\alias{log}
\alias{log_trace}
\alias{log_debug}
\alias{log_info}
\alias{log_warn}
\alias{log_error}
\alias{log_fatal}
\title{Log an OpenTelemetry log message}
\usage{
log(msg, ..., severity = "info", .envir = parent.frame(), logger = NULL)

log_trace(msg, ..., .envir = parent.frame(), logger = NULL)

log_debug(msg, ..., .envir = parent.frame(), logger = NULL)

log_info(msg, ..., .envir = parent.frame(), logger = NULL)

log_warn(msg, ..., .envir = parent.frame(), logger = NULL)

log_error(msg, ..., .envir = parent.frame(), logger = NULL)

log_fatal(msg, ..., .envir = parent.frame(), logger = NULL)
}
\arguments{
\item{msg}{Log message, may contain R expressions to evaluate within
braces.}

\item{...}{Additional arguments are passed to the \verb{$log()} method of
the logger.}

\item{severity}{Log severity, a string, one of
"trace", "trace2", "trace3", "trace4", "debug", "debug2", "debug3", "debug4", "info", "info2", "info3", "info4", "warn", "warn2", "warn3", "warn4", "error", "error2", "error3", "error4", "fatal", "fatal2", "fatal3", "fatal4".}

\item{.envir}{Environment to evaluate the interpolated expressions of
the log message in.}

\item{logger}{Logger to use. If not an OpenTelemetry logger object
(\link{otel_logger}), then it passed to \code{\link[=get_logger]{get_logger()}} to get a logger.}
}
\value{
The logger, invisibly.
}
\description{
Log an OpenTelemetry log message
}
\details{
\code{log_trace()} is the same as \code{log()} with \code{severity_level}
"trace".

\code{log_debug()} is the same as \code{log()} with \code{severity_level}
"debug".

\code{log_info()} is the same as \code{log()} with \code{severity_level}
"info".

\code{log_warn()} is the same as \code{log()} with \code{severity_level}
"warn".

\verb{log_error)} is the same as \code{log()} with \code{severity_level}
"error".

\code{log_fatal()} is the same as \code{log()} with \code{severity_level}
"fatal".
}
\examples{
host <- "my.db.host"
port <- 6667
otel::log("Connecting to database at {host}:{port}")
}
\seealso{
Other OpenTelemetry logs API: 
\code{\link{is_logging_enabled}()},
\code{\link{log_severity_levels}}
}
\concept{OpenTelemetry logs API}
