% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotDetections.R
\name{PlotDetections}
\alias{PlotDetections}
\title{PLOT DETECTIONS}
\usage{
PlotDetections(data, print.real.anomaly = FALSE,
  print.time.window = FALSE, title = "", xlab = "Time",
  ylab = "Value", return.ggplot = FALSE)
}
\arguments{
\item{data}{data.frame composed of at least one column called timestamp and another column
called value. You can also include other columns such as is.anomaly, is.real.anomaly, ucl, lcl,
anomaly.score. Any of these columns except is.real.anomaly that are included in the dataset will
be shown in the graph automatically.}

\item{print.real.anomaly}{If TRUE adds the real anomalies to the graph.}

\item{print.time.window}{If TRUE shows a time band centered on the real anomaly. According to the
article shown in the reference, if the detected anomaly remains within it would be considered a
true positive.}

\item{title}{Title of the graph.}

\item{xlab}{X Axis Name.}

\item{ylab}{Y Axis Name.}

\item{return.ggplot}{If TRUE the function returns a ggplot object.}
}
\value{
plotly object.
}
\description{
\code{PlotDetections} shows in a graph the results obtained after the application
of one of the anomaly detectors included in this package.
}
\details{
\code{data} must be a data.frame. The \code{timestamp} column can be numeric, of type POSIXlt,
or a character type date convertible  to POSIXlt. The \code{value} column must be numeric.
\code{is.anomaly}, \code{is.real.anomaly}, \code{ucl}, \code{lcl}, \code{anomaly.score} are
some of the variables returned by the algorithms included in this package and must be numeric
or boolean in the case of columns is.anomaly, is.real.anomaly .
}
\examples{
## Generate data
set.seed(100)
n <- 180
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

## Calculate anomalies
result <- CpSdEwma(
  data = df$value,
  n.train = 5,
  threshold = 0.01,
  l = 3
)
res <- cbind(df, result)

## Plot results
PlotDetections(res, title = "KNN-CAD ANOMALY DETECTOR")
}
\references{
A. Lavin and S. Ahmad, “Evaluating Real-time Anomaly Detection Algorithms – the
Numenta Anomaly Benchmark,” in 14th International Conference on Machine Learning and
Applications (IEEE ICMLA’15), 2015.
}
