% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{oubmcirTrait}
\alias{oubmcirTrait}
\title{Parameter samples and summary statistics}
\usage{
oubmcirTrait(tree = tree, traitset = traitset, sims = sims)
}
\arguments{
\item{tree}{An ape: tree object stored in phylo format}

\item{traitset}{a dataframe that contains 3 traits}

\item{sims}{number of trait replicate}
}
\value{
A list of vectors containing a dataframe of summary statistics, and a dataframe of parameter samples
}
\description{
Draw sample for parameters, simulate trait and compute the summary statistics for OUBMCIR model
}
\details{
Given tree, trait sets, function \code{\link{HyperParam}} is called to yield the range of parameters, then function \code{\link{oubmbmprior}} is called to draw sample for parameter, then the function \code{\link{oubmbmmodel}} is applied to simulate traits through post order tree traversal algorithm, finally the summary statistics is computed by function \code{\link{sumstat}}.
}
\examples{

## using coral dataset (running time more > 5 sec)
\donttest{
data(coral)
tree<-coral$tree
traitset<-coral$traitset
sims<-10
oubmcirTrait(tree=tree,traitset=traitset,sims=sims)
}
}
