% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{ouxy}
\alias{ouxy}
\title{main program to perform analysis}
\usage{
ouxy(tree = tree, traitset = traitset, tol = 0.1, sims = 100)
}
\arguments{
\item{tree}{An ape: tree object stored in phylo format}

\item{traitset}{a dataframe that contains 3 traits}

\item{tol}{acceptance rate from ABC}

\item{sims}{number of trait replicate}
}
\value{
A list of vectors containing a dataframe of model parameter estimate, and a dataframe of Bayes factors between a pair of models
\enumerate{
  \item \strong{table.output}: The posterior median for parameter estiamtes under each model.
  \item \strong{s.mnlog}: Bayes factor tables comparing a pair of models.
}
}
\description{
Analyze data and report the model estimates and model selection
}
\details{
\code{\link{ouxy}} performs data analaysis under Approximate Bayesian Computation(ABC) procedure.  The summary statistics for the raw traitsets are first computed by by function \code{\link{sumstat}}, and the parameters ranges are computed using the tree and tratisets under function \code{\link{HyperParam}}, and sample of prior paramters are drawn from function \code{\link{oubmbmprior}}, then the function \code{\link{oubmbmmodel}} is applied to simulate traits through post order tree traversal algorithm.
The ABC procedure are then performed using sample of paramters and simulated traitset.
Posterior sample are chosen using acceptance rate \code{sims * tol}. The posterior samples are computed using rejection method \code{\link[abc]{abc}} to median of the posterior samples are as reported parameter esitmate  and Bayes factor is computed using function \code{\link[abc]{postpr}} accordingly by the ratio of the posterior model probability under each model.
}
\examples{

## using coral dataset (It takes for a whiles)
\donttest{
data(coral)
tree<-coral$tree
traitset<-coral$traitset
sims<-1000
output<-ouxy(tree=tree,traitset=traitset,tol=0.1,sims= sims)

## OUTPUT THE FOLLOWING
## >output$s.mnlog

## $mnlogistic
## $mnlogistic$Prob
## oubmbm    oubmcir     ououbm    ououcir
## 0.03081341 0.01533086 0.40779579 0.54605995

## $mnlogistic$BayesF
##           oubmbm     oubmcir      ououbm     ououcir
## oubmbm   1.00000000  2.00989403  0.07556087  0.05642861
## oubmcir  0.49753867  1.00000000  0.03759446  0.02807542
## ououbm  13.23436292 26.59966708  1.00000000  0.74679673
## ououcir 17.72150620 35.61834960  1.33905246  1.00000000
##
## > output$table.out
##          alpha.y alpha.x alpha.tau theta.x theta.tau   sigma.x
## OUBMBM   4.3064      NA        NA      NA        NA  7.821074
## OUOUBM   4.1240  5.2119        NA -0.5759        NA 10.117253
## OUBMCIR  4.3720      NA    4.0736      NA    1.2326  7.825912
## OUOUCIR  3.1016  4.4269    3.9930  0.0668    1.2702  9.226803
## GLS          NA      NA        NA      NA        NA        NA
##
##           tau sigma.tau        b0         b1        b2
## OUBMBM  2.2403        NA 0.1678000 0.03850000 0.2874000
## OUOUBM  2.5021        NA 0.1651000 0.03260000 0.3146000
## OUBMCIR     NA  1.492548 0.1706000 0.03760000 0.3049000
## OUOUCIR     NA  1.516047 0.1661000 0.03480000 0.2549000
## GLS         NA        NA 0.1682413 0.03931911 0.3564761
}




}
