% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_overlap.R
\name{overview_overlap}
\alias{overview_overlap}
\title{overview_overlap}
\usage{
overview_overlap(
  dat1,
  dat2,
  dat1_id,
  dat2_id,
  dat1_name = "Data set 1",
  dat2_name = "Data set 2",
  plot_type = "bar"
)
}
\arguments{
\item{dat1}{A first data set object}

\item{dat2}{A second data set object}

\item{dat1_id}{Scope (e.g., country codes or individual IDs) of dat1.
It is important that both ID variables are exactly the same to generate
the perfect match.}

\item{dat2_id}{Scope (e.g., country codes or individual IDs) of dat2.
It is important that both ID variables are exactly the same to generate
the perfect match.}

\item{dat1_name}{Name of dat1 ("Data set 1" is the default)}

\item{dat2_name}{Name of dat2 ("Data set 2" is the default)}

\item{plot_type}{Type of plot ("bar" and "venn" are the two options) "venn"
relies on the ggvenn function}
}
\value{
A ggplot2 object (bar chart) that shows the overlap of two data sets.
}
\description{
Provides an overview of the overlap of two data sets.
    Cautionary note: This function is currently only preliminary workable
    and can only capture 2 data sets. We are working on an extension that
    allows to compare multiple data sets.
}
\examples{
\dontrun{
data(toydata)
toydata2 <- toydata[which(toydata$year > 1992), ]
overview_overlap(dat1 = toydata, dat2 = toydata2, dat1_id = ccode,
                 dat2_id = ccode)
}
}
