% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.Owl}
\alias{predict.Owl}
\alias{predict.OwlGaussian}
\alias{predict.OwlBinomial}
\alias{predict.OwlPoisson}
\alias{predict.OwlMultinomial}
\title{Generate predictions from owl models}
\usage{
\method{predict}{Owl}(object, x, sigma = NULL, type = "link", simplify = TRUE, ...)

\method{predict}{OwlGaussian}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response"),
  simplify = TRUE,
  ...
)

\method{predict}{OwlBinomial}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response", "class"),
  simplify = TRUE,
  ...
)

\method{predict}{OwlPoisson}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response"),
  exact = FALSE,
  simplify = TRUE,
  ...
)

\method{predict}{OwlMultinomial}(
  object,
  x,
  sigma = NULL,
  type = c("link", "response", "class"),
  exact = FALSE,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"owl"}, typically the result of
a call to \code{\link[=owl]{owl()}}}

\item{x}{new data}

\item{sigma}{penalty parameter for SLOPE models; if \code{NULL}, the
values used in the original fit will be used}

\item{type}{type of prediction; \code{"link"} returns the linear predictors,
\code{"response"} returns the result of applying the link function,
and \code{"class"} returns class predictions.}

\item{simplify}{if \code{TRUE}, \code{\link[base:drop]{base::drop()}} will be called before returning
the coefficients to drop extraneous dimensions}

\item{...}{ignored and only here for method consistency}

\item{exact}{if \code{TRUE} and the given parameter values differ from those in
the original fit, the model will be refit by calling \code{\link[stats:update]{stats::update()}} on
the object with the new parameters. If \code{FALSE}, the predicted values
will be based on interpolated coefficients from the original
penalty path.}
}
\value{
Predictions from the model with scale determined by \code{type}.
}
\description{
Return predictions from models fit by \code{\link[=owl]{owl()}}.
}
\examples{
fit <- with(mtcars, owl(cbind(mpg, hp), vs, family = "binomial"))
predict(fit, with(mtcars, cbind(mpg, hp)), type = "class")

}
\seealso{
\code{\link[stats:predict]{stats::predict()}}, \code{\link[stats:predict.glm]{stats::predict.glm()}}
}
