% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dtt_fast}
\alias{dtt_fast}
\title{Rcpp implementation of Felzenszwalb distance transfom}
\usage{
dtt_fast(x)
}
\arguments{
\item{x}{matrix of booleans of size \eqn{n x m} representing a (binary) image}
}
\value{
A matrix of size \eqn{n x m} containing the distance transform result. Note that this function does not perform any checks on \code{x}.
}
\description{
Rcpp wrapper for the distance transform algorithm described in Felzenszwalb and Huttenlocher (2012)
}
\examples{
# Create an image with a square
nc = 256
nr = 256
xx = matrix(FALSE,ncol=nc,nrow=nr)
xx[(nr/16):(nr/16*15-1),nc/16]<-rep(TRUE,nr/16*14)
xx[(nr/16):(nr/16*15-1),nc/16*15]<-rep(TRUE,nr/16*14)
xx[nr/16,(nc/16):(nc/16*15-1)]<-rep(TRUE,nc/16*14)
xx[nr/16*15,(nc/16):(nc/16*15-1)]<-rep(TRUE,nc/16*14)
# Compute Distance transform
zz<- dtt_fast(xx)
\donttest{
# Plot the results
image(xx,col=grey.colors(20), main="Original image")
image(zz,col=grey.colors(20), main="Distance transform")
}
}
\references{
Felzenszwalb, P. F. and Huttenlocher, D. P. (2012). Distance Transforms of Sampled Functions. Theory of Computing, 8(19):415-428.
}
\author{
Pedro Felzenszwalb for the header files \code{dt.h} and \code{misc.h} that do the work, Dario Azzimonti and Julien Bect for the wrapper.
}
