package_skeleton <- function(path, force = TRUE) {
    status <- "Package skeleton failed."
    if (isTRUE(force)) unlink(path, recursive = TRUE)
    suppressMessages(utils::package.skeleton(name = basename(path),
                                             path = dirname(path),
                            environment = new.env(),
                            force = force,
                            code_files = system.file("templates", "throw.R",
                                                     package = "packager")))
    unlink(file.path(path, "man"), recursive = TRUE)
    unlink(list.files(file.path(path, "R"), full.names = TRUE))
    unlink(file.path(path, "Read-and-delete-me"))
    writeLines(c("# Generated by roxygen2: do not edit by hand", ""),
               con = file.path(path, "NAMESPACE"))
    overwrite <- !fritools::is_false(getOption("packager")[["force"]])
    remove_lines(file_path = file.path(path, "DESCRIPTION"),
                 pattern = "^(Type|Maintainer|Date)",
                 overwrite = overwrite)
    desc::desc_set("RoxygenNote", fritools::get_package_version("roxygen2"),
                   file = path)
    desc::desc_set("Encoding", "UTF-8", file = path)
    me <- structure(list(list(given = "Andreas Dominik", family = "Cullmann",
                              role = c("aut", "cre"),
                              email = "fvafrcu@mailbox.org",
                              comment = NULL)), class = "person")
    d <- desc::desc_set_authors(authors = me, file = path, normalize = TRUE)
    status <- path
    return(invisible(status))
}
