% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_load_current_gh.R
\name{p_load_current_gh}
\alias{p_load_current_gh}
\title{Force Install and Load One or More GitHub Packages}
\usage{
p_load_current_gh(..., char, update = getOption("pac_update"),
  dependencies = TRUE)
}
\arguments{
\item{char}{Character vector containing repository address to load.  If you are calling
\code{p_load_gh} from within a function (or just having difficulties calling it 
using a character vector input) then pass your character vector of packages 
to load to this parameter directly.}

\item{update}{logical.  If \code{TRUE} will attempt to update all out of date 
packages.  Default allows the user to set a \code{"pac_update"} in his/her 
.Rprofile.}

\item{dependencies}{logical.  If \code{TRUE} necessary dependencies will be 
installed as well.}

\item{\ldots}{Repository address(es) in the format 
\code{username/repo[/subdir][@ref|#pull]}.  Note that this must be a character string.}
}
\description{
This function is a wrapper for \code{\link[devtools]{install_github}} and 
\code{\link[base]{require}}.  It checks to see if a 
package is installed, if not it attempts to install the package from 
\href{https://github.com}{GitHub}. Use this over \code{p_load_gh} if you
want to force install the most recent GitHub version of a package.
}
\examples{
\dontrun{
p_load_current_gh(c("Dasonk/Dmisc", "trinker/clustext", "trinker/termco"))
}
}
\seealso{
\code{\link[devtools]{install_github}}
\code{\link[base]{library}},
\code{\link[base]{require}}
}
