% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{pac_deps}
\alias{pac_deps}
\title{Package dependencies}
\usage{
pac_deps(
  pac,
  fields = c("Depends", "Imports", "LinkingTo"),
  lib.loc = NULL,
  base = FALSE,
  local = TRUE,
  description_v = FALSE,
  attr = TRUE,
  recursive = TRUE,
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{character a package name.}

\item{fields}{character vector with possible values \code{c("Depends", "Imports", "LinkingTo", "Suggests")}. Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{character vector. Is omitted for non NULL version. Default: NULL}

\item{base}{logical if to add base packages too. Default: FALSE}

\item{local}{logical if to use newest CRAN packages, where by default local ones are used. Default: TRUE}

\item{description_v}{if the dependencies version should be taken from description files, minimal required. Default: FALSE}

\item{attr}{logical specify if a package and its version should be added as a attribute of data.frame or for FALSE as a additional record. Default: TRUE}

\item{recursive}{logical if to assess the dependencies recursively. Default: TRUE}

\item{repos}{character the base URL of the repositories to use. Default \verb{https://cran.rstudio.com/}}
}
\value{
data.frame with packages and their versions. Versions are taken from \code{installed.packages} or newest released.
}
\description{
Package dependencies from DESCRIPTION files with installed or expected versions or newest released.
}
\examples{
pacs::pac_deps("stats", base = TRUE)$Package
pacs::pac_deps("memoise")$Package
pacs::pac_deps("memoise", description_v = FALSE)
# raw dependencies from DESCRIPTION file
pacs::pac_deps("memoise", description_v = TRUE, recursive = FALSE)
}
