% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cardinal_dates.R
\name{pa_cardinal_dates}
\alias{pa_cardinal_dates}
\alias{pa_cardinal_dates.numeric}
\alias{pa_cardinal_dates.Date}
\alias{pa_cardinal_dates.veg.index}
\title{Predict cardinal dates from satellite image data}
\usage{
pa_cardinal_dates(x, ...)

\method{pa_cardinal_dates}{numeric}(
  x,
  y,
  baseline.months = c(1:3, 12),
  model = c("none", "card3", "scard3", "agauss", "harmonic"),
  prior.means,
  prior.vars,
  bias.correction,
  ...
)

\method{pa_cardinal_dates}{Date}(
  x,
  y,
  baseline.months = c(1:3, 12),
  model = c("none", "card3", "scard3", "agauss", "harmonic"),
  prior.means,
  prior.vars,
  bias.correction,
  ...
)

\method{pa_cardinal_dates}{veg.index}(
  x,
  y = NULL,
  baseline.months = c(1:3, 12),
  model = c("none", "card3", "scard3", "agauss", "harmonic"),
  prior.means,
  prior.vars,
  bias.correction,
  ...
)
}
\arguments{
\item{x}{vector containing the date or day of the year of that
the satellite data was collected}

\item{...}{ignored}

\item{y}{vector containing the satellite data value}

\item{baseline.months}{vector containing the months used as a baseline reference for 
when there are no crops in the field. For example, c(1:3, 12) represent Jan, Feb, Mar, and Dec.}

\item{model}{a string naming the model to be used to estimate cardinal dates}

\item{prior.means}{a vector of length three containing the prior means for cardinal dates}

\item{prior.vars}{a vector of length three containing the prior variances for cardinal dates}

\item{bias.correction}{a vector of length three containing the bias correction factor for cardinal dates}
}
\value{
when x is a vector, returns a vector of length 3 with the predicted
cardinal dates. When x is a veg.index object, returns a stars object with 
spatially distributed cardinal dates
}
\description{
Predict cardinal dates from satellite image data
}
\examples{
\dontrun{
x <- seq(1, 365, 6)
y <- nlraa::scard3(x, 120, 210, 300)
pa_cardinal_dates.vector(
  x = x,
  y = y,
  model = 'scard3',
  prior.means = c(130, 190, 297),
  prior.vars = c(11, 13, 18),
  bias.correction = c(10, 10, 10)
)
}

}
