% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{top_articles}
\alias{top_articles}
\title{Retrieve Data on Top Articles}
\usage{
top_articles(
  project = "en.wikipedia",
  platform = "all",
  start = as.Date("2015-10-01"),
  granularity = "daily",
  reformat = TRUE,
  ...
)
}
\arguments{
\item{project}{the name of the project, structured as \code{[language_code].[project]}
(see the default).}

\item{platform}{The platform the pageviews came from; one or more of  "all", "desktop", "mobile-web" and
"mobile-app". Set to "all" by default.}

\item{start}{The date the articles were "top" in. 2015 by default.}

\item{granularity}{the granularity of data to return; "daily" or "monthly", depending on
whether top articles should reflect trends in day or month of the \code{start} date.}

\item{reformat}{Whether to reformat the results as a \code{\link{data.frame}} or not. TRUE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
\code{top_articles} grabs data on the top articles for a project
in a given time period, and for a particular platform.
}
\examples{
# Basic example
enwiki_top_articles <- top_articles()

# Use a narrower platform
enwiki_mobile_top <- top_articles(platform = "mobile-web")

}
\seealso{
\code{\link{article_pageviews}} for per-article pageviews and \code{\link{project_pageviews}} for
per-project pageviews.
}
