% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_comparisons.R
\name{pairwise_caption}
\alias{pairwise_caption}
\title{Pairwise comparison test expression}
\usage{
pairwise_caption(
  caption,
  test.description,
  pairwise.display = "significant",
  ...
)
}
\arguments{
\item{caption}{Additional text to be included in the plot.}

\item{test.description}{Text describing the details of the test.}

\item{pairwise.display}{Decides \emph{which} pairwise comparisons to display.
Available options are:
\itemize{
\item \code{"significant"} (abbreviation accepted: \code{"s"})
\item \code{"non-significant"} (abbreviation accepted: \code{"ns"})
\item \code{"all"}
}

You can use this argument to make sure that your plot is not uber-cluttered
when you have multiple groups being compared and scores of pairwise
comparisons being displayed.}

\item{...}{Ignored.}
}
\description{
This returns an expression containing details about the pairwise comparison
test and the \emph{p}-value adjustment method. These details are typically
included in the \code{ggstatsplot} package plots as a caption.
}
\examples{
library(pairwiseComparisons)
pairwise_caption("my caption", "Student's t-test")
}
