% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointsig.r, R/plot.js.R
\name{jointsig}
\alias{jointsig}
\alias{plot.js}
\title{Test if two variables jointly control changes in fossil data}
\usage{
jointsig(spp, fos, var1, var2, method = "randomTF", n = 99, r = 32, ...)

\method{plot}{js}(x, names.v1, names.v2, ...)
}
\arguments{
\item{spp}{Data frame of modern training set species data, transformed as
required, for example with sqrt}

\item{fos}{Data frame of fossil species data, with same species codes and
transformations as spp}

\item{var1}{Training set environmental variable 1}

\item{var2}{Training set environmental variable 2}

\item{method}{Which significance test to use.
Current option are randomTF and obs.cor.
The latter may give strange results - use with caution.}

\item{n}{number of random training sets used to generate the null model}

\item{r}{How many synthetic variables to make. More is better but slower}

\item{\dots}{Other arguments to plot}

\item{x}{Output from jointsig}

\item{names.v1}{Vector length 2 with names of the end members of the first
environmental variable, e.g., c("cold", "warm") for temperature.}

\item{names.v2}{Ditto for the second variable.}
}
\value{
A list with components
\itemize{
\item{PCA}{ The unconstrained ordination of the fossil data.}
\item{preds}{ A list of the containing the reconstructions for each
environmental variable.}
\item{MAX}{ Proportion of the variance explained by the first axis of the
unconstrained ordination. This is the maximum amount that a reconstruction
of a single variable can explain.}
\item{EX}{ The proportion of the variance in the fossil data explained by
each reconstruction.}
\item{sim.ex}{ The proportion of variance explained by each of the random
environmental variables.}
\item{sig}{ The p-value of each reconstruction.}
}
}
\description{
Generates synthetic variables with different proportion of two
environmental variables, and tests how much variance in the fossil data
reconstructions of these synthetic variables explain.
}
\details{
With \code{method="randomTF"}, the function calculates the proportion of
variance in the fossil data explained by transfer function reconstructions of
synthetic variables.
The synthetic variables are composed of two environmental variables, weighted
between -1 and +1, so to represent a circle.
This is compared with a null distribution of the proportion of variance
explained by reconstructions based on random environmental variables.
Any transfer function in the rioja library can be used.
With method="obs.cor", the aim is the same, but the function reports the
correlation between the species weighted average optima on the synthetic
variables and the species first axis scores.
This option has some pathological behaviour and should probably be avoided.
}
\section{Functions}{
\itemize{
\item \code{plot(js)}: Plot js object

}}
\examples{
require(rioja)
data(SWAP)
data(RLGH)

rlgh.js <- jointsig(
  spp = sqrt(SWAP$spec),
  fos = sqrt(RLGH$spec),
  var1 = SWAP$pH,
  var2 = sample(SWAP$pH),
  method = "randomTF",
  n = 49, r = 32, fun = WA, col = 1
)
# nonsense second variable

plot(rlgh.js, c("acid", "alkaline"), c("down", "up"))
}
\references{
Unpublished method - use with caution. Can give spurious results
with weighted averaging.
}
\seealso{
\code{\link{randomTF}},\code{\link{obs.cor}}
}
\author{
Richard Telford \email{richard.telford@bio.uib.no}
}
\keyword{hplot}
\keyword{htest}
\keyword{multivariate}
