% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potveg.R
\name{potveg}
\alias{potveg}
\title{potveg}
\usage{
potveg(ID, classif = "rf99", buffer = NULL)
}
\arguments{
\item{ID}{An object of the class "pfSiteSel"}

\item{classif}{Potential vegetation to be used: "rf99" in reference to
Ramankutty and Foley (1999) or "l12" in reference to Levavasseur et al.
2012.}

\item{buffer}{Distance in m that defines a radius around each site to
calculate the dominant vegetation type by kernel density estimation.}
}
\value{
An object of the class "potveg" i.e. a list contaning two data
frames: "site_data" for charcoal sites and associated potential vegetation
type, "map" data frame used for mapping data. See \code{\link{plot.potveg}}
for details.
}
\description{
Retrieve potential vegetation types based on charcoal sites location
}
\examples{


 \dontrun{
require(paleofire)
ID=pfSiteSel(c(1:10))
obj=potveg(ID,classif="l12")
head(obj$site_data)
}

}
\author{
O. Blarquez
}
\references{
Ramankutty, N., and J.A. Foley (1999). Estimating historical
changes in global land cover: croplands from 1700 to 1992, Global
Biogeochemical Cycles 13(4), 997-1027.\cr \cr Levavasseur, G., M. Vrac, D.
M. Roche, and D. Paillard. 2012. Statistical modelling of a new global
potential vegetation distribution. Environmental Research Letters 7:044019.
}
\seealso{
\code{\link{plot.potveg}}
}
\keyword{~kwd1}
\keyword{~kwd2}

