% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaleoRegion.R
\name{PaleoRegion}
\alias{PaleoRegion}
\title{R6 class representing a paleontological region.}
\description{
\code{\link[R6:R6Class]{R6}} class representing a study region of temporally changing
spatial grid cells, defined via a \emph{RasterLayer} object
(see \code{\link[raster:raster-package]{raster}}) and a temporal mask indicating
which cells are included at each time step.
}
\examples{
library(poems)
library(raster)
# Ring Island example region
coordinates <- data.frame(x = rep(seq(-178.02, -178.06, -0.01), 5),
                          y = rep(seq(19.02, 19.06, 0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
sealevel_raster <- template_raster
template_raster[][c(7:9, 12:14, 17:19)] <- NA # make Ring Island
sealevel_raster[][c(7:9, 12:14, 17:18)] <- NA
raster_stack <- raster::stack(x = append(replicate(9, template_raster), sealevel_raster))
region <- PaleoRegion$new(template_raster = raster_stack)
raster::plot(region$temporal_mask_raster()[[1]], main = "Ring Island (first timestep)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue", legend = FALSE)
raster::plot(region$temporal_mask_raster()[[10]], main = "Ring Island (last timestep)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue", legend = FALSE)

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:Region]{poems::Region}} -> \code{PaleoRegion}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{region_raster}}{A \emph{RasterLayer} object (see \code{\link[raster:raster-package]{raster}}) defining the region with finite values (NAs elsewhere).}

\item{\code{use_raster}}{Boolean to indicate that a raster is to be used to define the region (default TRUE).}

\item{\code{strict_consistency}}{Boolean to indicate that, as well as resolution, extent and CRS, consistency checks also ensure that a raster's finite/occupiable cells are the same or a subset of those defined by the region (default TRUE).}

\item{\code{temporal_mask}}{Matrix of booleans indicating which region cells are included at each time step.}

\item{\code{region_cells}}{Dynamically calculated number of region coordinates or raster cells with finite/non-NA values.}

\item{\code{region_indices}}{Dynamically calculated region indices for raster cells with finite/non-NA values (all if not a raster).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PaleoRegion$new()}}
\item \href{#method-raster_from_values}{\code{PaleoRegion$raster_from_values()}}
\item \href{#method-temporal_mask_raster}{\code{PaleoRegion$temporal_mask_raster()}}
\item \href{#method-clone}{\code{PaleoRegion$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericClass" data-id="new_clone">}\href{../../poems/html/GenericClass.html#method-new_clone}{\code{poems::GenericClass$new_clone()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="Region" data-id="raster_is_consistent">}\href{../../poems/html/Region.html#method-raster_is_consistent}{\code{poems::Region$raster_is_consistent()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets temporally changing raster layers for paleontological region.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoRegion$new(template_raster = NULL, remove_zeros = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{template_raster}}{A \emph{RasterLayer}, \emph{RasterBrick}, or \emph{RasterStack} object (see \code{\link[raster:raster-package]{raster}}) defining the paleontological region with example finite values (NAs elsewhere)}

\item{\code{remove_zeros}}{Boolean to indicate that cells that are zero across all layers (times) are to be removed, i.e. set to NA (default is FALSE).}

\item{\code{...}}{Additional parameters passed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-raster_from_values"></a>}}
\if{latex}{\out{\hypertarget{method-raster_from_values}{}}}
\subsection{Method \code{raster_from_values()}}{
Converts an array (or matrix) of values into a raster (or stack) consistent with the region raster (matching extent, resolution, and finite/NA cells), and with the temporal mask (if any) applied.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoRegion$raster_from_values(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{An array (or matrix) of values to be placed in the raster (or stack) having dimensions consistent with the region cell number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \emph{RasterLayer} (or \emph{RasterStack/Brick}) object consistent with the region raster with temporal mask (if any) applied.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-temporal_mask_raster"></a>}}
\if{latex}{\out{\hypertarget{method-temporal_mask_raster}{}}}
\subsection{Method \code{temporal_mask_raster()}}{
Returns the temporal mask as a raster stack/brick object consistent with the region raster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoRegion$temporal_mask_raster()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \emph{RasterStack/Brick}) object with temporal mask values of 1 (true) and NA elsewhere.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaleoRegion$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
