% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProgressTrackingContext.R
\name{ProgressTrackingContext}
\alias{ProgressTrackingContext}
\title{ProgressTrackingContext}
\description{
This class represents a progress tracking context for interacting with
\code{\link{Backend}} implementations via the \code{\link{BackendService}}
interface.
}
\details{
This class extends the base \code{\link{Context}} class and overrides the
\code{\link[=Context]{sapply}} parent method to decorate the backend instance
with additional functionality. Specifically, this class creates a temporary
file to log the progress of backend tasks, and then creates a progress bar to
display the progress of the backend tasks.

The progress bar is updated after each backend task execution. The timeout
between subsequent checks of the temporary log file is controlled by the
\code{\link{Options}} class and defaults to \code{0.001}. This value can be
adjusted via the \code{\link{Options}} instance present in the session
\code{\link[base:options]{base::.Options}} list (i.e., see \code{\link[=set_option]{set_option()}}). For example, to
set the timeout to \code{0.1} we can run \code{set_option("progress_timeout", 0.1)}.

This class is a good example of how to extend the base \code{\link{Context}}
class to decorate the backend instance with additional functionality.
}
\examples{
# Define a task to run in parallel.
task <- function(x, y) {
    # Sleep a bit.
    Sys.sleep(0.15)

    # Return the result of a computation.
    return(x + y)
}

# Create a specification object.
specification <- Specification$new()

# Set the number of cores.
specification$set_cores(cores = 2)

# Set the cluster type.
specification$set_type(type = "psock")

# Create a backend factory.
backend_factory <- BackendFactory$new()

# Get a backend instance that does not support progress tracking.
backend <- backend_factory$get("sync")

# Create a progress tracking context object.
context <- ProgressTrackingContext$new()

# Attempt to set the incompatible backend instance.
try(context$set_backend(backend))

# Get a backend instance that does support progress tracking.
backend <- backend_factory$get("async")

# Register the backend with the context.
context$set_backend(backend)

# From now all, all backend operations are intercepted by the context.

# Start the backend.
context$start(specification)

# Create a bar factory.
bar_factory <- BarFactory$new()

# Get a modern bar instance.
bar <- bar_factory$get("modern")

# Register the bar with the context.
context$set_bar(bar)

# Configure the bar.
context$configure_bar(
    show_after = 0,
    format = " > completed :current out of :total tasks [:percent] [:elapsed]"
)

# Run a task in parallel (i.e., approx. 1.9 seconds).
context$sapply(x = 1:25, fun = task, y = 10)

# Get the task output.
backend$get_output(wait = TRUE)

# Change the bar type.
bar <- bar_factory$get("basic")

# Register the bar with the context.
context$set_bar(bar)

# Remove the previous bar configuration.
context$configure_bar()

# Run a task in parallel (i.e., approx. 1.9 seconds).
context$sapply(x = 1:25, fun = task, y = 10)

# Get the task output.
backend$get_output(wait = TRUE)

# Close the backend.
context$stop()

}
\seealso{
\code{\link{Context}}, \code{\link{BackendService}}, \code{\link{Backend}}, and
\code{\link{AsyncBackend}}.
}
\section{Super classes}{
\code{\link[parabar:BackendService]{parabar::BackendService}} -> \code{\link[parabar:Context]{parabar::Context}} -> \code{ProgressTrackingContext}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{bar}}{The \code{\link{Bar}} instance registered with the context.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ProgressTrackingContext-set_backend}{\code{ProgressTrackingContext$set_backend()}}
\item \href{#method-ProgressTrackingContext-set_bar}{\code{ProgressTrackingContext$set_bar()}}
\item \href{#method-ProgressTrackingContext-configure_bar}{\code{ProgressTrackingContext$configure_bar()}}
\item \href{#method-ProgressTrackingContext-sapply}{\code{ProgressTrackingContext$sapply()}}
\item \href{#method-ProgressTrackingContext-lapply}{\code{ProgressTrackingContext$lapply()}}
\item \href{#method-ProgressTrackingContext-apply}{\code{ProgressTrackingContext$apply()}}
\item \href{#method-ProgressTrackingContext-clone}{\code{ProgressTrackingContext$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="clear"><a href='../../parabar/html/Context.html#method-Context-clear'><code>parabar::Context$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="evaluate"><a href='../../parabar/html/Context.html#method-Context-evaluate'><code>parabar::Context$evaluate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="export"><a href='../../parabar/html/Context.html#method-Context-export'><code>parabar::Context$export()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="get_output"><a href='../../parabar/html/Context.html#method-Context-get_output'><code>parabar::Context$get_output()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="initialize"><a href='../../parabar/html/Context.html#method-Context-initialize'><code>parabar::Context$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="peek"><a href='../../parabar/html/Context.html#method-Context-peek'><code>parabar::Context$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="start"><a href='../../parabar/html/Context.html#method-Context-start'><code>parabar::Context$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="parabar" data-topic="Context" data-id="stop"><a href='../../parabar/html/Context.html#method-Context-stop'><code>parabar::Context$stop()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressTrackingContext-set_backend"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressTrackingContext-set_backend}{}}}
\subsection{Method \code{set_backend()}}{
Set the backend instance to be used by the context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressTrackingContext$set_backend(backend)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backend}}{An object of class \code{\link{Backend}} that supports
progress tracking implements the \code{\link{BackendService}}
interface.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method overrides the parent method to validate the backend
provided and guarantee it is an instance of the
\code{\link{AsyncBackend}} class.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressTrackingContext-set_bar"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressTrackingContext-set_bar}{}}}
\subsection{Method \code{set_bar()}}{
Set the \code{\link{Bar}} instance to be used by the context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressTrackingContext$set_bar(bar)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bar}}{An object of class \code{\link{Bar}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressTrackingContext-configure_bar"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressTrackingContext-configure_bar}{}}}
\subsection{Method \code{configure_bar()}}{
Configure the \code{\link{Bar}} instance registered with the context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressTrackingContext$configure_bar(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{A list of named arguments passed to the \code{create()} method
of the \code{\link{Bar}} instance. See the documentation of the
specific concrete bar for details (e.g., \code{\link{ModernBar}}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressTrackingContext-sapply"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressTrackingContext-sapply}{}}}
\subsection{Method \code{sapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parSapply()}}, but with
a progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressTrackingContext$sapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressTrackingContext-lapply"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressTrackingContext-lapply}{}}}
\subsection{Method \code{lapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parLapply()}}, but with
a progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressTrackingContext$lapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressTrackingContext-apply"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressTrackingContext-apply}{}}}
\subsection{Method \code{apply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parApply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressTrackingContext$apply(x, margin, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An array to pass to the \code{fun} function.}

\item{\code{margin}}{A numeric vector indicating the dimensions of \code{x} the
\code{fun} function should be applied over. For example, for a matrix,
\code{margin = 1} indicates applying \code{fun} rows-wise, \code{margin = 2}
indicates applying \code{fun} columns-wise, and \code{margin = c(1, 2)}
indicates applying \code{fun} element-wise. Named dimensions are also
possible depending on \code{x}. See \code{\link[parallel:clusterApply]{parallel::parApply()}} and
\code{\link[base:apply]{base::apply()}} for more details.}

\item{\code{fun}}{A function to apply to \code{x} according to the \code{margin}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProgressTrackingContext-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ProgressTrackingContext-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProgressTrackingContext$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
