% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Param.R
\name{Param}
\alias{Param}
\title{Param Object}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Abstract base class for parameters.
}
\section{Construction}{
\preformatted{Param$new(id, special_vals, default, tags)
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
ID of this parameter.
\item \code{special_vals} :: \code{list()}\cr
Arbitrary special values this parameter is allowed to take, to make it feasible.
This allows extending the domain of the parameter.
Note that these values are only used in feasibility checks, neither in generating designs nor sampling.
\item \code{default} :: \code{any} \cr
Default value. Can be from the domain of the parameter or an element of \code{special_vals}.
Has value \link{NO_DEF} if no default exists. \code{NULL} can be a valid default.
\item \code{tags} :: \code{character()}\cr
Arbitrary tags to group and subset parameters. Some tags serve a special purpose:
\itemize{
\item \code{"required"} implies that the parameters has to be given when setting \code{values} in \link{ParamSet}.
}
}
}

\section{Fields}{

\itemize{
\item \code{class} :: \code{character(1)}\cr
R6 class name. Read-only.
\item \code{is_number} :: \code{logical(1)}\cr
TRUE if the parameter is of type \code{"dbl"} or \code{"int"}.
\item \code{is_categ} :: \code{logical(1)}\cr
TRUE if the parameter is of type \code{"fct"} or \code{"lgl"}.
\item \code{has_default} :: \code{logical(1)}\cr
Is there a default value?
\item \code{storage_type} :: \code{character(1)} \cr
Data type when values of this parameter are stored in a data table or sampled.
}
}

\section{Methods}{

\itemize{
\item \code{test(x)}, \code{check(x)}, \code{assert(x)}\cr
Three \pkg{checkmate}-like check-functions.
Take a value from the domain of the parameter, and check if it is feasible.
A value is feasible if it is of the same \code{storage_type}, inside of the bounds or element of \code{special_vals}.
\item \code{qunif(x)}\cr
\code{numeric(n)} -> \code{vector(n)} \cr
Takes values from [0,1] and map them, regularly distributed, to the domain of the parameter.
Think of: quantile function or the use case to map a uniform-[0,1] random variable into a uniform sample from this param.
\item \code{rep(n)}\cr
\code{integer(1)} -> \link{ParamSet}\cr
Repeats this parameter n-times (by cloning).
Each parameter is named "[id]\emph{rep}[k]" and gets the additional tag "[id]_rep".
}
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table()} \cr
\link{Param} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Converts param to \code{\link[data.table:data.table]{data.table::data.table()}} with 1 row. See \link{ParamSet}.
}
}

\seealso{
Other Params: 
\code{\link{ParamDbl}},
\code{\link{ParamFct}},
\code{\link{ParamInt}},
\code{\link{ParamLgl}},
\code{\link{ParamUty}}
}
\concept{Params}
