% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sn.R
\name{moment2sn}
\alias{moment2sn}
\title{Solve Skew-Normal Parameters from Moments}
\usage{
moment2sn(mean = 0, sd = 1, skewness)
}
\arguments{
\item{mean}{\link[base]{numeric} scalar, mean \eqn{\mu}, default value 0}

\item{sd}{\link[base]{numeric} scalar, standard deviation \eqn{\sigma}, default value 1}

\item{skewness}{\link[base]{numeric} scalar}
}
\value{
Function \link{moment2sn} returns a \link[base]{length}-3
\link[base]{numeric} \link[base]{vector} \eqn{(\xi, \omega, \alpha)}.
}
\description{
Solve skew-normal parameters from mean, standard deviation and skewness.
}
\details{
Function \link{moment2sn} solves the
location \eqn{\xi}, scale \eqn{\omega} and slant \eqn{\alpha} parameters
of skew-normal distribution,
from user-specified mean \eqn{\mu} (default 0), standard deviation \eqn{\sigma} (default 1) and
skewness.
}
\examples{
moment2sn(skewness = .3)

}
