% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_values_mixed.R
\name{p_value.lmerMod}
\alias{p_value.lmerMod}
\alias{p_value.merMod}
\alias{p_value.glmmTMB}
\alias{p_value.MixMod}
\alias{p_value.mixor}
\title{p-values for Mixed Models}
\usage{
\method{p_value}{lmerMod}(model, method = "wald", ...)

\method{p_value}{merMod}(model, method = "wald", ...)

\method{p_value}{glmmTMB}(
  model,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion"),
  verbose = TRUE,
  ...
)

\method{p_value}{MixMod}(
  model,
  component = c("all", "conditional", "zi", "zero_inflated"),
  verbose = TRUE,
  ...
)

\method{p_value}{mixor}(model, effects = c("all", "fixed", "random"), ...)
}
\arguments{
\item{model}{A statistical model.}

\item{method}{For mixed models, can be \code{\link[=p_value_wald]{"wald"}} (default), \code{\link[=p_value_ml1]{"ml1"}}, \code{\link[=p_value_betwithin]{"betwithin"}}, \code{\link[=p_value_satterthwaite]{"satterthwaite"}} or \code{\link[=p_value_kenward]{"kenward"}}. For models that are supported by the \pkg{sandwich} or \pkg{clubSandwich} packages, may also be \code{method = "robust"} to compute p-values based ob robust standard errors.}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed. Only available for models where \code{method = "robust"} is supported.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{verbose}{Toggle warnings and messages.}

\item{effects}{Should standard errors for fixed effects or random effects
be returned? Only applies to mixed models. May be abbreviated. When
standard errors for random effects are requested, for each grouping factor
a list of standard errors (per group level) for random intercepts and slopes
is returned.}
}
\value{
A data frame with at least two columns: the parameter names and the p-values. Depending on the model, may also include columns for model components etc.
}
\description{
This function attempts to return, or compute, p-values of mixed models.
}
\details{
By default, p-values are based on Wald-test approximations (see \code{\link{p_value_wald}}). For certain situations, the "m-l-1" rule might be a better approximation. That is, for \code{method = "ml1"}, \code{\link{p_value_ml1}} is called. For \code{lmerMod} objects, if \code{method = "kenward"}, p-values are based on Kenward-Roger approximations, i.e. \code{\link{p_value_kenward}} is called, and \code{method = "satterthwaite"} calls \code{\link{p_value_satterthwaite}}.
}
\note{
\code{p_value_robust()} resp. \code{p_value(method = "robust")}
  rely on the \pkg{sandwich} or \pkg{clubSandwich} package (the latter if
  \code{vcov_estimation = "CR"} for cluster-robust standard errors) and will
  thus only work for those models supported by those packages.
}
\examples{
if (require("lme4")) {
  data(iris)
  model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
  p_value(model)
}
}
