% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_clusters.R
\name{n_clusters}
\alias{n_clusters}
\title{Number of clusters to extract}
\usage{
n_clusters(
  x,
  standardize = TRUE,
  force = FALSE,
  package = c("NbClust", "mclust", "cluster", "M3C"),
  fast = TRUE,
  ...
)
}
\arguments{
\item{x}{A data frame.}

\item{standardize}{Standardize the dataframe before clustering (default).}

\item{force}{Logical, if \code{TRUE}, factors are converted to numerical
values in order to be included in the data for determining the number of
clusters. By default, factors are removed, because most methods that
determine the number of clusters need numeric input only.}

\item{package}{Package from which methods are to be called to determine the
number of clusters. Can be \code{"all"} or a vector containing
\code{"NbClust"}, \code{"mclust"}, \code{"cluster"} and \code{"M3C"}.}

\item{fast}{If \code{FALSE}, will compute 4 more indices (sets \code{index =
"allong"} in \code{NbClust}). This has been deactivated by default as it is
computationally heavy.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
This function runs many existing procedures for determining how many clusters
are present in data. It returns the number of clusters based on the maximum
consensus. In case of ties, it will select the solution with fewer clusters.
}
\note{
There is also a \href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
library(parameters)
\donttest{
if (require("mclust", quietly = TRUE) && require("NbClust", quietly = TRUE) &&
  require("cluster", quietly = TRUE)) {
  n_clusters(iris[, 1:4], package = c("NbClust", "mclust", "cluster"))
}
}
}
