% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_p_value.R, R/methods_emmeans.R
\name{p_value}
\alias{p_value}
\alias{p_value.default}
\alias{p_value.emmGrid}
\title{p-values}
\usage{
p_value(model, ...)

\method{p_value}{default}(
  model,
  dof = NULL,
  method = NULL,
  component = "all",
  vcov = NULL,
  vcov_args = NULL,
  verbose = TRUE,
  ...
)

\method{p_value}{emmGrid}(model, ci = 0.95, adjust = "none", ...)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Additional arguments}

\item{dof}{Number of degrees of freedom to be used when calculating
confidence intervals. If \code{NULL} (default), the degrees of freedom are
retrieved by calling \code{\link[=degrees_of_freedom]{degrees_of_freedom()}} with
approximation method defined in \code{method}. If not \code{NULL}, use this argument
to override the default degrees of freedom used to compute confidence
intervals.}

\item{method}{For linear mixed models, \code{method} can be
\code{\link[=p_value_kenward]{"kenward"}} or
\code{\link[=p_value_satterthwaite]{"satterthwaite"}}.}

\item{component}{Model component for which parameters should be shown. See
the documentation for your object's class in \code{\link[=model_parameters]{model_parameters()}} for
further details.}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance matrix,
a function which returns a covariance matrix, or a string which identifies
the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"vcovHC"}, \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}.
\item Cluster-robust: \code{"vcovCR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"}, \code{"CR2"}, \code{"CR3"}. See \code{?clubSandwich::vcovCR}.
\item Bootstrap: \code{"vcovBS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"}, \code{"webb"}. See \code{?sandwich::vcovBS}.
\item Other \code{sandwich} package functions: \code{"vcovHAC"}, \code{"vcovPC"}, \code{"vcovCL"}, \code{"vcovPL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the \emph{sandwich}
or \emph{clubSandwich} packages. Please refer to their documentation (e.g.,
\code{?sandwich::vcovHAC}) to see the list of available arguments.}

\item{verbose}{Toggle warnings and messages.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{adjust}{Character value naming the method used to adjust p-values or
confidence intervals. See \code{?emmeans::summary.emmGrid} for details.}
}
\value{
A data frame with at least two columns: the parameter names and the
p-values. Depending on the model, may also include columns for model
components etc.
}
\description{
This function attempts to return, or compute, p-values of a model's
parameters. See the documentation for your object's class:
\itemize{
\item{\link[=p_value.BFBayesFactor]{Bayesian models} (\pkg{rstanarm}, \pkg{brms}, \pkg{MCMCglmm}, ...)}
\item{\link[=p_value.zeroinfl]{Zero-inflated models} (\code{hurdle}, \code{zeroinfl}, \code{zerocount}, ...)}
\item{\link[=p_value.poissonmfx]{Marginal effects models} (\pkg{mfx})}
\item{\link[=p_value.DirichletRegModel]{Models with special components} (\code{DirichletRegModel}, \code{clm2}, \code{cgam}, ...)}
}
}
\examples{
data(iris)
model <- lm(Petal.Length ~ Sepal.Length + Species, data = iris)
p_value(model)
}
