% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merlinLod.R
\name{merlinLod}
\alias{merlinLod}
\title{Multipoint LOD scores by MERLIN}
\usage{
merlinLod(
  x,
  aff,
  model,
  map = NULL,
  markers = NULL,
  rho = 0,
  liability = NULL,
  maxOnly = NA,
  options = "",
  dir = tempdir(),
  cleanup = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{aff}{A vector naming the affected pedigree members, or a numeric vector
of length \code{pedsize(x)} with affection statuses for all pedigree members (2
= affected; 1 = unaffected; 0 = unknown). Alternatively, \code{aff} can be a
list of vectors, named \code{affected}, \code{unaffected} and \code{unknown}. It suffices
to give (any) two of these vectors.}

\item{model}{A \code{disModel} object, typically created with \code{\link[=diseaseModel]{diseaseModel()}}.}

\item{map}{A data frame with columns according to MERLIN format for map
files.}

\item{markers}{A vector of marker names or indices referring to markers
attached to \code{x}. By default all markers are included.}

\item{rho}{A numeric with values between 0 and 0.5: The recombination
value(s) for which the LOD score is computed. The value of \code{rho} is
converted to centiMorgans using Haldane's map function and included in the
MERLIN command using the \code{--position} parameter.

Note: This parameter only works when \code{markers} has length 1.}

\item{liability}{NULL (default) or a vector of length \code{pedsize(x)} indicating
the liability class (a row number of \code{model$penetrances}) of each
individual.}

\item{maxOnly}{a logical indicating whether only the maximum LOD score should
be returned. By default this is always done if the number of markers is 1.}

\item{options}{A character with additional options to the MERLIN command.}

\item{dir}{Path to a directory where the MERLIN input files should be
created.}

\item{cleanup}{A logical indicating if MERLIN files should be removed after
use. Default: TRUE.}

\item{verbose}{a logical: verbose output or not.}

\item{\dots}{Further arguments passed on to \code{\link[pedprobr:merlin]{pedprobr::merlin()}}. In
particular, \code{merlinpath} should be supplied if the merlin executables are
not on the system's search path.}
}
\value{
If the number of markers is 1, or if \code{maxOnly = TRUE}, a single
number is returned.

Otherwise a \code{linkres} object similar to the output of \code{\link[=lod]{lod()}}, but with an
additional column \code{CM}.
}
\description{
This function is a wrapper for the parametric linkage functionality of the
MERLIN software. For this to work, MERLIN must be installed and correctly
pointed to in the PATH environment variable.
}
\details{
By default the following MERLIN command is run (via a call to \code{\link[=system]{system()}})
after creating appropriate files in a temporary (or user specified) directory:

\preformatted{% merlin -p _merlin.ped -d _merlin.dat -m _merlin.map -f
_merlin.freq --model _merlin.model --tabulate --markerNames --quiet}

The resulting multipoint LOD scores are extracted from the output and
returned in R as a \link{linkres} object.
}
\examples{

#---------------------------------
# Requires MERLIN to be installed
#---------------------------------

if(nzchar(Sys.which("merlin"))) {

# Pedigree with a single marker
x = nuclearPed(3, sex = c(1,2,2))
x = setMarkers(x, marker(x, geno = c("1/1", "1/2", "1/2", "1/2", "1/2")))

# Simple AD model
merlinLod(x, aff = 2:5, model = diseaseModel("AD"))

# With liability classes
mod = diseaseModel("AD", penetrances = cbind(f0 = 0, f1 = 1:0, f2 = 1:0))
merlinLod(x, aff = 2:4, mod, liability = c(1,1,1,1,2))

# X
merlinLod(x, aff = 3:5, model = diseaseModel("XR"))

}

}
\references{
\url{http://csg.sph.umich.edu/abecasis/Merlin/}
}
\seealso{
\code{\link[=lod]{lod()}}
}
