% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.paramtest}
\alias{summary.paramtest}
\title{Print summary of parameter tests.}
\usage{
\method{summary}{paramtest}(object, ...)
}
\arguments{
\item{object}{An object of class 'paramtest'.}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
Returns a data frame with one row per set of unique tests.
}
\description{
\code{summary.paramtest} provides a summary of the various combinations of
parameter values tested in a given parameter test.
}
\examples{
lm_test <- function(iter, N, b0, b1) {
    x <- rnorm(N, 0, 1)
    y <- rnorm(N, b0 + b1*x, sqrt(1 - b1^2))
    data <- data.frame(y, x)
    model <- lm(y ~ x, data)

    # capture output from model summary
    est <- coef(summary(model))['x', 'Estimate']
    se <- coef(summary(model))['x', 'Std. Error']
    p <- coef(summary(model))['x', 'Pr(>|t|)']

    return(c(xm=mean(x), xsd=sd(x), ym=mean(y), ysd=sd(y), est=est, se=se, p=p,
        sig=est > 0 & p <= .05))
}

# test power for sample sizes between N=200 and N=300, with 500 iterations total
power_sim <- random_search(lm_test, params=list(N=c(200, 300)), n.iter=500, b0=0, b1=.15)
summary(power_sim)
}
\seealso{
\code{\link{run_test}}
}
