% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_mrn.R
\encoding{UTF-8}
\name{pretty_mrn}
\alias{pretty_mrn}
\title{Converts MRN integer to string compatible with RPDR.}
\usage{
pretty_mrn(v, prefix = "MGH", sep = ":", id_length = "standard", nThread = 1)
}
\arguments{
\item{v}{vector, integer or sting vector with MRNs.}

\item{prefix}{string or vector, hospital ID from where the MRNs are from. Defaults to \emph{MGH}. If a vector is provided then it must be the same length as \emph{v}.
This allows to potentially use different prefixes for different IDs using the same vector of values.}

\item{sep}{string, divider between hospital ID and MRN. Defaults to \emph{:}.}

\item{id_length}{string, indicating whether to modify MRN length based-on required values \emph{id_length = standard}, or to keep lengths as is \emph{id_length = asis}.
If \emph{id_length = standard} then in case of \emph{MGH, BWH, MCL, EMPI and PMRN} the length of the MRNs are corrected accordingly by adding zeros, or removing numeral from the beginning.
In other cases the lengths are unchanged. Defaults to \emph{standard}.}

\item{nThread}{integer, number of threads to use by \emph{dopar} for parallelization. If it is set to 1, then no parallel backends are created and the function is executed sequentially.}
}
\value{
vector, with characters formatted to specified lengths. If length of the ID does not match the required length, then leading zeros are added to the ID.
If the ID is longer then the required length, then numerals from the beginning of the ID are cut off until it is the required length.
}
\description{
Adds or removes zeros from integers to comply with MRN code standards for given institution and adds institution prefix.
}
\examples{
\dontrun{
mrns <- sample(1e4:1e7, size = 10) #Simulate MRNs

#MGH format
pretty_mrn(v = mrns, prefix = "MGH")

#BWH format
pretty_mrn(v = mrns, prefix = "BWH")

#Multiple sources using space as a separator
pretty_mrn(v = mrns[1:3], prefix = c("MGH", "BWH", "EMPI"), sep = " ")

#Keeping the length of the IDs despite not adhering to the requirements
pretty_mrn(v = mrns, prefix = "EMPI", id_length = "asis")
}
}
