% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_reg_nnet.R
\name{details_multinom_reg_nnet}
\alias{details_multinom_reg_nnet}
\title{Multinomial regression via nnet}
\description{
\code{\link[nnet:multinom]{nnet::multinom()}} fits a model that uses linear predictors to predict
multiclass data using the multinomial distribution.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 1 tuning parameters:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: 0.0)
}

For \code{penalty}, the amount of regularization includes only the L2 penalty
(i.e., ridge or weight decay).
}

\subsection{Translation from parsnip to the original package}{\if{html}{\out{<div class="r">}}\preformatted{multinom_reg(penalty = double(1)) \%>\% 
  set_engine("nnet") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Multinomial Regression Model Specification (classification)
## 
## Main Arguments:
##   penalty = double(1)
## 
## Computational engine: nnet 
## 
## Model fit template:
## nnet::multinom(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), decay = double(1), trace = FALSE)
}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via
\code{\link[=fit.model_spec]{fit.model_spec()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#multinom-reg-nnet}{examples}
for \code{multinom_reg()} with the \code{"nnet"} engine.
}

\subsection{References}{
\itemize{
\item Luraschi, J, K Kuo, and E Ruiz. 2019. \emph{Mastering nnet with R}.
O’Reilly Media
\item Hastie, T, R Tibshirani, and M Wainwright. 2015. \emph{Statistical
Learning with Sparsity}. CRC Press.
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
