% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_parts.R
\name{parse_parts}
\alias{parse_parts}
\alias{parse_parts_lon}
\alias{parse_parts_lat}
\title{parse coordinates into degrees, minutes and seconds}
\usage{
parse_parts_lon(str)

parse_parts_lat(str)
}
\arguments{
\item{str}{(character) string including longitude or latitude}
}
\value{
data.frame with columns for:
\itemize{
\item deg (integer)
\item min (integer)
\item sec (numeric)
}

NA/NaN given upon error
}
\description{
parse coordinates into degrees, minutes and seconds
}
\examples{
parse_parts_lon("45E54.2356")
parse_parts_lon("140.4183318")
parse_parts_lon("174.6411133")
parse_parts_lon("-45.98739874")
parse_parts_lon("40.123W")

parse_parts_lat("45N54.2356")
parse_parts_lat("40.4183318")
parse_parts_lat("-74.6411133")
parse_parts_lat("-45.98739874")
parse_parts_lat("40.123N")
parse_parts_lat("N40°25’5.994")

# not working, needs format input
parse_parts_lat("N455698735")

# multiple
x <- c("40.123°", "40.123N74.123W", "191.89", 12, "N45 04.25764")
parse_parts_lat(x)
system.time(parse_parts_lat(rep(x, 10^2)))
}
