% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{get_mgsigdb_gsets}
\alias{get_mgsigdb_gsets}
\title{Retrieve Organism-specific MSigDB Gene Sets}
\usage{
get_mgsigdb_gsets(
  species = "Homo sapiens",
  db_species = "HS",
  collection = NULL,
  subcollection = NULL
)
}
\arguments{
\item{species}{species name for output genes, such as Homo sapiens, Mus musculus, etc.
See \code{\link[msigdbr]{msigdbr_species}} for all the species available in
the msigdbr package.}

\item{db_species}{Species abbreviation for the human or mouse databases ("HS" or "MM").}

\item{collection}{collection. e.g., H, C1. (default = NULL,
i.e. list all gene sets in collection). 
See \code{\link[msigdbr]{msigdbr_collections}} for all available options
the msigdbr package.}

\item{subcollection}{sub-collection, such as CGP, BP, etc. (default = NULL,
i.e. list all gene sets in collection). 
See \code{\link[msigdbr]{msigdbr_collections}} for all available options
the msigdbr package.}
}
\value{
Retrieves the MSigDB gene sets and returns a list containing 2 elements: \itemize{
\item{gene_sets - A list containing the genes involved in each of the selected MSigDB gene sets}
\item{descriptions - A named vector containing the descriptions for each selected MSigDB gene set}
}
}
\description{
Retrieve Organism-specific MSigDB Gene Sets
}
\details{
this function utilizes the function \code{\link[msigdbr]{msigdbr}}
from the \code{msigdbr} package to retrieve the 'Molecular Signatures Database'
(MSigDB) gene sets (Subramanian et al. 2005 <doi:10.1073/pnas.0506580102>,
Liberzon et al. 2015 <doi:10.1016/j.cels.2015.12.004>).
Available collections are: H: hallmark gene sets, C1: positional gene sets,
C2: curated gene sets, C3: motif gene sets, C4: computational gene sets,
C5: GO gene sets, C6: oncogenic signatures and C7: immunologic signatures
}
