% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimalParametersSearch.R
\name{optimalParametersSearch}
\alias{optimalParametersSearch}
\title{Optimal Parameters Search for Causality Analysis}
\usage{
optimalParametersSearch(Emax, tauMax, metric, dataset)
}
\arguments{
\item{Emax}{The maximum embedding dimension to test.}

\item{tauMax}{The maximum time delay to test.}

\item{metric}{The distance metric to use in the causality analysis (e.g., 'euclidean').}

\item{dataset}{A matrix where each column represents a time series to be analyzed.}
}
\value{
A data frame summarizing the causality analysis results across all tested E and tau values, showing the mean total, positive, negative, and dark causality accuracies for each parameter combination.
}
\description{
Searches for the optimal embedding dimension (E) and time delay (tau) to maximize the accuracy of causality predictions in a dataset. It evaluates each combination of E and tau for their ability to predict different types of causality: total, positive, negative, and dark.
}
\examples{
data(climate)
dataset <- climate[, -1]
\donttest{
optimalParams <- optimalParametersSearch(Emax=3,tauMax=3,metric="euclidean",dataset=dataset)
print(optimalParams)
}
}
