% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignLan.R
\name{alignLan}
\alias{alignLan}
\title{Align images using landmarks}
\usage{
alignLan(
  imageList,
  landList,
  IDlist = NULL,
  adjustCoords = FALSE,
  resampleFactor = NULL,
  res = c(300, 300),
  transformRef = "meanshape",
  transformType = "tps",
  maskOutline = NULL,
  removebg = NULL,
  removebgColOffset = 0.1,
  inverse = FALSE,
  cartoonID = NULL,
  refImage = NULL,
  plotTransformed = FALSE,
  format = "imageJ"
)
}
\arguments{
\item{imageList}{List of RasterStack objects.}

\item{landList}{Landmark list as returned by \code{\link[patternize]{makeList}}.}

\item{IDlist}{List of sample IDs should be specified when masking outline and transformRef
is 'meanshape'.}

\item{adjustCoords}{Adjust landmark coordinates in case they are reversed compared to pixel
coordinates (default = FALSE).}

\item{resampleFactor}{Integer for downsampling used by \code{\link{redRes}}.}

\item{res}{Resolution vector c(x,y) for output rasters (default = c(300,300)). This should be
reduced if the number of pixels in the image is lower than th raster.}

\item{transformRef}{ID or landmark matrix of reference sample for shape to which color patterns
will be transformed to. Can be 'meanshape' for transforming to mean shape of Procrustes
analysis.}

\item{transformType}{Transformation type as used by \code{\link[Morpho]{computeTransform}}
(default ='tps').}

\item{maskOutline}{When outline is specified, everything outside of the outline will be masked for
the color extraction (default = NULL). This can be a list of multiple outlines.}

\item{removebg}{Integer or RGB vector indicating the range of RGB threshold to remove from
image (e.g. 100 removes pixels with average RGB > 100; default = NULL).}

\item{removebgColOffset}{Color offset for color background extraction (default = 0.10).}

\item{inverse}{If TRUE, areas withing the outline will be masked. If maskOutline is a list, this
should also be a list.}

\item{cartoonID}{ID of the sample for which the cartoon was drawn and will be used for masking
(should be set when transformRef = 'meanShape').}

\item{refImage}{Image (RasterStack) used for target. Use raster::stack('filename').}

\item{plotTransformed}{Plot transformed image (default = FALSE).}

\item{format}{ImageJ (Fiji) or tps format (default = 'imageJ').}
}
\value{
List of aligned RasterStack objects.
}
\description{
Align images using landmarks
}
