% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_clusters}
\alias{emr_list_clusters}
\title{Provides the status of all clusters visible to this AWS account}
\usage{
emr_list_clusters(CreatedAfter, CreatedBefore, ClusterStates, Marker)
}
\arguments{
\item{CreatedAfter}{The creation date and time beginning value filter for listing clusters.}

\item{CreatedBefore}{The creation date and time end value filter for listing clusters.}

\item{ClusterStates}{The cluster state filters to apply when listing clusters.}

\item{Marker}{The pagination token that indicates the next set of results to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Clusters = list(
    list(
      Id = "string",
      Name = "string",
      Status = list(
        State = "STARTING"|"BOOTSTRAPPING"|"RUNNING"|"WAITING"|"TERMINATING"|"TERMINATED"|"TERMINATED_WITH_ERRORS",
        StateChangeReason = list(
          Code = "INTERNAL_ERROR"|"VALIDATION_ERROR"|"INSTANCE_FAILURE"|"INSTANCE_FLEET_TIMEOUT"|"BOOTSTRAP_FAILURE"|"USER_REQUEST"|"STEP_FAILURE"|"ALL_STEPS_COMPLETED",
          Message = "string"
        ),
        Timeline = list(
          CreationDateTime = as.POSIXct(
            "2015-01-01"
          ),
          ReadyDateTime = as.POSIXct(
            "2015-01-01"
          ),
          EndDateTime = as.POSIXct(
            "2015-01-01"
          )
        )
      ),
      NormalizedInstanceHours = 123,
      ClusterArn = "string",
      OutpostArn = "string"
    )
  ),
  Marker = "string"
)
}
}
\description{
Provides the status of all clusters visible to this AWS account. Allows
you to filter the list of clusters based on certain criteria; for
example, filtering by cluster creation date and time or by status. This
call returns a maximum of 50 clusters per call, but returns a marker to
track the paging of the cluster list across multiple ListClusters calls.
}
\section{Request syntax}{
\preformatted{svc$list_clusters(
  CreatedAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  ClusterStates = list(
    "STARTING"|"BOOTSTRAPPING"|"RUNNING"|"WAITING"|"TERMINATING"|"TERMINATED"|"TERMINATED_WITH_ERRORS"
  ),
  Marker = "string"
)
}
}

\keyword{internal}
