% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_describe_objects}
\alias{datapipeline_describe_objects}
\title{Gets the object definitions for a set of objects associated with the
pipeline}
\usage{
datapipeline_describe_objects(pipelineId, objectIds,
  evaluateExpressions, marker)
}
\arguments{
\item{pipelineId}{[required] The ID of the pipeline that contains the object definitions.}

\item{objectIds}{[required] The IDs of the pipeline objects that contain the definitions to be
described. You can pass as many as 25 identifiers in a single call to
\code{\link[=datapipeline_describe_objects]{describe_objects}}.}

\item{evaluateExpressions}{Indicates whether any expressions in the object should be evaluated when
the object descriptions are returned.}

\item{marker}{The starting point for the results to be returned. For the first call,
this value should be empty. As long as there are more results, continue
to call \code{\link[=datapipeline_describe_objects]{describe_objects}} with the
marker value from the previous call to retrieve the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  pipelineObjects = list(
    list(
      id = "string",
      name = "string",
      fields = list(
        list(
          key = "string",
          stringValue = "string",
          refValue = "string"
        )
      )
    )
  ),
  marker = "string",
  hasMoreResults = TRUE|FALSE
)
}
}
\description{
Gets the object definitions for a set of objects associated with the
pipeline. Object definitions are composed of a set of fields that define
the properties of the object.
}
\section{Request syntax}{
\preformatted{svc$describe_objects(
  pipelineId = "string",
  objectIds = list(
    "string"
  ),
  evaluateExpressions = TRUE|FALSE,
  marker = "string"
)
}
}

\keyword{internal}
