% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_ml_transform}
\alias{glue_create_ml_transform}
\title{Creates an AWS Glue machine learning transform}
\usage{
glue_create_ml_transform(Name, Description, InputRecordTables,
  Parameters, Role, GlueVersion, MaxCapacity, WorkerType, NumberOfWorkers,
  Timeout, MaxRetries)
}
\arguments{
\item{Name}{[required] The unique name that you give the transform when you create it.}

\item{Description}{A description of the machine learning transform that is being defined.
The default is an empty string.}

\item{InputRecordTables}{[required] A list of AWS Glue table definitions used by the transform.}

\item{Parameters}{[required] The algorithmic parameters that are specific to the transform type used.
Conditionally dependent on the transform type.}

\item{Role}{[required] The name or Amazon Resource Name (ARN) of the IAM role with the required
permissions. The required permissions include both AWS Glue service role
permissions to AWS Glue resources, and Amazon S3 permissions required by
the transform.
\itemize{
\item This role needs AWS Glue service role permissions to allow access to
resources in AWS Glue. See \href{https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html}{Attach a Policy to IAM Users That Access AWS Glue}.
\item This role needs permission to your Amazon Simple Storage Service
(Amazon S3) sources, targets, temporary directory, scripts, and any
libraries used by the task run for this transform.
}}

\item{GlueVersion}{This value determines which version of AWS Glue this machine learning
transform is compatible with. Glue 1.0 is recommended for most
customers. If the value is not set, the Glue compatibility defaults to
Glue 0.9. For more information, see \href{https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions}{AWS Glue Versions}
in the developer guide.}

\item{MaxCapacity}{The number of AWS Glue data processing units (DPUs) that are allocated
to task runs for this transform. You can allocate from 2 to 100 DPUs;
the default is 10. A DPU is a relative measure of processing power that
consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
information, see the \href{https://aws.amazon.com/glue/pricing/}{AWS Glue pricing page}.

\code{MaxCapacity} is a mutually exclusive option with \code{NumberOfWorkers} and
\code{WorkerType}.
\itemize{
\item If either \code{NumberOfWorkers} or \code{WorkerType} is set, then
\code{MaxCapacity} cannot be set.
\item If \code{MaxCapacity} is set then neither \code{NumberOfWorkers} or
\code{WorkerType} can be set.
\item If \code{WorkerType} is set, then \code{NumberOfWorkers} is required (and vice
versa).
\item \code{MaxCapacity} and \code{NumberOfWorkers} must both be at least 1.
}

When the \code{WorkerType} field is set to a value other than \code{Standard}, the
\code{MaxCapacity} field is set automatically and becomes read-only.

When the \code{WorkerType} field is set to a value other than \code{Standard}, the
\code{MaxCapacity} field is set automatically and becomes read-only.}

\item{WorkerType}{The type of predefined worker that is allocated when this task runs.
Accepts a value of Standard, G.1X, or G.2X.
\itemize{
\item For the \code{Standard} worker type, each worker provides 4 vCPU, 16 GB
of memory and a 50GB disk, and 2 executors per worker.
\item For the \code{G.1X} worker type, each worker provides 4 vCPU, 16 GB of
memory and a 64GB disk, and 1 executor per worker.
\item For the \code{G.2X} worker type, each worker provides 8 vCPU, 32 GB of
memory and a 128GB disk, and 1 executor per worker.
}

\code{MaxCapacity} is a mutually exclusive option with \code{NumberOfWorkers} and
\code{WorkerType}.
\itemize{
\item If either \code{NumberOfWorkers} or \code{WorkerType} is set, then
\code{MaxCapacity} cannot be set.
\item If \code{MaxCapacity} is set then neither \code{NumberOfWorkers} or
\code{WorkerType} can be set.
\item If \code{WorkerType} is set, then \code{NumberOfWorkers} is required (and vice
versa).
\item \code{MaxCapacity} and \code{NumberOfWorkers} must both be at least 1.
}}

\item{NumberOfWorkers}{The number of workers of a defined \code{workerType} that are allocated when
this task runs.

If \code{WorkerType} is set, then \code{NumberOfWorkers} is required (and vice
versa).}

\item{Timeout}{The timeout of the task run for this transform in minutes. This is the
maximum time that a task run for this transform can consume resources
before it is terminated and enters \code{TIMEOUT} status. The default is
2,880 minutes (48 hours).}

\item{MaxRetries}{The maximum number of times to retry a task for this transform after a
task run fails.}
}
\description{
Creates an AWS Glue machine learning transform. This operation creates
the transform and all the necessary parameters to train it.
}
\details{
Call this operation as the first step in the process of using a machine
learning transform (such as the \code{FindMatches} transform) for
deduplicating data. You can provide an optional \code{Description}, in
addition to the parameters that you want to use for your algorithm.

You must also specify certain parameters for the tasks that AWS Glue
runs on your behalf as part of learning from your data and creating a
high-quality machine learning transform. These parameters include
\code{Role}, and optionally, \code{AllocatedCapacity}, \code{Timeout}, and
\code{MaxRetries}. For more information, see
\href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html}{Jobs}.
}
\section{Request syntax}{
\preformatted{svc$create_ml_transform(
  Name = "string",
  Description = "string",
  InputRecordTables = list(
    list(
      DatabaseName = "string",
      TableName = "string",
      CatalogId = "string",
      ConnectionName = "string"
    )
  ),
  Parameters = list(
    TransformType = "FIND_MATCHES",
    FindMatchesParameters = list(
      PrimaryKeyColumnName = "string",
      PrecisionRecallTradeoff = 123.0,
      AccuracyCostTradeoff = 123.0,
      EnforceProvidedLabels = TRUE|FALSE
    )
  ),
  Role = "string",
  GlueVersion = "string",
  MaxCapacity = 123.0,
  WorkerType = "Standard"|"G.1X"|"G.2X",
  NumberOfWorkers = 123,
  Timeout = 123,
  MaxRetries = 123
)
}
}

\keyword{internal}
