% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_job}
\alias{glue_create_job}
\title{Creates a new job definition}
\usage{
glue_create_job(
  Name,
  Description = NULL,
  LogUri = NULL,
  Role,
  ExecutionProperty = NULL,
  Command,
  DefaultArguments = NULL,
  NonOverridableArguments = NULL,
  Connections = NULL,
  MaxRetries = NULL,
  AllocatedCapacity = NULL,
  Timeout = NULL,
  MaxCapacity = NULL,
  SecurityConfiguration = NULL,
  Tags = NULL,
  NotificationProperty = NULL,
  GlueVersion = NULL,
  NumberOfWorkers = NULL,
  WorkerType = NULL,
  CodeGenConfigurationNodes = NULL,
  ExecutionClass = NULL
)
}
\arguments{
\item{Name}{[required] The name you assign to this job definition. It must be unique in your
account.}

\item{Description}{Description of the job being defined.}

\item{LogUri}{This field is reserved for future use.}

\item{Role}{[required] The name or Amazon Resource Name (ARN) of the IAM role associated with
this job.}

\item{ExecutionProperty}{An \code{ExecutionProperty} specifying the maximum number of concurrent runs
allowed for this job.}

\item{Command}{[required] The \code{JobCommand} that runs this job.}

\item{DefaultArguments}{The default arguments for this job.

You can specify arguments here that your own job-execution script
consumes, as well as arguments that Glue itself consumes.

Job arguments may be logged. Do not pass plaintext secrets as arguments.
Retrieve secrets from a Glue Connection, Secrets Manager or other secret
management mechanism if you intend to keep them within the Job.

For information about how to specify and consume your own Job arguments,
see the \href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html}{Calling Glue APIs in Python}
topic in the developer guide.

For information about the key-value pairs that Glue consumes to set up
your job, see the \href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html}{Special Parameters Used by Glue}
topic in the developer guide.}

\item{NonOverridableArguments}{Non-overridable arguments for this job, specified as name-value pairs.}

\item{Connections}{The connections used for this job.}

\item{MaxRetries}{The maximum number of times to retry this job if it fails.}

\item{AllocatedCapacity}{This parameter is deprecated. Use \code{MaxCapacity} instead.

The number of Glue data processing units (DPUs) to allocate to this Job.
You can allocate a minimum of 2 DPUs; the default is 10. A DPU is a
relative measure of processing power that consists of 4 vCPUs of compute
capacity and 16 GB of memory. For more information, see the \href{https://aws.amazon.com/glue/pricing/}{Glue pricing page}.}

\item{Timeout}{The job timeout in minutes. This is the maximum time that a job run can
consume resources before it is terminated and enters \code{TIMEOUT} status.
The default is 2,880 minutes (48 hours).}

\item{MaxCapacity}{For Glue version 1.0 or earlier jobs, using the standard worker type,
the number of Glue data processing units (DPUs) that can be allocated
when this job runs. A DPU is a relative measure of processing power that
consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
information, see the \href{https://aws.amazon.com/glue/pricing/}{Glue pricing page}.

Do not set \verb{Max Capacity} if using \code{WorkerType} and \code{NumberOfWorkers}.

The value that can be allocated for \code{MaxCapacity} depends on whether you
are running a Python shell job or an Apache Spark ETL job:
\itemize{
\item When you specify a Python shell job
(\code{JobCommand.Name}="pythonshell"), you can allocate either 0.0625 or
1 DPU. The default is 0.0625 DPU.
\item When you specify an Apache Spark ETL job
(\code{JobCommand.Name}="glueetl") or Apache Spark streaming ETL job
(\code{JobCommand.Name}="gluestreaming"), you can allocate a minimum of 2
DPUs. The default is 10 DPUs. This job type cannot have a fractional
DPU allocation.
}

For Glue version 2.0 jobs, you cannot instead specify a
\verb{Maximum capacity}. Instead, you should specify a \verb{Worker type} and the
\verb{Number of workers}.}

\item{SecurityConfiguration}{The name of the \code{SecurityConfiguration} structure to be used with this
job.}

\item{Tags}{The tags to use with this job. You may use tags to limit access to the
job. For more information about tags in Glue, see \href{https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html}{Amazon Web Services Tags in Glue} in
the developer guide.}

\item{NotificationProperty}{Specifies configuration properties of a job notification.}

\item{GlueVersion}{Glue version determines the versions of Apache Spark and Python that
Glue supports. The Python version indicates the version supported for
jobs of type Spark.

For more information about the available Glue versions and corresponding
Spark and Python versions, see \href{https://docs.aws.amazon.com/glue/latest/dg/add-job.html}{Glue version} in the
developer guide.

Jobs that are created without specifying a Glue version default to Glue
0.9.}

\item{NumberOfWorkers}{The number of workers of a defined \code{workerType} that are allocated when
a job runs.}

\item{WorkerType}{The type of predefined worker that is allocated when a job runs. Accepts
a value of Standard, G.1X, G.2X, or G.025X.
\itemize{
\item For the \code{Standard} worker type, each worker provides 4 vCPU, 16 GB
of memory and a 50GB disk, and 2 executors per worker.
\item For the \code{G.1X} worker type, each worker maps to 1 DPU (4 vCPU, 16 GB
of memory, 64 GB disk), and provides 1 executor per worker. We
recommend this worker type for memory-intensive jobs.
\item For the \code{G.2X} worker type, each worker maps to 2 DPU (8 vCPU, 32 GB
of memory, 128 GB disk), and provides 1 executor per worker. We
recommend this worker type for memory-intensive jobs.
\item For the \code{G.025X} worker type, each worker maps to 0.25 DPU (2 vCPU,
4 GB of memory, 64 GB disk), and provides 1 executor per worker. We
recommend this worker type for low volume streaming jobs. This
worker type is only available for Glue version 3.0 streaming jobs.
}}

\item{CodeGenConfigurationNodes}{The representation of a directed acyclic graph on which both the Glue
Studio visual component and Glue Studio code generation is based.}

\item{ExecutionClass}{Indicates whether the job is run with a standard or flexible execution
class. The standard execution-class is ideal for time-sensitive
workloads that require fast job startup and dedicated resources.

The flexible execution class is appropriate for time-insensitive jobs
whose start and completion times may vary.

Only jobs with Glue version 3.0 and above and command type \code{glueetl}
will be allowed to set \code{ExecutionClass} to \code{FLEX}. The flexible
execution class is available for Spark jobs.}
}
\description{
Creates a new job definition.

See \url{https://paws-r.github.io/docs/glue/create_job.html} for full documentation.
}
\keyword{internal}
