% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_generate_embed_url_for_registered_user}
\alias{quicksight_generate_embed_url_for_registered_user}
\title{Generates an embed URL that you can use to embed an Amazon QuickSight
experience in your website}
\usage{
quicksight_generate_embed_url_for_registered_user(
  AwsAccountId,
  SessionLifetimeInMinutes = NULL,
  UserArn,
  ExperienceConfiguration,
  AllowedDomains = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the Amazon Web Services account that contains the dashboard
that you're embedding.}

\item{SessionLifetimeInMinutes}{How many minutes the session is valid. The session lifetime must be in
[15-600] minutes range.}

\item{UserArn}{[required] The Amazon Resource Name for the registered user.}

\item{ExperienceConfiguration}{[required] The experience you are embedding. For registered users, you can embed
Amazon QuickSight dashboards or the entire Amazon QuickSight console.}

\item{AllowedDomains}{The domains that you want to add to the allow list for access to the
generated URL that is then embedded. This optional parameter overrides
the static domains that are configured in the Manage QuickSight menu in
the Amazon QuickSight console. Instead, it allows only the domains that
you include in this parameter. You can list up to three domains or
subdomains in each API call.

To include all subdomains under a specific domain to the allow list, use
\code{*}. For example, \verb{https://*.sapp.amazon.com} includes all subdomains
under \verb{https://sapp.amazon.com}.}
}
\description{
Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.

See \url{https://paws-r.github.io/docs/quicksight/generate_embed_url_for_registered_user.html} for full documentation.
}
\keyword{internal}
