# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kendraranking_service.R
NULL

#' Creates a rescore execution plan
#'
#' @description
#' Creates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the [`rescore`][kendraranking_rescore] API. You set the number of capacity units that you require for Amazon Kendra Intelligent Ranking to rescore or re-rank a search service's results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_create_rescore_execution_plan/](https://www.paws-r-sdk.com/docs/kendraranking_create_rescore_execution_plan/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for the rescore execution plan.
#' @param Description A description for the rescore execution plan.
#' @param CapacityUnits You can set additional capacity units to meet the needs of your rescore
#' execution plan. You are given a single capacity unit by default. If you
#' want to use the default capacity, you don't set additional capacity
#' units. For more information on the default capacity and additional
#' capacity units, see [Adjusting
#' capacity](https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html).
#' @param Tags A list of key-value pairs that identify or categorize your rescore
#' execution plan. You can also use tags to help control access to the
#' rescore execution plan. Tag keys and values can consist of Unicode
#' letters, digits, white space, and any of the following symbols: _ . : /
#' = + - @@.
#' @param ClientToken A token that you provide to identify the request to create a rescore
#' execution plan. Multiple calls to the
#' `CreateRescoreExecutionPlanRequest` API with the same client token will
#' create only one rescore execution plan.
#'
#' @keywords internal
#'
#' @rdname kendraranking_create_rescore_execution_plan
kendraranking_create_rescore_execution_plan <- function(Name, Description = NULL, CapacityUnits = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateRescoreExecutionPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$create_rescore_execution_plan_input(Name = Name, Description = Description, CapacityUnits = CapacityUnits, Tags = Tags, ClientToken = ClientToken)
  output <- .kendraranking$create_rescore_execution_plan_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$create_rescore_execution_plan <- kendraranking_create_rescore_execution_plan

#' Deletes a rescore execution plan
#'
#' @description
#' Deletes a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the [`rescore`][kendraranking_rescore] API.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_delete_rescore_execution_plan/](https://www.paws-r-sdk.com/docs/kendraranking_delete_rescore_execution_plan/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the rescore execution plan that you want to delete.
#'
#' @keywords internal
#'
#' @rdname kendraranking_delete_rescore_execution_plan
kendraranking_delete_rescore_execution_plan <- function(Id) {
  op <- new_operation(
    name = "DeleteRescoreExecutionPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$delete_rescore_execution_plan_input(Id = Id)
  output <- .kendraranking$delete_rescore_execution_plan_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$delete_rescore_execution_plan <- kendraranking_delete_rescore_execution_plan

#' Gets information about a rescore execution plan
#'
#' @description
#' Gets information about a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the [`rescore`][kendraranking_rescore] API.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_describe_rescore_execution_plan/](https://www.paws-r-sdk.com/docs/kendraranking_describe_rescore_execution_plan/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the rescore execution plan that you want to get
#' information on.
#'
#' @keywords internal
#'
#' @rdname kendraranking_describe_rescore_execution_plan
kendraranking_describe_rescore_execution_plan <- function(Id) {
  op <- new_operation(
    name = "DescribeRescoreExecutionPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$describe_rescore_execution_plan_input(Id = Id)
  output <- .kendraranking$describe_rescore_execution_plan_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$describe_rescore_execution_plan <- kendraranking_describe_rescore_execution_plan

#' Lists your rescore execution plans
#'
#' @description
#' Lists your rescore execution plans. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the [`rescore`][kendraranking_rescore] API.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_list_rescore_execution_plans/](https://www.paws-r-sdk.com/docs/kendraranking_list_rescore_execution_plans/) for full documentation.
#'
#' @param NextToken If the response is truncated, Amazon Kendra Intelligent Ranking returns
#' a pagination token in the response. You can use this pagination token to
#' retrieve the next set of rescore execution plans.
#' @param MaxResults The maximum number of rescore execution plans to return.
#'
#' @keywords internal
#'
#' @rdname kendraranking_list_rescore_execution_plans
kendraranking_list_rescore_execution_plans <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRescoreExecutionPlans",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendraranking$list_rescore_execution_plans_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendraranking$list_rescore_execution_plans_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$list_rescore_execution_plans <- kendraranking_list_rescore_execution_plans

#' Gets a list of tags associated with a specified resource
#'
#' @description
#' Gets a list of tags associated with a specified resource. A rescore execution plan is an example of a resource that can have tags associated with it.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/kendraranking_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the rescore execution plan to get a
#' list of tags for.
#'
#' @keywords internal
#'
#' @rdname kendraranking_list_tags_for_resource
kendraranking_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .kendraranking$list_tags_for_resource_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$list_tags_for_resource <- kendraranking_list_tags_for_resource

#' Rescores or re-ranks search results from a search service such as
#' OpenSearch (self managed)
#'
#' @description
#' Rescores or re-ranks search results from a search service such as OpenSearch (self managed). You use the semantic search capabilities of Amazon Kendra Intelligent Ranking to improve the search service's results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_rescore/](https://www.paws-r-sdk.com/docs/kendraranking_rescore/) for full documentation.
#'
#' @param RescoreExecutionPlanId &#91;required&#93; The identifier of the rescore execution plan. A rescore execution plan
#' is an Amazon Kendra Intelligent Ranking resource used for provisioning
#' the [`rescore`][kendraranking_rescore] API.
#' @param SearchQuery &#91;required&#93; The input query from the search service.
#' @param Documents &#91;required&#93; The list of documents for Amazon Kendra Intelligent Ranking to rescore
#' or rank on.
#'
#' @keywords internal
#'
#' @rdname kendraranking_rescore
kendraranking_rescore <- function(RescoreExecutionPlanId, SearchQuery, Documents) {
  op <- new_operation(
    name = "Rescore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$rescore_input(RescoreExecutionPlanId = RescoreExecutionPlanId, SearchQuery = SearchQuery, Documents = Documents)
  output <- .kendraranking$rescore_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$rescore <- kendraranking_rescore

#' Adds a specified tag to a specified rescore execution plan
#'
#' @description
#' Adds a specified tag to a specified rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the [`rescore`][kendraranking_rescore] API. If the tag already exists, the existing value is replaced with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_tag_resource/](https://www.paws-r-sdk.com/docs/kendraranking_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the rescore execution plan to tag.
#' @param Tags &#91;required&#93; A list of tag keys to add to a rescore execution plan. If a tag already
#' exists, the existing value is replaced with the new value.
#'
#' @keywords internal
#'
#' @rdname kendraranking_tag_resource
kendraranking_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .kendraranking$tag_resource_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$tag_resource <- kendraranking_tag_resource

#' Removes a tag from a rescore execution plan
#'
#' @description
#' Removes a tag from a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the [`rescore`][kendraranking_rescore] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_untag_resource/](https://www.paws-r-sdk.com/docs/kendraranking_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the rescore execution plan to remove
#' the tag.
#' @param TagKeys &#91;required&#93; A list of tag keys to remove from the rescore execution plan. If a tag
#' key does not exist on the resource, it is ignored.
#'
#' @keywords internal
#'
#' @rdname kendraranking_untag_resource
kendraranking_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .kendraranking$untag_resource_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$untag_resource <- kendraranking_untag_resource

#' Updates a rescore execution plan
#'
#' @description
#' Updates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the [`rescore`][kendraranking_rescore] API. You can update the number of capacity units you require for Amazon Kendra Intelligent Ranking to rescore or re-rank a search service's results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendraranking_update_rescore_execution_plan/](https://www.paws-r-sdk.com/docs/kendraranking_update_rescore_execution_plan/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the rescore execution plan that you want to update.
#' @param Name A new name for the rescore execution plan.
#' @param Description A new description for the rescore execution plan.
#' @param CapacityUnits You can set additional capacity units to meet the needs of your rescore
#' execution plan. You are given a single capacity unit by default. If you
#' want to use the default capacity, you don't set additional capacity
#' units. For more information on the default capacity and additional
#' capacity units, see [Adjusting
#' capacity](https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html).
#'
#' @keywords internal
#'
#' @rdname kendraranking_update_rescore_execution_plan
kendraranking_update_rescore_execution_plan <- function(Id, Name = NULL, Description = NULL, CapacityUnits = NULL) {
  op <- new_operation(
    name = "UpdateRescoreExecutionPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendraranking$update_rescore_execution_plan_input(Id = Id, Name = Name, Description = Description, CapacityUnits = CapacityUnits)
  output <- .kendraranking$update_rescore_execution_plan_output()
  config <- get_config()
  svc <- .kendraranking$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendraranking$operations$update_rescore_execution_plan <- kendraranking_update_rescore_execution_plan
