# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS EntityResolution
#'
#' @description
#' Welcome to the *Entity Resolution API Reference*.
#' 
#' Entity Resolution is an Amazon Web Services service that provides
#' pre-configured entity resolution capabilities that enable developers and
#' analysts at advertising and marketing companies to build an accurate and
#' complete view of their consumers.
#' 
#' With Entity Resolution, you can match source records containing consumer
#' identifiers, such as name, email address, and phone number. This is true
#' even when these records have incomplete or conflicting identifiers. For
#' example, Entity Resolution can effectively match a source record from a
#' customer relationship management (CRM) system with a source record from
#' a marketing system containing campaign information.
#' 
#' To learn more about Entity Resolution concepts, procedures, and best
#' practices, see the [Entity Resolution User
#' Guide](https://docs.aws.amazon.com/entityresolution/latest/userguide/what-is-service.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- entityresolution(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- entityresolution()
#' svc$add_policy_statement(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=entityresolution_add_policy_statement]{add_policy_statement} \tab Adds a policy statement object\cr
#'  \link[=entityresolution_batch_delete_unique_id]{batch_delete_unique_id} \tab Deletes multiple unique IDs in a matching workflow\cr
#'  \link[=entityresolution_create_id_mapping_workflow]{create_id_mapping_workflow} \tab Creates an IdMappingWorkflow object which stores the configuration of the data processing job to be run\cr
#'  \link[=entityresolution_create_id_namespace]{create_id_namespace} \tab Creates an ID namespace object which will help customers provide metadata explaining their dataset and how to use it\cr
#'  \link[=entityresolution_create_matching_workflow]{create_matching_workflow} \tab Creates a MatchingWorkflow object which stores the configuration of the data processing job to be run\cr
#'  \link[=entityresolution_create_schema_mapping]{create_schema_mapping} \tab Creates a schema mapping, which defines the schema of the input customer records table\cr
#'  \link[=entityresolution_delete_id_mapping_workflow]{delete_id_mapping_workflow} \tab Deletes the IdMappingWorkflow with a given name\cr
#'  \link[=entityresolution_delete_id_namespace]{delete_id_namespace} \tab Deletes the IdNamespace with a given name\cr
#'  \link[=entityresolution_delete_matching_workflow]{delete_matching_workflow} \tab Deletes the MatchingWorkflow with a given name\cr
#'  \link[=entityresolution_delete_policy_statement]{delete_policy_statement} \tab Deletes the policy statement\cr
#'  \link[=entityresolution_delete_schema_mapping]{delete_schema_mapping} \tab Deletes the SchemaMapping with a given name\cr
#'  \link[=entityresolution_get_id_mapping_job]{get_id_mapping_job} \tab Gets the status, metrics, and errors (if there are any) that are associated with a job\cr
#'  \link[=entityresolution_get_id_mapping_workflow]{get_id_mapping_workflow} \tab Returns the IdMappingWorkflow with a given name, if it exists\cr
#'  \link[=entityresolution_get_id_namespace]{get_id_namespace} \tab Returns the IdNamespace with a given name, if it exists\cr
#'  \link[=entityresolution_get_match_id]{get_match_id} \tab Returns the corresponding Match ID of a customer record if the record has been processed\cr
#'  \link[=entityresolution_get_matching_job]{get_matching_job} \tab Gets the status, metrics, and errors (if there are any) that are associated with a job\cr
#'  \link[=entityresolution_get_matching_workflow]{get_matching_workflow} \tab Returns the MatchingWorkflow with a given name, if it exists\cr
#'  \link[=entityresolution_get_policy]{get_policy} \tab Returns the resource-based policy\cr
#'  \link[=entityresolution_get_provider_service]{get_provider_service} \tab Returns the ProviderService of a given name\cr
#'  \link[=entityresolution_get_schema_mapping]{get_schema_mapping} \tab Returns the SchemaMapping of a given name\cr
#'  \link[=entityresolution_list_id_mapping_jobs]{list_id_mapping_jobs} \tab Lists all ID mapping jobs for a given workflow\cr
#'  \link[=entityresolution_list_id_mapping_workflows]{list_id_mapping_workflows} \tab Returns a list of all the IdMappingWorkflows that have been created for an Amazon Web Services account\cr
#'  \link[=entityresolution_list_id_namespaces]{list_id_namespaces} \tab Returns a list of all ID namespaces\cr
#'  \link[=entityresolution_list_matching_jobs]{list_matching_jobs} \tab Lists all jobs for a given workflow\cr
#'  \link[=entityresolution_list_matching_workflows]{list_matching_workflows} \tab Returns a list of all the MatchingWorkflows that have been created for an Amazon Web Services account\cr
#'  \link[=entityresolution_list_provider_services]{list_provider_services} \tab Returns a list of all the ProviderServices that are available in this Amazon Web Services Region\cr
#'  \link[=entityresolution_list_schema_mappings]{list_schema_mappings} \tab Returns a list of all the SchemaMappings that have been created for an Amazon Web Services account\cr
#'  \link[=entityresolution_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with an Entity Resolution resource\cr
#'  \link[=entityresolution_put_policy]{put_policy} \tab Updates the resource-based policy\cr
#'  \link[=entityresolution_start_id_mapping_job]{start_id_mapping_job} \tab Starts the IdMappingJob of a workflow\cr
#'  \link[=entityresolution_start_matching_job]{start_matching_job} \tab Starts the MatchingJob of a workflow\cr
#'  \link[=entityresolution_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource\cr
#'  \link[=entityresolution_untag_resource]{untag_resource} \tab Removes one or more tags from the specified Entity Resolution resource\cr
#'  \link[=entityresolution_update_id_mapping_workflow]{update_id_mapping_workflow} \tab Updates an existing IdMappingWorkflow\cr
#'  \link[=entityresolution_update_id_namespace]{update_id_namespace} \tab Updates an existing ID namespace\cr
#'  \link[=entityresolution_update_matching_workflow]{update_matching_workflow} \tab Updates an existing MatchingWorkflow\cr
#'  \link[=entityresolution_update_schema_mapping]{update_schema_mapping} \tab Updates a schema mapping
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname entityresolution
#' @export
entityresolution <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .entityresolution$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.entityresolution <- list()

.entityresolution$operations <- list()

.entityresolution$metadata <- list(
  service_name = "entityresolution",
  endpoints = list("*" = list(endpoint = "entityresolution.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "entityresolution.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "entityresolution.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "entityresolution.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "entityresolution.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "entityresolution.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "EntityResolution",
  api_version = "2018-05-10",
  signing_name = "entityresolution",
  json_version = "1.1",
  target_prefix = ""
)

.entityresolution$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.entityresolution$metadata, handlers, config, op)
}
