% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_table_versions}
\alias{glue_get_table_versions}
\title{Retrieves a list of strings that identify available versions of a
specified table}
\usage{
glue_get_table_versions(
  CatalogId = NULL,
  DatabaseName,
  TableName,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the tables reside. If none is provided,
the Amazon Web Services account ID is used by default.}

\item{DatabaseName}{[required] The database in the catalog in which the table resides. For Hive
compatibility, this name is entirely lowercase.}

\item{TableName}{[required] The name of the table. For Hive compatibility, this name is entirely
lowercase.}

\item{NextToken}{A continuation token, if this is not the first call.}

\item{MaxResults}{The maximum number of table versions to return in one response.}
}
\description{
Retrieves a list of strings that identify available versions of a specified table.

See \url{https://www.paws-r-sdk.com/docs/glue_get_table_versions/} for full documentation.
}
\keyword{internal}
