% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_column_statistics_task_settings}
\alias{glue_create_column_statistics_task_settings}
\title{Creates settings for a column statistics task}
\usage{
glue_create_column_statistics_task_settings(
  DatabaseName,
  TableName,
  Role,
  Schedule = NULL,
  ColumnNameList = NULL,
  SampleSize = NULL,
  CatalogID = NULL,
  SecurityConfiguration = NULL,
  Tags = NULL
)
}
\arguments{
\item{DatabaseName}{[required] The name of the database where the table resides.}

\item{TableName}{[required] The name of the table for which to generate column statistics.}

\item{Role}{[required] The role used for running the column statistics.}

\item{Schedule}{A schedule for running the column statistics, specified in CRON syntax.}

\item{ColumnNameList}{A list of column names for which to run statistics.}

\item{SampleSize}{The percentage of data to sample.}

\item{CatalogID}{The ID of the Data Catalog in which the database resides.}

\item{SecurityConfiguration}{Name of the security configuration that is used to encrypt CloudWatch
logs.}

\item{Tags}{A map of tags.}
}
\description{
Creates settings for a column statistics task.

See \url{https://www.paws-r-sdk.com/docs/glue_create_column_statistics_task_settings/} for full documentation.
}
\keyword{internal}
