% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_create_user}
\alias{mq_create_user}
\title{Creates an ActiveMQ user}
\usage{
mq_create_user(
  BrokerId,
  ConsoleAccess = NULL,
  Groups = NULL,
  Password,
  Username
)
}
\arguments{
\item{BrokerId}{[required] The unique ID that Amazon MQ generates for the broker.}

\item{ConsoleAccess}{Enables access to the ActiveMQ Web Console for the ActiveMQ user.}

\item{Groups}{The list of groups (20 maximum) to which the ActiveMQ user belongs. This
value can contain only alphanumeric characters, dashes, periods,
underscores, and tildes (- . _ ~). This value must be 2-100 characters
long.}

\item{Password}{[required] Required. The password of the user. This value must be at least 12
characters long, must contain at least 4 unique characters, and must not
contain commas, colons, or equal signs (,:=).}

\item{Username}{[required] The username of the ActiveMQ user. This value can contain only
alphanumeric characters, dashes, periods, underscores, and tildes (- .
_ ~). This value must be 2-100 characters long.}
}
\description{
Creates an ActiveMQ user.

See \url{https://paws-r.github.io/docs/mq/create_user.html} for full documentation.
}
\keyword{internal}
