% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_associated_enclave_certificate_iam_roles}
\alias{ec2_get_associated_enclave_certificate_iam_roles}
\title{Returns the IAM roles that are associated with the specified AWS
Certificate Manager (ACM) certificate}
\usage{
ec2_get_associated_enclave_certificate_iam_roles(CertificateArn, DryRun)
}
\arguments{
\item{CertificateArn}{The ARN of the ACM certificate for which to view the associated IAM
roles, encryption keys, and Amazon S3 object information.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Returns the IAM roles that are associated with the specified AWS
Certificate Manager (ACM) certificate. It also returns the name of the
Amazon S3 bucket and the Amazon S3 object key where the certificate,
certificate chain, and encrypted private key bundle are stored, and the
ARN of the AWS Key Management Service (KMS) customer master key (CMK)
that's used to encrypt the private key.
}
\section{Request syntax}{
\preformatted{svc$get_associated_enclave_certificate_iam_roles(
  CertificateArn = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
