% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_disk}
\alias{lightsail_create_disk}
\title{Creates a block storage disk that can be attached to an Amazon Lightsail
instance in the same Availability Zone (e}
\usage{
lightsail_create_disk(diskName, availabilityZone, sizeInGb, tags,
  addOns)
}
\arguments{
\item{diskName}{[required] The unique Lightsail disk name (e.g., \code{my-disk}).}

\item{availabilityZone}{[required] The Availability Zone where you want to create the disk (e.g.,
\verb{us-east-2a}). Use the same Availability Zone as the Lightsail instance
to which you want to attach the disk.

Use the \verb{get regions} operation to list the Availability Zones where
Lightsail is currently available.}

\item{sizeInGb}{[required] The size of the disk in GB (e.g., \code{32}).}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}

\item{addOns}{An array of objects that represent the add-ons to enable for the new
disk.}
}
\value{
A list with the following syntax:\preformatted{list(
  operations = list(
    list(
      id = "string",
      resourceName = "string",
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      isTerminal = TRUE|FALSE,
      operationDetails = "string",
      operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
      status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
      statusChangedAt = as.POSIXct(
        "2015-01-01"
      ),
      errorCode = "string",
      errorDetails = "string"
    )
  )
)
}
}
\description{
Creates a block storage disk that can be attached to an Amazon Lightsail
instance in the same Availability Zone (e.g., \verb{us-east-2a}).

The \verb{create disk} operation supports tag-based access control via
request tags. For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_disk(
  diskName = "string",
  availabilityZone = "string",
  sizeInGb = 123,
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  addOns = list(
    list(
      addOnType = "AutoSnapshot",
      autoSnapshotAddOnRequest = list(
        snapshotTimeOfDay = "string"
      )
    )
  )
)
}
}

\keyword{internal}
