% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_create_event_source_mapping}
\alias{lambda_create_event_source_mapping}
\title{Creates a mapping between an event source and an AWS Lambda function}
\usage{
lambda_create_event_source_mapping(EventSourceArn, FunctionName,
  Enabled, BatchSize, StartingPosition, StartingPositionTimestamp)
}
\arguments{
\item{EventSourceArn}{[required] The Amazon Resource Name (ARN) of the event source.
\itemize{
\item \strong{Amazon Kinesis} - The ARN of the data stream or a stream
consumer.
\item \strong{Amazon DynamoDB Streams} - The ARN of the stream.
\item \strong{Amazon Simple Queue Service} - The ARN of the queue.
}}

\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\code{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} -
\code{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} - \code{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Enabled}{Disables the event source mapping to pause polling and invocation.}

\item{BatchSize}{The maximum number of items to retrieve in a single batch.
\itemize{
\item \strong{Amazon Kinesis} - Default 100. Max 10,000.
\item \strong{Amazon DynamoDB Streams} - Default 100. Max 1,000.
\item \strong{Amazon Simple Queue Service} - Default 10. Max 10.
}}

\item{StartingPosition}{The position in a stream from which to start reading. Required for
Amazon Kinesis and Amazon DynamoDB Streams sources. \code{AT_TIMESTAMP} is
only supported for Amazon Kinesis streams.}

\item{StartingPositionTimestamp}{With \code{StartingPosition} set to \code{AT_TIMESTAMP}, the time from which to
start reading.}
}
\description{
Creates a mapping between an event source and an AWS Lambda function.
Lambda reads items from the event source and triggers the function.
}
\details{
For details about each event source type, see the following topics.
\itemize{
\item \href{https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html}{Using AWS Lambda with Amazon Kinesis}
\item \href{https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html}{Using AWS Lambda with Amazon SQS}
\item \href{https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html}{Using AWS Lambda with Amazon DynamoDB}
}
}
\section{Request syntax}{
\preformatted{svc$create_event_source_mapping(
  EventSourceArn = "string",
  FunctionName = "string",
  Enabled = TRUE|FALSE,
  BatchSize = 123,
  StartingPosition = "TRIM_HORIZON"|"LATEST"|"AT_TIMESTAMP",
  StartingPositionTimestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
