% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_default_credit_specification}
\alias{ec2_get_default_credit_specification}
\title{Describes the default credit option for CPU usage of a burstable
performance instance family}
\usage{
ec2_get_default_credit_specification(DryRun, InstanceFamily)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceFamily}{[required] The instance family.}
}
\description{
Describes the default credit option for CPU usage of a burstable
performance instance family.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html}{Burstable Performance Instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_default_credit_specification(
  DryRun = TRUE|FALSE,
  InstanceFamily = "t2"|"t3"|"t3a"
)
}
}

\keyword{internal}
