% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_snapshot_tier_status}
\alias{ec2_describe_snapshot_tier_status}
\title{Describes the storage tier status of one or more Amazon EBS snapshots}
\usage{
ec2_describe_snapshot_tier_status(
  Filters = NULL,
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{snapshot-id} - The snapshot ID.
\item \code{volume-id} - The ID of the volume the snapshot is for.
\item \code{last-tiering-operation} - The state of the last archive or restore
action. (\verb{archival-in-progress} | \code{archival-completed} |
\code{archival-failed} | \verb{permanent-restore-in-progress} |
\code{permanent-restore-completed} | \code{permanent-restore-failed} |
\verb{temporary-restore-in-progress} | \code{temporary-restore-completed} |
\code{temporary-restore-failed})
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes the storage tier status of one or more Amazon EBS snapshots.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_snapshot_tier_status/} for full documentation.
}
\keyword{internal}
