# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lightsail_service.R
NULL

#' Allocates a static IP address
#'
#' @description
#' Allocates a static IP address.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_allocate_static_ip/](https://www.paws-r-sdk.com/docs/lightsail_allocate_static_ip/) for full documentation.
#'
#' @param staticIpName &#91;required&#93; The name of the static IP address.
#'
#' @keywords internal
#'
#' @rdname lightsail_allocate_static_ip
lightsail_allocate_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "AllocateStaticIp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$allocate_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$allocate_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$allocate_static_ip <- lightsail_allocate_static_ip

#' Attaches an SSL/TLS certificate to your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_attach_certificate_to_distribution/](https://www.paws-r-sdk.com/docs/lightsail_attach_certificate_to_distribution/) for full documentation.
#'
#' @param distributionName &#91;required&#93; The name of the distribution that the certificate will be attached to.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param certificateName &#91;required&#93; The name of the certificate to attach to a distribution.
#' 
#' Only certificates with a status of `ISSUED` can be attached to a
#' distribution.
#' 
#' Use the [`get_certificates`][lightsail_get_certificates] action to get a
#' list of certificate names that you can specify.
#' 
#' This is the name of the certificate resource type and is used only to
#' reference the certificate in other API actions. It can be different than
#' the domain name of the certificate. For example, your certificate name
#' might be `WordPress-Blog-Certificate` and the domain name of the
#' certificate might be `example.com`.
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_certificate_to_distribution
lightsail_attach_certificate_to_distribution <- function(distributionName, certificateName) {
  op <- new_operation(
    name = "AttachCertificateToDistribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$attach_certificate_to_distribution_input(distributionName = distributionName, certificateName = certificateName)
  output <- .lightsail$attach_certificate_to_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_certificate_to_distribution <- lightsail_attach_certificate_to_distribution

#' Attaches a block storage disk to a running or stopped Lightsail instance
#' and exposes it to the instance with the specified disk name
#'
#' @description
#' Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the specified disk name.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_attach_disk/](https://www.paws-r-sdk.com/docs/lightsail_attach_disk/) for full documentation.
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (`my-disk`).
#' @param instanceName &#91;required&#93; The name of the Lightsail instance where you want to utilize the storage
#' disk.
#' @param diskPath &#91;required&#93; The disk path to expose to the instance (`/dev/xvdf`).
#' @param autoMounting A Boolean value used to determine the automatic mounting of a storage
#' volume to a virtual computer. The default value is `False`.
#' 
#' This value only applies to Lightsail for Research resources.
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_disk
lightsail_attach_disk <- function(diskName, instanceName, diskPath, autoMounting = NULL) {
  op <- new_operation(
    name = "AttachDisk",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$attach_disk_input(diskName = diskName, instanceName = instanceName, diskPath = diskPath, autoMounting = autoMounting)
  output <- .lightsail$attach_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_disk <- lightsail_attach_disk

#' Attaches one or more Lightsail instances to a load balancer
#'
#' @description
#' Attaches one or more Lightsail instances to a load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_attach_instances_to_load_balancer/](https://www.paws-r-sdk.com/docs/lightsail_attach_instances_to_load_balancer/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#' @param instanceNames &#91;required&#93; An array of strings representing the instance name(s) you want to attach
#' to your load balancer.
#' 
#' An instance must be `running` before you can attach it to your load
#' balancer.
#' 
#' There are no additional limits on the number of instances you can attach
#' to your load balancer, aside from the limit of Lightsail instances you
#' can create in your account (20).
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_instances_to_load_balancer
lightsail_attach_instances_to_load_balancer <- function(loadBalancerName, instanceNames) {
  op <- new_operation(
    name = "AttachInstancesToLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$attach_instances_to_load_balancer_input(loadBalancerName = loadBalancerName, instanceNames = instanceNames)
  output <- .lightsail$attach_instances_to_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_instances_to_load_balancer <- lightsail_attach_instances_to_load_balancer

#' Attaches a Transport Layer Security (TLS) certificate to your load
#' balancer
#'
#' @description
#' Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure version of Secure Socket Layer (SSL).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_attach_load_balancer_tls_certificate/](https://www.paws-r-sdk.com/docs/lightsail_attach_load_balancer_tls_certificate/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer to which you want to associate the SSL/TLS
#' certificate.
#' @param certificateName &#91;required&#93; The name of your SSL/TLS certificate.
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_load_balancer_tls_certificate
lightsail_attach_load_balancer_tls_certificate <- function(loadBalancerName, certificateName) {
  op <- new_operation(
    name = "AttachLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$attach_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName)
  output <- .lightsail$attach_load_balancer_tls_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_load_balancer_tls_certificate <- lightsail_attach_load_balancer_tls_certificate

#' Attaches a static IP address to a specific Amazon Lightsail instance
#'
#' @description
#' Attaches a static IP address to a specific Amazon Lightsail instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_attach_static_ip/](https://www.paws-r-sdk.com/docs/lightsail_attach_static_ip/) for full documentation.
#'
#' @param staticIpName &#91;required&#93; The name of the static IP.
#' @param instanceName &#91;required&#93; The instance name to which you want to attach the static IP address.
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_static_ip
lightsail_attach_static_ip <- function(staticIpName, instanceName) {
  op <- new_operation(
    name = "AttachStaticIp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$attach_static_ip_input(staticIpName = staticIpName, instanceName = instanceName)
  output <- .lightsail$attach_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_static_ip <- lightsail_attach_static_ip

#' Closes ports for a specific Amazon Lightsail instance
#'
#' @description
#' Closes ports for a specific Amazon Lightsail instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_close_instance_public_ports/](https://www.paws-r-sdk.com/docs/lightsail_close_instance_public_ports/) for full documentation.
#'
#' @param portInfo &#91;required&#93; An object to describe the ports to close for the specified instance.
#' @param instanceName &#91;required&#93; The name of the instance for which to close ports.
#'
#' @keywords internal
#'
#' @rdname lightsail_close_instance_public_ports
lightsail_close_instance_public_ports <- function(portInfo, instanceName) {
  op <- new_operation(
    name = "CloseInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$close_instance_public_ports_input(portInfo = portInfo, instanceName = instanceName)
  output <- .lightsail$close_instance_public_ports_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$close_instance_public_ports <- lightsail_close_instance_public_ports

#' Copies a manual snapshot of an instance or disk as another manual
#' snapshot, or copies an automatic snapshot of an instance or disk as a
#' manual snapshot
#'
#' @description
#' Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of an instance or a disk from one Amazon Web Services Region to another in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_copy_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_copy_snapshot/) for full documentation.
#'
#' @param sourceSnapshotName The name of the source manual snapshot to copy.
#' 
#' Constraint:
#' 
#' -   Define this parameter only when copying a manual snapshot as another
#'     manual snapshot.
#' @param sourceResourceName The name of the source instance or disk from which the source automatic
#' snapshot was created.
#' 
#' Constraint:
#' 
#' -   Define this parameter only when copying an automatic snapshot as a
#'     manual snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-keeping-automatic-snapshots.html).
#' @param restoreDate The date of the source automatic snapshot to copy. Use the
#' `get auto snapshots` operation to identify the dates of the available
#' automatic snapshots.
#' 
#' Constraints:
#' 
#' -   Must be specified in `YYYY-MM-DD` format.
#' 
#' -   This parameter cannot be defined together with the
#'     `use latest restorable auto snapshot` parameter. The `restore date`
#'     and `use latest restorable auto snapshot` parameters are mutually
#'     exclusive.
#' 
#' -   Define this parameter only when copying an automatic snapshot as a
#'     manual snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-keeping-automatic-snapshots.html).
#' @param useLatestRestorableAutoSnapshot A Boolean value to indicate whether to use the latest available
#' automatic snapshot of the specified source instance or disk.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the `restore date`
#'     parameter. The `use latest restorable auto snapshot` and
#'     `restore date` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when copying an automatic snapshot as a
#'     manual snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-keeping-automatic-snapshots.html).
#' @param targetSnapshotName &#91;required&#93; The name of the new manual snapshot to be created as a copy.
#' @param sourceRegion &#91;required&#93; The Amazon Web Services Region where the source manual or automatic
#' snapshot is located.
#'
#' @keywords internal
#'
#' @rdname lightsail_copy_snapshot
lightsail_copy_snapshot <- function(sourceSnapshotName = NULL, sourceResourceName = NULL, restoreDate = NULL, useLatestRestorableAutoSnapshot = NULL, targetSnapshotName, sourceRegion) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$copy_snapshot_input(sourceSnapshotName = sourceSnapshotName, sourceResourceName = sourceResourceName, restoreDate = restoreDate, useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot, targetSnapshotName = targetSnapshotName, sourceRegion = sourceRegion)
  output <- .lightsail$copy_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$copy_snapshot <- lightsail_copy_snapshot

#' Creates an Amazon Lightsail bucket
#'
#' @description
#' Creates an Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_bucket/](https://www.paws-r-sdk.com/docs/lightsail_create_bucket/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name for the bucket.
#' 
#' For more information about bucket names, see [Bucket naming rules in
#' Amazon
#' Lightsail](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/bucket-naming-rules-in-amazon-lightsail.html)
#' in the *Amazon Lightsail Developer Guide*.
#' @param bundleId &#91;required&#93; The ID of the bundle to use for the bucket.
#' 
#' A bucket bundle specifies the monthly cost, storage space, and data
#' transfer quota for a bucket.
#' 
#' Use the [`get_bucket_bundles`][lightsail_get_bucket_bundles] action to
#' get a list of bundle IDs that you can specify.
#' 
#' Use the [`update_bucket_bundle`][lightsail_update_bucket_bundle] action
#' to change the bundle after the bucket is created.
#' @param tags The tag keys and optional values to add to the bucket during creation.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag the
#' bucket after it's created.
#' @param enableObjectVersioning A Boolean value that indicates whether to enable versioning of objects
#' in the bucket.
#' 
#' For more information about versioning, see [Enabling and suspending
#' object versioning in a bucket in Amazon
#' Lightsail](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-managing-bucket-object-versioning.html)
#' in the *Amazon Lightsail Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_bucket
lightsail_create_bucket <- function(bucketName, bundleId, tags = NULL, enableObjectVersioning = NULL) {
  op <- new_operation(
    name = "CreateBucket",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_bucket_input(bucketName = bucketName, bundleId = bundleId, tags = tags, enableObjectVersioning = enableObjectVersioning)
  output <- .lightsail$create_bucket_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_bucket <- lightsail_create_bucket

#' Creates a new access key for the specified Amazon Lightsail bucket
#'
#' @description
#' Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of an access key ID and corresponding secret access key.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_bucket_access_key/](https://www.paws-r-sdk.com/docs/lightsail_create_bucket_access_key/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name of the bucket that the new access key will belong to, and grant
#' access to.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_bucket_access_key
lightsail_create_bucket_access_key <- function(bucketName) {
  op <- new_operation(
    name = "CreateBucketAccessKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_bucket_access_key_input(bucketName = bucketName)
  output <- .lightsail$create_bucket_access_key_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_bucket_access_key <- lightsail_create_bucket_access_key

#' Creates an SSL/TLS certificate for an Amazon Lightsail content delivery
#' network (CDN) distribution and a container service
#'
#' @description
#' Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_certificate/](https://www.paws-r-sdk.com/docs/lightsail_create_certificate/) for full documentation.
#'
#' @param certificateName &#91;required&#93; The name for the certificate.
#' @param domainName &#91;required&#93; The domain name (`example.com`) for the certificate.
#' @param subjectAlternativeNames An array of strings that specify the alternate domains (`example2.com`)
#' and subdomains (`blog.example.com`) for the certificate.
#' 
#' You can specify a maximum of nine alternate domains (in addition to the
#' primary domain name).
#' 
#' Wildcard domain entries (`*.example.com`) are not supported.
#' @param tags The tag keys and optional values to add to the certificate during
#' create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_certificate
lightsail_create_certificate <- function(certificateName, domainName, subjectAlternativeNames = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_certificate_input(certificateName = certificateName, domainName = domainName, subjectAlternativeNames = subjectAlternativeNames, tags = tags)
  output <- .lightsail$create_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_certificate <- lightsail_create_certificate

#' Creates an AWS CloudFormation stack, which creates a new Amazon EC2
#' instance from an exported Amazon Lightsail snapshot
#'
#' @description
#' Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS CloudFormation stack created. Use the `get cloud formation stack records` operation to get a list of the CloudFormation stacks created.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_cloud_formation_stack/](https://www.paws-r-sdk.com/docs/lightsail_create_cloud_formation_stack/) for full documentation.
#'
#' @param instances &#91;required&#93; An array of parameters that will be used to create the new Amazon EC2
#' instance. You can only pass one instance entry at a time in this array.
#' You will get an invalid parameter error if you pass more than one
#' instance entry in this array.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_cloud_formation_stack
lightsail_create_cloud_formation_stack <- function(instances) {
  op <- new_operation(
    name = "CreateCloudFormationStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_cloud_formation_stack_input(instances = instances)
  output <- .lightsail$create_cloud_formation_stack_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_cloud_formation_stack <- lightsail_create_cloud_formation_stack

#' Creates an email or SMS text message contact method
#'
#' @description
#' Creates an email or SMS text message contact method.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_contact_method/](https://www.paws-r-sdk.com/docs/lightsail_create_contact_method/) for full documentation.
#'
#' @param protocol &#91;required&#93; The protocol of the contact method, such as `Email` or `SMS` (text
#' messaging).
#' 
#' The `SMS` protocol is supported only in the following Amazon Web
#' Services Regions.
#' 
#' -   US East (N. Virginia) (`us-east-1`)
#' 
#' -   US West (Oregon) (`us-west-2`)
#' 
#' -   Europe (Ireland) (`eu-west-1`)
#' 
#' -   Asia Pacific (Tokyo) (`ap-northeast-1`)
#' 
#' -   Asia Pacific (Singapore) (`ap-southeast-1`)
#' 
#' -   Asia Pacific (Sydney) (`ap-southeast-2`)
#' 
#' For a list of countries/regions where SMS text messages can be sent, and
#' the latest Amazon Web Services Regions where SMS text messaging is
#' supported, see [Supported Regions and
#' Countries](https://docs.aws.amazon.com/sms-voice/latest/userguide/phone-numbers-sms-by-country.html)
#' in the *Amazon SNS Developer Guide*.
#' 
#' For more information about notifications in Amazon Lightsail, see
#' [Notifications in Amazon
#' Lightsail](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-notifications.html).
#' @param contactEndpoint &#91;required&#93; The destination of the contact method, such as an email address or a
#' mobile phone number.
#' 
#' Use the E.164 format when specifying a mobile phone number. E.164 is a
#' standard for the phone number structure used for international
#' telecommunication. Phone numbers that follow this format can have a
#' maximum of 15 digits, and they are prefixed with the plus character (+)
#' and the country code. For example, a U.S. phone number in E.164 format
#' would be specified as +1XXX5550100. For more information, see
#' [E.164](https://en.wikipedia.org/wiki/E.164) on *Wikipedia*.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_contact_method
lightsail_create_contact_method <- function(protocol, contactEndpoint) {
  op <- new_operation(
    name = "CreateContactMethod",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_contact_method_input(protocol = protocol, contactEndpoint = contactEndpoint)
  output <- .lightsail$create_contact_method_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_contact_method <- lightsail_create_contact_method

#' Creates an Amazon Lightsail container service
#'
#' @description
#' Creates an Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_container_service/](https://www.paws-r-sdk.com/docs/lightsail_create_container_service/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name for the container service.
#' 
#' The name that you specify for your container service will make up part
#' of its default domain. The default domain of a container service is
#' typically
#' `https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com`.
#' If the name of your container service is `container-service-1`, and it's
#' located in the US East (Ohio) Amazon Web Services Region (`us-east-2`),
#' then the domain for your container service will be like the following
#' example:
#' `https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com`
#' 
#' The following are the requirements for container service names:
#' 
#' -   Must be unique within each Amazon Web Services Region in your
#'     Lightsail account.
#' 
#' -   Must contain 1 to 63 characters.
#' 
#' -   Must contain only alphanumeric characters and hyphens.
#' 
#' -   A hyphen (-) can separate words but cannot be at the start or end of
#'     the name.
#' @param power &#91;required&#93; The power specification for the container service.
#' 
#' The power specifies the amount of memory, vCPUs, and base monthly cost
#' of each node of the container service. The `power` and `scale` of a
#' container service makes up its configured capacity. To determine the
#' monthly price of your container service, multiply the base price of the
#' `power` with the `scale` (the number of nodes) of the service.
#' 
#' Use the
#' [`get_container_service_powers`][lightsail_get_container_service_powers]
#' action to get a list of power options that you can specify using this
#' parameter, and their base monthly cost.
#' @param scale &#91;required&#93; The scale specification for the container service.
#' 
#' The scale specifies the allocated compute nodes of the container
#' service. The `power` and `scale` of a container service makes up its
#' configured capacity. To determine the monthly price of your container
#' service, multiply the base price of the `power` with the `scale` (the
#' number of nodes) of the service.
#' @param tags The tag keys and optional values to add to the container service during
#' create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' 
#' For more information about tags in Lightsail, see the [Amazon Lightsail
#' Developer
#' Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-tags.html).
#' @param publicDomainNames The public domain names to use with the container service, such as
#' `example.com` and `www.example.com`.
#' 
#' You can specify up to four public domain names for a container service.
#' The domain names that you specify are used when you create a deployment
#' with a container configured as the public endpoint of your container
#' service.
#' 
#' If you don't specify public domain names, then you can use the default
#' domain of the container service.
#' 
#' You must create and validate an SSL/TLS certificate before you can use
#' public domain names with your container service. Use the
#' [`create_certificate`][lightsail_create_certificate] action to create a
#' certificate for the public domain names you want to use with your
#' container service.
#' 
#' You can specify public domain names using a string to array map as shown
#' in the example later on this page.
#' @param deployment An object that describes a deployment for the container service.
#' 
#' A deployment specifies the containers that will be launched on the
#' container service and their settings, such as the ports to open, the
#' environment variables to apply, and the launch command to run. It also
#' specifies the container that will serve as the public endpoint of the
#' deployment and its settings, such as the HTTP or HTTPS port to use, and
#' the health check configuration.
#' @param privateRegistryAccess An object to describe the configuration for the container service to
#' access private container image repositories, such as Amazon Elastic
#' Container Registry (Amazon ECR) private repositories.
#' 
#' For more information, see [Configuring access to an Amazon ECR private
#' repository for an Amazon Lightsail container
#' service](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-container-service-ecr-private-repo-access.html)
#' in the *Amazon Lightsail Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_container_service
lightsail_create_container_service <- function(serviceName, power, scale, tags = NULL, publicDomainNames = NULL, deployment = NULL, privateRegistryAccess = NULL) {
  op <- new_operation(
    name = "CreateContainerService",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_container_service_input(serviceName = serviceName, power = power, scale = scale, tags = tags, publicDomainNames = publicDomainNames, deployment = deployment, privateRegistryAccess = privateRegistryAccess)
  output <- .lightsail$create_container_service_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_container_service <- lightsail_create_container_service

#' Creates a deployment for your Amazon Lightsail container service
#'
#' @description
#' Creates a deployment for your Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_container_service_deployment/](https://www.paws-r-sdk.com/docs/lightsail_create_container_service_deployment/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to create the deployment.
#' @param containers An object that describes the settings of the containers that will be
#' launched on the container service.
#' @param publicEndpoint An object that describes the settings of the public endpoint for the
#' container service.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_container_service_deployment
lightsail_create_container_service_deployment <- function(serviceName, containers = NULL, publicEndpoint = NULL) {
  op <- new_operation(
    name = "CreateContainerServiceDeployment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_container_service_deployment_input(serviceName = serviceName, containers = containers, publicEndpoint = publicEndpoint)
  output <- .lightsail$create_container_service_deployment_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_container_service_deployment <- lightsail_create_container_service_deployment

#' Creates a temporary set of log in credentials that you can use to log in
#' to the Docker process on your local machine
#'
#' @description
#' Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local machine. After you're logged in, you can use the native Docker commands to push your local container images to the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail container service. The log in credentials expire 12 hours after they are created, at which point you will need to create a new set of log in credentials.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_container_service_registry_login/](https://www.paws-r-sdk.com/docs/lightsail_create_container_service_registry_login/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_create_container_service_registry_login
lightsail_create_container_service_registry_login <- function() {
  op <- new_operation(
    name = "CreateContainerServiceRegistryLogin",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_container_service_registry_login_input()
  output <- .lightsail$create_container_service_registry_login_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_container_service_registry_login <- lightsail_create_container_service_registry_login

#' Creates a block storage disk that can be attached to an Amazon Lightsail
#' instance in the same Availability Zone (us-east-2a)
#'
#' @description
#' Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_disk/](https://www.paws-r-sdk.com/docs/lightsail_create_disk/) for full documentation.
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (`my-disk`).
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create the disk (`us-east-2a`).
#' Use the same Availability Zone as the Lightsail instance to which you
#' want to attach the disk.
#' 
#' Use the `get regions` operation to list the Availability Zones where
#' Lightsail is currently available.
#' @param sizeInGb &#91;required&#93; The size of the disk in GB (`32`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects that represent the add-ons to enable for the new
#' disk.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk
lightsail_create_disk <- function(diskName, availabilityZone, sizeInGb, tags = NULL, addOns = NULL) {
  op <- new_operation(
    name = "CreateDisk",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_disk_input(diskName = diskName, availabilityZone = availabilityZone, sizeInGb = sizeInGb, tags = tags, addOns = addOns)
  output <- .lightsail$create_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk <- lightsail_create_disk

#' Creates a block storage disk from a manual or automatic snapshot of a
#' disk
#'
#' @description
#' Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to an Amazon Lightsail instance in the same Availability Zone (`us-east-2a`).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_disk_from_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_create_disk_from_snapshot/) for full documentation.
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (`my-disk`).
#' @param diskSnapshotName The name of the disk snapshot (`my-snapshot`) from which to create the
#' new storage disk.
#' 
#' Constraint:
#' 
#' -   This parameter cannot be defined together with the
#'     `source disk name` parameter. The `disk snapshot name` and
#'     `source disk name` parameters are mutually exclusive.
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create the disk (`us-east-2a`).
#' Choose the same Availability Zone as the Lightsail instance where you
#' want to create the disk.
#' 
#' Use the GetRegions operation to list the Availability Zones where
#' Lightsail is currently available.
#' @param sizeInGb &#91;required&#93; The size of the disk in GB (`32`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects that represent the add-ons to enable for the new
#' disk.
#' @param sourceDiskName The name of the source disk from which the source automatic snapshot was
#' created.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the
#'     `disk snapshot name` parameter. The `source disk name` and
#'     `disk snapshot name` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new disk from an
#'     automatic snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#' @param restoreDate The date of the automatic snapshot to use for the new disk. Use the
#' `get auto snapshots` operation to identify the dates of the available
#' automatic snapshots.
#' 
#' Constraints:
#' 
#' -   Must be specified in `YYYY-MM-DD` format.
#' 
#' -   This parameter cannot be defined together with the
#'     `use latest restorable auto snapshot` parameter. The `restore date`
#'     and `use latest restorable auto snapshot` parameters are mutually
#'     exclusive.
#' 
#' -   Define this parameter only when creating a new disk from an
#'     automatic snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#' @param useLatestRestorableAutoSnapshot A Boolean value to indicate whether to use the latest available
#' automatic snapshot.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the `restore date`
#'     parameter. The `use latest restorable auto snapshot` and
#'     `restore date` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new disk from an
#'     automatic snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk_from_snapshot
lightsail_create_disk_from_snapshot <- function(diskName, diskSnapshotName = NULL, availabilityZone, sizeInGb, tags = NULL, addOns = NULL, sourceDiskName = NULL, restoreDate = NULL, useLatestRestorableAutoSnapshot = NULL) {
  op <- new_operation(
    name = "CreateDiskFromSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_disk_from_snapshot_input(diskName = diskName, diskSnapshotName = diskSnapshotName, availabilityZone = availabilityZone, sizeInGb = sizeInGb, tags = tags, addOns = addOns, sourceDiskName = sourceDiskName, restoreDate = restoreDate, useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot)
  output <- .lightsail$create_disk_from_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk_from_snapshot <- lightsail_create_disk_from_snapshot

#' Creates a snapshot of a block storage disk
#'
#' @description
#' Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to save data before shutting down a Lightsail instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_disk_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_create_disk_snapshot/) for full documentation.
#'
#' @param diskName The unique name of the source disk (`Disk-Virginia-1`).
#' 
#' This parameter cannot be defined together with the `instance name`
#' parameter. The `disk name` and `instance name` parameters are mutually
#' exclusive.
#' @param diskSnapshotName &#91;required&#93; The name of the destination disk snapshot (`my-disk-snapshot`) based on
#' the source disk.
#' @param instanceName The unique name of the source instance
#' (`Amazon_Linux-512MB-Virginia-1`). When this is defined, a snapshot of
#' the instance's system volume is created.
#' 
#' This parameter cannot be defined together with the `disk name`
#' parameter. The `instance name` and `disk name` parameters are mutually
#' exclusive.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk_snapshot
lightsail_create_disk_snapshot <- function(diskName = NULL, diskSnapshotName, instanceName = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_disk_snapshot_input(diskName = diskName, diskSnapshotName = diskSnapshotName, instanceName = instanceName, tags = tags)
  output <- .lightsail$create_disk_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk_snapshot <- lightsail_create_disk_snapshot

#' Creates an Amazon Lightsail content delivery network (CDN) distribution
#'
#' @description
#' Creates an Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_distribution/](https://www.paws-r-sdk.com/docs/lightsail_create_distribution/) for full documentation.
#'
#' @param distributionName &#91;required&#93; The name for the distribution.
#' @param origin &#91;required&#93; An object that describes the origin resource for the distribution, such
#' as a Lightsail instance, bucket, or load balancer.
#' 
#' The distribution pulls, caches, and serves content from the origin.
#' @param defaultCacheBehavior &#91;required&#93; An object that describes the default cache behavior for the
#' distribution.
#' @param cacheBehaviorSettings An object that describes the cache behavior settings for the
#' distribution.
#' @param cacheBehaviors An array of objects that describe the per-path cache behavior for the
#' distribution.
#' @param bundleId &#91;required&#93; The bundle ID to use for the distribution.
#' 
#' A distribution bundle describes the specifications of your distribution,
#' such as the monthly cost and monthly network transfer quota.
#' 
#' Use the [`get_distribution_bundles`][lightsail_get_distribution_bundles]
#' action to get a list of distribution bundle IDs that you can specify.
#' @param ipAddressType The IP address type for the distribution.
#' 
#' The possible values are `ipv4` for IPv4 only, and `dualstack` for IPv4
#' and IPv6.
#' 
#' The default value is `dualstack`.
#' @param tags The tag keys and optional values to add to the distribution during
#' create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param certificateName The name of the SSL/TLS certificate that you want to attach to the
#' distribution.
#' 
#' Use the [`get_certificates`][lightsail_get_certificates] action to get a
#' list of certificate names that you can specify.
#' @param viewerMinimumTlsProtocolVersion The minimum TLS protocol version for the SSL/TLS certificate.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_distribution
lightsail_create_distribution <- function(distributionName, origin, defaultCacheBehavior, cacheBehaviorSettings = NULL, cacheBehaviors = NULL, bundleId, ipAddressType = NULL, tags = NULL, certificateName = NULL, viewerMinimumTlsProtocolVersion = NULL) {
  op <- new_operation(
    name = "CreateDistribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_distribution_input(distributionName = distributionName, origin = origin, defaultCacheBehavior = defaultCacheBehavior, cacheBehaviorSettings = cacheBehaviorSettings, cacheBehaviors = cacheBehaviors, bundleId = bundleId, ipAddressType = ipAddressType, tags = tags, certificateName = certificateName, viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion)
  output <- .lightsail$create_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_distribution <- lightsail_create_distribution

#' Creates a domain resource for the specified domain (example
#'
#' @description
#' Creates a domain resource for the specified domain (example.com).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_domain/](https://www.paws-r-sdk.com/docs/lightsail_create_domain/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name to manage (`example.com`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_domain
lightsail_create_domain <- function(domainName, tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_domain_input(domainName = domainName, tags = tags)
  output <- .lightsail$create_domain_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_domain <- lightsail_create_domain

#' Creates one of the following domain name system (DNS) records in a
#' domain DNS zone: Address (A), canonical name (CNAME), mail exchanger
#' (MX), name server (NS), start of authority (SOA), service locator (SRV),
#' or text (TXT)
#'
#' @description
#' Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_domain_entry/](https://www.paws-r-sdk.com/docs/lightsail_create_domain_entry/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name (`example.com`) for which you want to create the domain
#' entry.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about the domain
#' entry request.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_domain_entry
lightsail_create_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "CreateDomainEntry",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$create_domain_entry_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_domain_entry <- lightsail_create_domain_entry

#' Creates two URLs that are used to access a virtual computer’s graphical
#' user interface (GUI) session
#'
#' @description
#' Creates two URLs that are used to access a virtual computer’s graphical user interface (GUI) session. The primary URL initiates a web-based NICE DCV session to the virtual computer's application. The secondary URL initiates a web-based NICE DCV session to the virtual computer's operating session.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_gui_session_access_details/](https://www.paws-r-sdk.com/docs/lightsail_create_gui_session_access_details/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The resource name.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_gui_session_access_details
lightsail_create_gui_session_access_details <- function(resourceName) {
  op <- new_operation(
    name = "CreateGUISessionAccessDetails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_gui_session_access_details_input(resourceName = resourceName)
  output <- .lightsail$create_gui_session_access_details_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_gui_session_access_details <- lightsail_create_gui_session_access_details

#' Creates a snapshot of a specific virtual private server, or instance
#'
#' @description
#' Creates a snapshot of a specific virtual private server, or *instance*. You can use a snapshot to create a new instance that is based on that snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_instance_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_create_instance_snapshot/) for full documentation.
#'
#' @param instanceSnapshotName &#91;required&#93; The name for your new snapshot.
#' @param instanceName &#91;required&#93; The Lightsail instance on which to base your snapshot.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instance_snapshot
lightsail_create_instance_snapshot <- function(instanceSnapshotName, instanceName, tags = NULL) {
  op <- new_operation(
    name = "CreateInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName, instanceName = instanceName, tags = tags)
  output <- .lightsail$create_instance_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instance_snapshot <- lightsail_create_instance_snapshot

#' Creates one or more Amazon Lightsail instances
#'
#' @description
#' Creates one or more Amazon Lightsail instances.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_instances/](https://www.paws-r-sdk.com/docs/lightsail_create_instances/) for full documentation.
#'
#' @param instanceNames &#91;required&#93; The names to use for your new Lightsail instances. Separate multiple
#' values using quotation marks and commas, for example:
#' `["MyFirstInstance","MySecondInstance"]`
#' @param availabilityZone &#91;required&#93; The Availability Zone in which to create your instance. Use the
#' following format: `us-east-2a` (case sensitive). You can get a list of
#' Availability Zones by using the [get
#' regions](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
#' operation. Be sure to add the `include Availability Zones` parameter to
#' your request.
#' @param customImageName (Discontinued) The name for your custom image.
#' 
#' In releases prior to June 12, 2017, this parameter was ignored by the
#' API. It is now discontinued.
#' @param blueprintId &#91;required&#93; The ID for a virtual private server image (`app_wordpress_x_x` or
#' `app_lamp_x_x`). Use the `get blueprints` operation to return a list of
#' available images (or *blueprints*).
#' 
#' Use active blueprints when creating new instances. Inactive blueprints
#' are listed to support customers with existing instances and are not
#' necessarily available to create new instances. Blueprints are marked
#' inactive when they become outdated due to operating system updates or
#' new application releases.
#' @param bundleId &#91;required&#93; The bundle of specification information for your virtual private server
#' (or *instance*), including the pricing plan (`medium_x_x`).
#' @param userData A launch script you can create that configures a server with additional
#' user data. For example, you might want to run `apt-get -y update`.
#' 
#' Depending on the machine image you choose, the command to get software
#' on your instance varies. Amazon Linux and CentOS use `yum`, Debian and
#' Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see
#' the [Amazon Lightsail Developer
#' Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/compare-options-choose-lightsail-instance-image.html).
#' @param keyPairName The name of your key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects representing the add-ons to enable for the new
#' instance.
#' @param ipAddressType The IP address type for the instance.
#' 
#' The possible values are `ipv4` for IPv4 only, `ipv6` for IPv6 only, and
#' `dualstack` for IPv4 and IPv6.
#' 
#' The default value is `dualstack`.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instances
lightsail_create_instances <- function(instanceNames, availabilityZone, customImageName = NULL, blueprintId, bundleId, userData = NULL, keyPairName = NULL, tags = NULL, addOns = NULL, ipAddressType = NULL) {
  op <- new_operation(
    name = "CreateInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_instances_input(instanceNames = instanceNames, availabilityZone = availabilityZone, customImageName = customImageName, blueprintId = blueprintId, bundleId = bundleId, userData = userData, keyPairName = keyPairName, tags = tags, addOns = addOns, ipAddressType = ipAddressType)
  output <- .lightsail$create_instances_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instances <- lightsail_create_instances

#' Creates one or more new instances from a manual or automatic snapshot of
#' an instance
#'
#' @description
#' Creates one or more new instances from a manual or automatic snapshot of an instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_instances_from_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_create_instances_from_snapshot/) for full documentation.
#'
#' @param instanceNames &#91;required&#93; The names for your new instances.
#' @param attachedDiskMapping An object containing information about one or more disk mappings.
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create your instances. Use the
#' following formatting: `us-east-2a` (case sensitive). You can get a list
#' of Availability Zones by using the [get
#' regions](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
#' operation. Be sure to add the `include Availability Zones` parameter to
#' your request.
#' @param instanceSnapshotName The name of the instance snapshot on which you are basing your new
#' instances. Use the get instance snapshots operation to return
#' information about your existing snapshots.
#' 
#' Constraint:
#' 
#' -   This parameter cannot be defined together with the
#'     `source instance name` parameter. The `instance snapshot name` and
#'     `source instance name` parameters are mutually exclusive.
#' @param bundleId &#91;required&#93; The bundle of specification information for your virtual private server
#' (or *instance*), including the pricing plan (`micro_x_x`).
#' @param userData You can create a launch script that configures a server with additional
#' user data. For example, `apt-get -y update`.
#' 
#' Depending on the machine image you choose, the command to get software
#' on your instance varies. Amazon Linux and CentOS use `yum`, Debian and
#' Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see
#' the [Amazon Lightsail Developer
#' Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/compare-options-choose-lightsail-instance-image.html).
#' @param keyPairName The name for your key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects representing the add-ons to enable for the new
#' instance.
#' @param ipAddressType The IP address type for the instance.
#' 
#' The possible values are `ipv4` for IPv4 only, `ipv6` for IPv6 only, and
#' `dualstack` for IPv4 and IPv6.
#' 
#' The default value is `dualstack`.
#' @param sourceInstanceName The name of the source instance from which the source automatic snapshot
#' was created.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the
#'     `instance snapshot name` parameter. The `source instance name` and
#'     `instance snapshot name` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new instance from an
#'     automatic snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#' @param restoreDate The date of the automatic snapshot to use for the new instance. Use the
#' `get auto snapshots` operation to identify the dates of the available
#' automatic snapshots.
#' 
#' Constraints:
#' 
#' -   Must be specified in `YYYY-MM-DD` format.
#' 
#' -   This parameter cannot be defined together with the
#'     `use latest restorable auto snapshot` parameter. The `restore date`
#'     and `use latest restorable auto snapshot` parameters are mutually
#'     exclusive.
#' 
#' -   Define this parameter only when creating a new instance from an
#'     automatic snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#' @param useLatestRestorableAutoSnapshot A Boolean value to indicate whether to use the latest available
#' automatic snapshot.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the `restore date`
#'     parameter. The `use latest restorable auto snapshot` and
#'     `restore date` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new instance from an
#'     automatic snapshot. For more information, see the [Amazon Lightsail
#'     Developer
#'     Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instances_from_snapshot
lightsail_create_instances_from_snapshot <- function(instanceNames, attachedDiskMapping = NULL, availabilityZone, instanceSnapshotName = NULL, bundleId, userData = NULL, keyPairName = NULL, tags = NULL, addOns = NULL, ipAddressType = NULL, sourceInstanceName = NULL, restoreDate = NULL, useLatestRestorableAutoSnapshot = NULL) {
  op <- new_operation(
    name = "CreateInstancesFromSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_instances_from_snapshot_input(instanceNames = instanceNames, attachedDiskMapping = attachedDiskMapping, availabilityZone = availabilityZone, instanceSnapshotName = instanceSnapshotName, bundleId = bundleId, userData = userData, keyPairName = keyPairName, tags = tags, addOns = addOns, ipAddressType = ipAddressType, sourceInstanceName = sourceInstanceName, restoreDate = restoreDate, useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot)
  output <- .lightsail$create_instances_from_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instances_from_snapshot <- lightsail_create_instances_from_snapshot

#' Creates a custom SSH key pair that you can use with an Amazon Lightsail
#' instance
#'
#' @description
#' Creates a custom SSH key pair that you can use with an Amazon Lightsail instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_key_pair/](https://www.paws-r-sdk.com/docs/lightsail_create_key_pair/) for full documentation.
#'
#' @param keyPairName &#91;required&#93; The name for your new key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_key_pair
lightsail_create_key_pair <- function(keyPairName, tags = NULL) {
  op <- new_operation(
    name = "CreateKeyPair",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_key_pair_input(keyPairName = keyPairName, tags = tags)
  output <- .lightsail$create_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_key_pair <- lightsail_create_key_pair

#' Creates a Lightsail load balancer
#'
#' @description
#' Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see [Configure your Lightsail instances for load balancing](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/configure-lightsail-instances-for-load-balancing.html). You can create up to 5 load balancers per AWS Region in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_load_balancer/](https://www.paws-r-sdk.com/docs/lightsail_create_load_balancer/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of your load balancer.
#' @param instancePort &#91;required&#93; The instance port where you're creating your load balancer.
#' @param healthCheckPath The path you provided to perform the load balancer health check. If you
#' didn't specify a health check path, Lightsail uses the root path of your
#' website (`"/"`).
#' 
#' You may want to specify a custom health check path other than the root
#' of your application if your home page loads slowly or has a lot of media
#' or scripting on it.
#' @param certificateName The name of the SSL/TLS certificate.
#' 
#' If you specify `certificateName`, then `certificateDomainName` is
#' required (and vice-versa).
#' @param certificateDomainName The domain name with which your certificate is associated
#' (`example.com`).
#' 
#' If you specify `certificateDomainName`, then `certificateName` is
#' required (and vice-versa).
#' @param certificateAlternativeNames The optional alternative domains and subdomains to use with your SSL/TLS
#' certificate (`www.example.com`, `example.com`, `m.example.com`,
#' `blog.example.com`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param ipAddressType The IP address type for the load balancer.
#' 
#' The possible values are `ipv4` for IPv4 only, `ipv6` for IPv6 only, and
#' `dualstack` for IPv4 and IPv6.
#' 
#' The default value is `dualstack`.
#' @param tlsPolicyName The name of the TLS policy to apply to the load balancer.
#' 
#' Use the
#' [`get_load_balancer_tls_policies`][lightsail_get_load_balancer_tls_policies]
#' action to get a list of TLS policy names that you can specify.
#' 
#' For more information about load balancer TLS policies, see [Configuring
#' TLS security policies on your Amazon Lightsail load
#' balancers](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configure-load-balancer-tls-security-policy.html)
#' in the *Amazon Lightsail Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_load_balancer
lightsail_create_load_balancer <- function(loadBalancerName, instancePort, healthCheckPath = NULL, certificateName = NULL, certificateDomainName = NULL, certificateAlternativeNames = NULL, tags = NULL, ipAddressType = NULL, tlsPolicyName = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_load_balancer_input(loadBalancerName = loadBalancerName, instancePort = instancePort, healthCheckPath = healthCheckPath, certificateName = certificateName, certificateDomainName = certificateDomainName, certificateAlternativeNames = certificateAlternativeNames, tags = tags, ipAddressType = ipAddressType, tlsPolicyName = tlsPolicyName)
  output <- .lightsail$create_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_load_balancer <- lightsail_create_load_balancer

#' Creates an SSL/TLS certificate for an Amazon Lightsail load balancer
#'
#' @description
#' Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_load_balancer_tls_certificate/](https://www.paws-r-sdk.com/docs/lightsail_create_load_balancer_tls_certificate/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The load balancer name where you want to create the SSL/TLS certificate.
#' @param certificateName &#91;required&#93; The SSL/TLS certificate name.
#' 
#' You can have up to 10 certificates in your account at one time. Each
#' Lightsail load balancer can have up to 2 certificates associated with it
#' at one time. There is also an overall limit to the number of
#' certificates that can be issue in a 365-day period. For more
#' information, see
#' [Limits](https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
#' @param certificateDomainName &#91;required&#93; The domain name (`example.com`) for your SSL/TLS certificate.
#' @param certificateAlternativeNames An array of strings listing alternative domains and subdomains for your
#' SSL/TLS certificate. Lightsail will de-dupe the names for you. You can
#' have a maximum of 9 alternative names (in addition to the 1 primary
#' domain). We do not support wildcards (`*.example.com`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_load_balancer_tls_certificate
lightsail_create_load_balancer_tls_certificate <- function(loadBalancerName, certificateName, certificateDomainName, certificateAlternativeNames = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName, certificateDomainName = certificateDomainName, certificateAlternativeNames = certificateAlternativeNames, tags = tags)
  output <- .lightsail$create_load_balancer_tls_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_load_balancer_tls_certificate <- lightsail_create_load_balancer_tls_certificate

#' Creates a new database in Amazon Lightsail
#'
#' @description
#' Creates a new database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_relational_database/](https://www.paws-r-sdk.com/docs/lightsail_create_relational_database/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name to use for your new Lightsail database resource.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param availabilityZone The Availability Zone in which to create your new database. Use the
#' `us-east-2a` case-sensitive format.
#' 
#' You can get a list of Availability Zones by using the `get regions`
#' operation. Be sure to add the
#' `include relational database Availability Zones` parameter to your
#' request.
#' @param relationalDatabaseBlueprintId &#91;required&#93; The blueprint ID for your new database. A blueprint describes the major
#' engine version of a database.
#' 
#' You can get a list of database blueprints IDs by using the
#' `get relational database blueprints` operation.
#' @param relationalDatabaseBundleId &#91;required&#93; The bundle ID for your new database. A bundle describes the performance
#' specifications for your database.
#' 
#' You can get a list of database bundle IDs by using the
#' `get relational database bundles` operation.
#' @param masterDatabaseName &#91;required&#93; The meaning of this parameter differs according to the database engine
#' you use.
#' 
#' **MySQL**
#' 
#' The name of the database to create when the Lightsail database resource
#' is created. If this parameter isn't specified, no database is created in
#' the database resource.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 64 letters or numbers.
#' 
#' -   Must begin with a letter. Subsequent characters can be letters,
#'     underscores, or digits (0- 9).
#' 
#' -   Can't be a word reserved by the specified database engine.
#' 
#'     For more information about reserved words in MySQL, see the Keywords
#'     and Reserved Words articles for [MySQL
#'     5.6](https://dev.mysql.com/doc/refman/8.4/en/keywords.html), [MySQL
#'     5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html), and
#'     [MySQL 8.0](https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
#' 
#' **PostgreSQL**
#' 
#' The name of the database to create when the Lightsail database resource
#' is created. If this parameter isn't specified, a database named
#' `postgres` is created in the database resource.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 63 letters or numbers.
#' 
#' -   Must begin with a letter. Subsequent characters can be letters,
#'     underscores, or digits (0- 9).
#' 
#' -   Can't be a word reserved by the specified database engine.
#' 
#'     For more information about reserved words in PostgreSQL, see the SQL
#'     Key Words articles for [PostgreSQL
#'     9.6](https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html),
#'     [PostgreSQL
#'     10](https://www.postgresql.org/docs/10/sql-keywords-appendix.html),
#'     [PostgreSQL
#'     11](https://www.postgresql.org/docs/11/sql-keywords-appendix.html),
#'     and [PostgreSQL
#'     12](https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
#' @param masterUsername &#91;required&#93; The name for the master user.
#' 
#' **MySQL**
#' 
#' Constraints:
#' 
#' -   Required for MySQL.
#' 
#' -   Must be 1 to 16 letters or numbers. Can contain underscores.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't be a reserved word for the chosen database engine.
#' 
#'     For more information about reserved words in MySQL 5.6 or 5.7, see
#'     the Keywords and Reserved Words articles for [MySQL
#'     5.6](https://dev.mysql.com/doc/refman/8.4/en/keywords.html), [MySQL
#'     5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html), or
#'     [MySQL 8.0](https://dev.mysql.com/doc/refman/8.0/en/keywords.html).
#' 
#' **PostgreSQL**
#' 
#' Constraints:
#' 
#' -   Required for PostgreSQL.
#' 
#' -   Must be 1 to 63 letters or numbers. Can contain underscores.
#' 
#' -   First character must be a letter.
#' 
#' -   Can't be a reserved word for the chosen database engine.
#' 
#'     For more information about reserved words in MySQL 5.6 or 5.7, see
#'     the Keywords and Reserved Words articles for [PostgreSQL
#'     9.6](https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html),
#'     [PostgreSQL
#'     10](https://www.postgresql.org/docs/10/sql-keywords-appendix.html),
#'     [PostgreSQL
#'     11](https://www.postgresql.org/docs/11/sql-keywords-appendix.html),
#'     and [PostgreSQL
#'     12](https://www.postgresql.org/docs/12/sql-keywords-appendix.html).
#' @param masterUserPassword The password for the master user. The password can include any printable
#' ASCII character except "/", """, or "@@". It cannot contain spaces.
#' 
#' **MySQL**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **PostgreSQL**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' @param preferredBackupWindow The daily time range during which automated backups are created for your
#' new database if automated backups are enabled.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. For more information about the
#' preferred backup window time blocks for each region, see the [Working
#' With
#' Backups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' guide in the Amazon Relational Database Service documentation.
#' 
#' Constraints:
#' 
#' -   Must be in the `hh24:mi-hh24:mi` format.
#' 
#'     Example: `16:00-16:30`
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your
#' new database.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Constraints:
#' 
#' -   Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
#' 
#' -   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be at least 30 minutes.
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Example: `Tue:17:00-Tue:17:30`
#' @param publiclyAccessible Specifies the accessibility options for your new database. A value of
#' `true` specifies a database that is available to resources outside of
#' your Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database
lightsail_create_relational_database <- function(relationalDatabaseName, availabilityZone = NULL, relationalDatabaseBlueprintId, relationalDatabaseBundleId, masterDatabaseName, masterUsername, masterUserPassword = NULL, preferredBackupWindow = NULL, preferredMaintenanceWindow = NULL, publiclyAccessible = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_relational_database_input(relationalDatabaseName = relationalDatabaseName, availabilityZone = availabilityZone, relationalDatabaseBlueprintId = relationalDatabaseBlueprintId, relationalDatabaseBundleId = relationalDatabaseBundleId, masterDatabaseName = masterDatabaseName, masterUsername = masterUsername, masterUserPassword = masterUserPassword, preferredBackupWindow = preferredBackupWindow, preferredMaintenanceWindow = preferredMaintenanceWindow, publiclyAccessible = publiclyAccessible, tags = tags)
  output <- .lightsail$create_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database <- lightsail_create_relational_database

#' Creates a new database from an existing database snapshot in Amazon
#' Lightsail
#'
#' @description
#' Creates a new database from an existing database snapshot in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_relational_database_from_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_create_relational_database_from_snapshot/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name to use for your new Lightsail database resource.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param availabilityZone The Availability Zone in which to create your new database. Use the
#' `us-east-2a` case-sensitive format.
#' 
#' You can get a list of Availability Zones by using the `get regions`
#' operation. Be sure to add the
#' `include relational database Availability Zones` parameter to your
#' request.
#' @param publiclyAccessible Specifies the accessibility options for your new database. A value of
#' `true` specifies a database that is available to resources outside of
#' your Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param relationalDatabaseSnapshotName The name of the database snapshot from which to create your new
#' database.
#' @param relationalDatabaseBundleId The bundle ID for your new database. A bundle describes the performance
#' specifications for your database.
#' 
#' You can get a list of database bundle IDs by using the
#' `get relational database bundles` operation.
#' 
#' When creating a new database from a snapshot, you cannot choose a bundle
#' that is smaller than the bundle of the source database.
#' @param sourceRelationalDatabaseName The name of the source database.
#' @param restoreTime The date and time to restore your database from.
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the database.
#' 
#' -   Cannot be specified if the `use latest restorable time` parameter is
#'     `true`.
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a restore time of October 1, 2018,
#'     at 8 PM UTC, then you input `1538424000` as the restore time.
#' @param useLatestRestorableTime Specifies whether your database is restored from the latest backup time.
#' A value of `true` restores from the latest backup time.
#' 
#' Default: `false`
#' 
#' Constraints: Cannot be specified if the `restore time` parameter is
#' provided.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database_from_snapshot
lightsail_create_relational_database_from_snapshot <- function(relationalDatabaseName, availabilityZone = NULL, publiclyAccessible = NULL, relationalDatabaseSnapshotName = NULL, relationalDatabaseBundleId = NULL, sourceRelationalDatabaseName = NULL, restoreTime = NULL, useLatestRestorableTime = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabaseFromSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_relational_database_from_snapshot_input(relationalDatabaseName = relationalDatabaseName, availabilityZone = availabilityZone, publiclyAccessible = publiclyAccessible, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName, relationalDatabaseBundleId = relationalDatabaseBundleId, sourceRelationalDatabaseName = sourceRelationalDatabaseName, restoreTime = restoreTime, useLatestRestorableTime = useLatestRestorableTime, tags = tags)
  output <- .lightsail$create_relational_database_from_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database_from_snapshot <- lightsail_create_relational_database_from_snapshot

#' Creates a snapshot of your database in Amazon Lightsail
#'
#' @description
#' Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a database, and to save data before deleting a database.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_create_relational_database_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_create_relational_database_snapshot/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database on which to base your new snapshot.
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name for your new database snapshot.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database_snapshot
lightsail_create_relational_database_snapshot <- function(relationalDatabaseName, relationalDatabaseSnapshotName, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$create_relational_database_snapshot_input(relationalDatabaseName = relationalDatabaseName, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName, tags = tags)
  output <- .lightsail$create_relational_database_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database_snapshot <- lightsail_create_relational_database_snapshot

#' Deletes an alarm
#'
#' @description
#' Deletes an alarm.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_alarm/](https://www.paws-r-sdk.com/docs/lightsail_delete_alarm/) for full documentation.
#'
#' @param alarmName &#91;required&#93; The name of the alarm to delete.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_alarm
lightsail_delete_alarm <- function(alarmName) {
  op <- new_operation(
    name = "DeleteAlarm",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_alarm_input(alarmName = alarmName)
  output <- .lightsail$delete_alarm_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_alarm <- lightsail_delete_alarm

#' Deletes an automatic snapshot of an instance or disk
#'
#' @description
#' Deletes an automatic snapshot of an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_auto_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_delete_auto_snapshot/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the source instance or disk from which to delete the
#' automatic snapshot.
#' @param date &#91;required&#93; The date of the automatic snapshot to delete in `YYYY-MM-DD` format. Use
#' the `get auto snapshots` operation to get the available automatic
#' snapshots for a resource.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_auto_snapshot
lightsail_delete_auto_snapshot <- function(resourceName, date) {
  op <- new_operation(
    name = "DeleteAutoSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_auto_snapshot_input(resourceName = resourceName, date = date)
  output <- .lightsail$delete_auto_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_auto_snapshot <- lightsail_delete_auto_snapshot

#' Deletes a Amazon Lightsail bucket
#'
#' @description
#' Deletes a Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_bucket/](https://www.paws-r-sdk.com/docs/lightsail_delete_bucket/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name of the bucket to delete.
#' 
#' Use the [`get_buckets`][lightsail_get_buckets] action to get a list of
#' bucket names that you can specify.
#' @param forceDelete A Boolean value that indicates whether to force delete the bucket.
#' 
#' You must force delete the bucket if it has one of the following
#' conditions:
#' 
#' -   The bucket is the origin of a distribution.
#' 
#' -   The bucket has instances that were granted access to it using the
#'     [`set_resource_access_for_bucket`][lightsail_set_resource_access_for_bucket]
#'     action.
#' 
#' -   The bucket has objects.
#' 
#' -   The bucket has access keys.
#' 
#' Force deleting a bucket might impact other resources that rely on the
#' bucket, such as instances, distributions, or software that use the
#' issued access keys.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_bucket
lightsail_delete_bucket <- function(bucketName, forceDelete = NULL) {
  op <- new_operation(
    name = "DeleteBucket",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_bucket_input(bucketName = bucketName, forceDelete = forceDelete)
  output <- .lightsail$delete_bucket_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_bucket <- lightsail_delete_bucket

#' Deletes an access key for the specified Amazon Lightsail bucket
#'
#' @description
#' Deletes an access key for the specified Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_bucket_access_key/](https://www.paws-r-sdk.com/docs/lightsail_delete_bucket_access_key/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name of the bucket that the access key belongs to.
#' @param accessKeyId &#91;required&#93; The ID of the access key to delete.
#' 
#' Use the [`get_bucket_access_keys`][lightsail_get_bucket_access_keys]
#' action to get a list of access key IDs that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_bucket_access_key
lightsail_delete_bucket_access_key <- function(bucketName, accessKeyId) {
  op <- new_operation(
    name = "DeleteBucketAccessKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_bucket_access_key_input(bucketName = bucketName, accessKeyId = accessKeyId)
  output <- .lightsail$delete_bucket_access_key_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_bucket_access_key <- lightsail_delete_bucket_access_key

#' Deletes an SSL/TLS certificate for your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_certificate/](https://www.paws-r-sdk.com/docs/lightsail_delete_certificate/) for full documentation.
#'
#' @param certificateName &#91;required&#93; The name of the certificate to delete.
#' 
#' Use the [`get_certificates`][lightsail_get_certificates] action to get a
#' list of certificate names that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_certificate
lightsail_delete_certificate <- function(certificateName) {
  op <- new_operation(
    name = "DeleteCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_certificate_input(certificateName = certificateName)
  output <- .lightsail$delete_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_certificate <- lightsail_delete_certificate

#' Deletes a contact method
#'
#' @description
#' Deletes a contact method.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_contact_method/](https://www.paws-r-sdk.com/docs/lightsail_delete_contact_method/) for full documentation.
#'
#' @param protocol &#91;required&#93; The protocol that will be deleted, such as `Email` or `SMS` (text
#' messaging).
#' 
#' To delete an `Email` and an `SMS` contact method if you added both, you
#' must run separate
#' [`delete_contact_method`][lightsail_delete_contact_method] actions to
#' delete each protocol.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_contact_method
lightsail_delete_contact_method <- function(protocol) {
  op <- new_operation(
    name = "DeleteContactMethod",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_contact_method_input(protocol = protocol)
  output <- .lightsail$delete_contact_method_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_contact_method <- lightsail_delete_contact_method

#' Deletes a container image that is registered to your Amazon Lightsail
#' container service
#'
#' @description
#' Deletes a container image that is registered to your Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_container_image/](https://www.paws-r-sdk.com/docs/lightsail_delete_container_image/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to delete a registered
#' container image.
#' @param image &#91;required&#93; The name of the container image to delete from the container service.
#' 
#' Use the [`get_container_images`][lightsail_get_container_images] action
#' to get the name of the container images that are registered to a
#' container service.
#' 
#' Container images sourced from your Lightsail container service, that are
#' registered and stored on your service, start with a colon (`:`). For
#' example, `:container-service-1.mystaticwebsite.1`. Container images
#' sourced from a public registry like Docker Hub don't start with a colon.
#' For example, `nginx:latest` or `nginx`.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_container_image
lightsail_delete_container_image <- function(serviceName, image) {
  op <- new_operation(
    name = "DeleteContainerImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_container_image_input(serviceName = serviceName, image = image)
  output <- .lightsail$delete_container_image_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_container_image <- lightsail_delete_container_image

#' Deletes your Amazon Lightsail container service
#'
#' @description
#' Deletes your Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_container_service/](https://www.paws-r-sdk.com/docs/lightsail_delete_container_service/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service to delete.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_container_service
lightsail_delete_container_service <- function(serviceName) {
  op <- new_operation(
    name = "DeleteContainerService",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_container_service_input(serviceName = serviceName)
  output <- .lightsail$delete_container_service_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_container_service <- lightsail_delete_container_service

#' Deletes the specified block storage disk
#'
#' @description
#' Deletes the specified block storage disk. The disk must be in the `available` state (not attached to a Lightsail instance).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_disk/](https://www.paws-r-sdk.com/docs/lightsail_delete_disk/) for full documentation.
#'
#' @param diskName &#91;required&#93; The unique name of the disk you want to delete (`my-disk`).
#' @param forceDeleteAddOns A Boolean value to indicate whether to delete all add-ons for the disk.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_disk
lightsail_delete_disk <- function(diskName, forceDeleteAddOns = NULL) {
  op <- new_operation(
    name = "DeleteDisk",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_disk_input(diskName = diskName, forceDeleteAddOns = forceDeleteAddOns)
  output <- .lightsail$delete_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_disk <- lightsail_delete_disk

#' Deletes the specified disk snapshot
#'
#' @description
#' Deletes the specified disk snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_disk_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_delete_disk_snapshot/) for full documentation.
#'
#' @param diskSnapshotName &#91;required&#93; The name of the disk snapshot you want to delete (`my-disk-snapshot`).
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_disk_snapshot
lightsail_delete_disk_snapshot <- function(diskSnapshotName) {
  op <- new_operation(
    name = "DeleteDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_disk_snapshot_input(diskSnapshotName = diskSnapshotName)
  output <- .lightsail$delete_disk_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_disk_snapshot <- lightsail_delete_disk_snapshot

#' Deletes your Amazon Lightsail content delivery network (CDN)
#' distribution
#'
#' @description
#' Deletes your Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_distribution/](https://www.paws-r-sdk.com/docs/lightsail_delete_distribution/) for full documentation.
#'
#' @param distributionName The name of the distribution to delete.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_distribution
lightsail_delete_distribution <- function(distributionName = NULL) {
  op <- new_operation(
    name = "DeleteDistribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_distribution_input(distributionName = distributionName)
  output <- .lightsail$delete_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_distribution <- lightsail_delete_distribution

#' Deletes the specified domain recordset and all of its domain records
#'
#' @description
#' Deletes the specified domain recordset and all of its domain records.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_domain/](https://www.paws-r-sdk.com/docs/lightsail_delete_domain/) for full documentation.
#'
#' @param domainName &#91;required&#93; The specific domain name to delete.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_domain
lightsail_delete_domain <- function(domainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_domain_input(domainName = domainName)
  output <- .lightsail$delete_domain_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_domain <- lightsail_delete_domain

#' Deletes a specific domain entry
#'
#' @description
#' Deletes a specific domain entry.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_domain_entry/](https://www.paws-r-sdk.com/docs/lightsail_delete_domain_entry/) for full documentation.
#'
#' @param domainName &#91;required&#93; The name of the domain entry to delete.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about your domain
#' entries.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_domain_entry
lightsail_delete_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "DeleteDomainEntry",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$delete_domain_entry_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_domain_entry <- lightsail_delete_domain_entry

#' Deletes an Amazon Lightsail instance
#'
#' @description
#' Deletes an Amazon Lightsail instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_instance/](https://www.paws-r-sdk.com/docs/lightsail_delete_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance to delete.
#' @param forceDeleteAddOns A Boolean value to indicate whether to delete all add-ons for the
#' instance.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_instance
lightsail_delete_instance <- function(instanceName, forceDeleteAddOns = NULL) {
  op <- new_operation(
    name = "DeleteInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_instance_input(instanceName = instanceName, forceDeleteAddOns = forceDeleteAddOns)
  output <- .lightsail$delete_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_instance <- lightsail_delete_instance

#' Deletes a specific snapshot of a virtual private server (or instance)
#'
#' @description
#' Deletes a specific snapshot of a virtual private server (or *instance*).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_instance_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_delete_instance_snapshot/) for full documentation.
#'
#' @param instanceSnapshotName &#91;required&#93; The name of the snapshot to delete.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_instance_snapshot
lightsail_delete_instance_snapshot <- function(instanceSnapshotName) {
  op <- new_operation(
    name = "DeleteInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName)
  output <- .lightsail$delete_instance_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_instance_snapshot <- lightsail_delete_instance_snapshot

#' Deletes the specified key pair by removing the public key from Amazon
#' Lightsail
#'
#' @description
#' Deletes the specified key pair by removing the public key from Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_key_pair/](https://www.paws-r-sdk.com/docs/lightsail_delete_key_pair/) for full documentation.
#'
#' @param keyPairName &#91;required&#93; The name of the key pair to delete.
#' @param expectedFingerprint The RSA fingerprint of the Lightsail default key pair to delete.
#' 
#' The `expectedFingerprint` parameter is required only when specifying to
#' delete a Lightsail default key pair.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_key_pair
lightsail_delete_key_pair <- function(keyPairName, expectedFingerprint = NULL) {
  op <- new_operation(
    name = "DeleteKeyPair",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_key_pair_input(keyPairName = keyPairName, expectedFingerprint = expectedFingerprint)
  output <- .lightsail$delete_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_key_pair <- lightsail_delete_key_pair

#' Deletes the known host key or certificate used by the Amazon Lightsail
#' browser-based SSH or RDP clients to authenticate an instance
#'
#' @description
#' Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the instance after a host key mismatch.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_known_host_keys/](https://www.paws-r-sdk.com/docs/lightsail_delete_known_host_keys/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance for which you want to reset the host key or
#' certificate.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_known_host_keys
lightsail_delete_known_host_keys <- function(instanceName) {
  op <- new_operation(
    name = "DeleteKnownHostKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_known_host_keys_input(instanceName = instanceName)
  output <- .lightsail$delete_known_host_keys_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_known_host_keys <- lightsail_delete_known_host_keys

#' Deletes a Lightsail load balancer and all its associated SSL/TLS
#' certificates
#'
#' @description
#' Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted, you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_load_balancer/](https://www.paws-r-sdk.com/docs/lightsail_delete_load_balancer/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer you want to delete.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_load_balancer
lightsail_delete_load_balancer <- function(loadBalancerName) {
  op <- new_operation(
    name = "DeleteLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_load_balancer_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$delete_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_load_balancer <- lightsail_delete_load_balancer

#' Deletes an SSL/TLS certificate associated with a Lightsail load balancer
#'
#' @description
#' Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_load_balancer_tls_certificate/](https://www.paws-r-sdk.com/docs/lightsail_delete_load_balancer_tls_certificate/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The load balancer name.
#' @param certificateName &#91;required&#93; The SSL/TLS certificate name.
#' @param force When `true`, forces the deletion of an SSL/TLS certificate.
#' 
#' There can be two certificates associated with a Lightsail load balancer:
#' the primary and the backup. The `force` parameter is required when the
#' primary SSL/TLS certificate is in use by an instance attached to the
#' load balancer.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_load_balancer_tls_certificate
lightsail_delete_load_balancer_tls_certificate <- function(loadBalancerName, certificateName, force = NULL) {
  op <- new_operation(
    name = "DeleteLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName, force = force)
  output <- .lightsail$delete_load_balancer_tls_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_load_balancer_tls_certificate <- lightsail_delete_load_balancer_tls_certificate

#' Deletes a database in Amazon Lightsail
#'
#' @description
#' Deletes a database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_relational_database/](https://www.paws-r-sdk.com/docs/lightsail_delete_relational_database/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database that you are deleting.
#' @param skipFinalSnapshot Determines whether a final database snapshot is created before your
#' database is deleted. If `true` is specified, no database snapshot is
#' created. If `false` is specified, a database snapshot is created before
#' your database is deleted.
#' 
#' You must specify the `final relational database snapshot name` parameter
#' if the `skip final snapshot` parameter is `false`.
#' 
#' Default: `false`
#' @param finalRelationalDatabaseSnapshotName The name of the database snapshot created if `skip final snapshot` is
#' `false`, which is the default value for that parameter.
#' 
#' Specifying this parameter and also specifying the `skip final snapshot`
#' parameter to `true` results in an error.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_relational_database
lightsail_delete_relational_database <- function(relationalDatabaseName, skipFinalSnapshot = NULL, finalRelationalDatabaseSnapshotName = NULL) {
  op <- new_operation(
    name = "DeleteRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_relational_database_input(relationalDatabaseName = relationalDatabaseName, skipFinalSnapshot = skipFinalSnapshot, finalRelationalDatabaseSnapshotName = finalRelationalDatabaseSnapshotName)
  output <- .lightsail$delete_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_relational_database <- lightsail_delete_relational_database

#' Deletes a database snapshot in Amazon Lightsail
#'
#' @description
#' Deletes a database snapshot in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_delete_relational_database_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_delete_relational_database_snapshot/) for full documentation.
#'
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name of the database snapshot that you are deleting.
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_relational_database_snapshot
lightsail_delete_relational_database_snapshot <- function(relationalDatabaseSnapshotName) {
  op <- new_operation(
    name = "DeleteRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$delete_relational_database_snapshot_input(relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$delete_relational_database_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_relational_database_snapshot <- lightsail_delete_relational_database_snapshot

#' Detaches an SSL/TLS certificate from your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_detach_certificate_from_distribution/](https://www.paws-r-sdk.com/docs/lightsail_detach_certificate_from_distribution/) for full documentation.
#'
#' @param distributionName &#91;required&#93; The name of the distribution from which to detach the certificate.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_certificate_from_distribution
lightsail_detach_certificate_from_distribution <- function(distributionName) {
  op <- new_operation(
    name = "DetachCertificateFromDistribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$detach_certificate_from_distribution_input(distributionName = distributionName)
  output <- .lightsail$detach_certificate_from_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_certificate_from_distribution <- lightsail_detach_certificate_from_distribution

#' Detaches a stopped block storage disk from a Lightsail instance
#'
#' @description
#' Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the device within your operating system before stopping the instance and detaching the disk.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_detach_disk/](https://www.paws-r-sdk.com/docs/lightsail_detach_disk/) for full documentation.
#'
#' @param diskName &#91;required&#93; The unique name of the disk you want to detach from your instance
#' (`my-disk`).
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_disk
lightsail_detach_disk <- function(diskName) {
  op <- new_operation(
    name = "DetachDisk",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$detach_disk_input(diskName = diskName)
  output <- .lightsail$detach_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_disk <- lightsail_detach_disk

#' Detaches the specified instances from a Lightsail load balancer
#'
#' @description
#' Detaches the specified instances from a Lightsail load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_detach_instances_from_load_balancer/](https://www.paws-r-sdk.com/docs/lightsail_detach_instances_from_load_balancer/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the Lightsail load balancer.
#' @param instanceNames &#91;required&#93; An array of strings containing the names of the instances you want to
#' detach from the load balancer.
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_instances_from_load_balancer
lightsail_detach_instances_from_load_balancer <- function(loadBalancerName, instanceNames) {
  op <- new_operation(
    name = "DetachInstancesFromLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$detach_instances_from_load_balancer_input(loadBalancerName = loadBalancerName, instanceNames = instanceNames)
  output <- .lightsail$detach_instances_from_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_instances_from_load_balancer <- lightsail_detach_instances_from_load_balancer

#' Detaches a static IP from the Amazon Lightsail instance to which it is
#' attached
#'
#' @description
#' Detaches a static IP from the Amazon Lightsail instance to which it is attached.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_detach_static_ip/](https://www.paws-r-sdk.com/docs/lightsail_detach_static_ip/) for full documentation.
#'
#' @param staticIpName &#91;required&#93; The name of the static IP to detach from the instance.
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_static_ip
lightsail_detach_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "DetachStaticIp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$detach_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$detach_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_static_ip <- lightsail_detach_static_ip

#' Disables an add-on for an Amazon Lightsail resource
#'
#' @description
#' Disables an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_disable_add_on/](https://www.paws-r-sdk.com/docs/lightsail_disable_add_on/) for full documentation.
#'
#' @param addOnType &#91;required&#93; The add-on type to disable.
#' @param resourceName &#91;required&#93; The name of the source resource for which to disable the add-on.
#'
#' @keywords internal
#'
#' @rdname lightsail_disable_add_on
lightsail_disable_add_on <- function(addOnType, resourceName) {
  op <- new_operation(
    name = "DisableAddOn",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$disable_add_on_input(addOnType = addOnType, resourceName = resourceName)
  output <- .lightsail$disable_add_on_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$disable_add_on <- lightsail_disable_add_on

#' Downloads the regional Amazon Lightsail default key pair
#'
#' @description
#' Downloads the regional Amazon Lightsail default key pair.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_download_default_key_pair/](https://www.paws-r-sdk.com/docs/lightsail_download_default_key_pair/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_download_default_key_pair
lightsail_download_default_key_pair <- function() {
  op <- new_operation(
    name = "DownloadDefaultKeyPair",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$download_default_key_pair_input()
  output <- .lightsail$download_default_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$download_default_key_pair <- lightsail_download_default_key_pair

#' Enables or modifies an add-on for an Amazon Lightsail resource
#'
#' @description
#' Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the [Amazon Lightsail Developer Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_enable_add_on/](https://www.paws-r-sdk.com/docs/lightsail_enable_add_on/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the source resource for which to enable or modify the
#' add-on.
#' @param addOnRequest &#91;required&#93; An array of strings representing the add-on to enable or modify.
#'
#' @keywords internal
#'
#' @rdname lightsail_enable_add_on
lightsail_enable_add_on <- function(resourceName, addOnRequest) {
  op <- new_operation(
    name = "EnableAddOn",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$enable_add_on_input(resourceName = resourceName, addOnRequest = addOnRequest)
  output <- .lightsail$enable_add_on_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$enable_add_on <- lightsail_enable_add_on

#' Exports an Amazon Lightsail instance or block storage disk snapshot to
#' Amazon Elastic Compute Cloud (Amazon EC2)
#'
#' @description
#' Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an export snapshot record that can be used with the `create cloud formation stack` operation to create new Amazon EC2 instances.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_export_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_export_snapshot/) for full documentation.
#'
#' @param sourceSnapshotName &#91;required&#93; The name of the instance or disk snapshot to be exported to Amazon EC2.
#'
#' @keywords internal
#'
#' @rdname lightsail_export_snapshot
lightsail_export_snapshot <- function(sourceSnapshotName) {
  op <- new_operation(
    name = "ExportSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$export_snapshot_input(sourceSnapshotName = sourceSnapshotName)
  output <- .lightsail$export_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$export_snapshot <- lightsail_export_snapshot

#' Returns the names of all active (not deleted) resources
#'
#' @description
#' Returns the names of all active (not deleted) resources.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_active_names/](https://www.paws-r-sdk.com/docs/lightsail_get_active_names/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_active_names`][lightsail_get_active_names] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_active_names
lightsail_get_active_names <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetActiveNames",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "activeNames"),
    stream_api = FALSE
  )
  input <- .lightsail$get_active_names_input(pageToken = pageToken)
  output <- .lightsail$get_active_names_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_active_names <- lightsail_get_active_names

#' Returns information about the configured alarms
#'
#' @description
#' Returns information about the configured alarms. Specify an alarm name in your request to return information about a specific alarm, or specify a monitored resource name to return information about all alarms for a specific resource.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_alarms/](https://www.paws-r-sdk.com/docs/lightsail_get_alarms/) for full documentation.
#'
#' @param alarmName The name of the alarm.
#' 
#' Specify an alarm name to return information about a specific alarm.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_alarms`][lightsail_get_alarms] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#' @param monitoredResourceName The name of the Lightsail resource being monitored by the alarm.
#' 
#' Specify a monitored resource name to return information about all alarms
#' for a specific resource.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_alarms
lightsail_get_alarms <- function(alarmName = NULL, pageToken = NULL, monitoredResourceName = NULL) {
  op <- new_operation(
    name = "GetAlarms",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_alarms_input(alarmName = alarmName, pageToken = pageToken, monitoredResourceName = monitoredResourceName)
  output <- .lightsail$get_alarms_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_alarms <- lightsail_get_alarms

#' Returns the available automatic snapshots for an instance or disk
#'
#' @description
#' Returns the available automatic snapshots for an instance or disk. For more information, see the [Amazon Lightsail Developer Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-automatic-snapshots.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_auto_snapshots/](https://www.paws-r-sdk.com/docs/lightsail_get_auto_snapshots/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the source instance or disk from which to get automatic
#' snapshot information.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_auto_snapshots
lightsail_get_auto_snapshots <- function(resourceName) {
  op <- new_operation(
    name = "GetAutoSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_auto_snapshots_input(resourceName = resourceName)
  output <- .lightsail$get_auto_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_auto_snapshots <- lightsail_get_auto_snapshots

#' Returns the list of available instance images, or blueprints
#'
#' @description
#' Returns the list of available instance images, or *blueprints*. You can use a blueprint to create a new instance already running a specific operating system, as well as a preinstalled app or development stack. The software each instance is running depends on the blueprint image you choose.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_blueprints/](https://www.paws-r-sdk.com/docs/lightsail_get_blueprints/) for full documentation.
#'
#' @param includeInactive A Boolean value that indicates whether to include inactive (unavailable)
#' blueprints in the response of your request.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_blueprints`][lightsail_get_blueprints] request. If your results
#' are paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#' @param appCategory Returns a list of blueprints that are specific to Lightsail for
#' Research.
#' 
#' You must use this parameter to view Lightsail for Research blueprints.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_blueprints
lightsail_get_blueprints <- function(includeInactive = NULL, pageToken = NULL, appCategory = NULL) {
  op <- new_operation(
    name = "GetBlueprints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "blueprints"),
    stream_api = FALSE
  )
  input <- .lightsail$get_blueprints_input(includeInactive = includeInactive, pageToken = pageToken, appCategory = appCategory)
  output <- .lightsail$get_blueprints_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_blueprints <- lightsail_get_blueprints

#' Returns the existing access key IDs for the specified Amazon Lightsail
#' bucket
#'
#' @description
#' Returns the existing access key IDs for the specified Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_bucket_access_keys/](https://www.paws-r-sdk.com/docs/lightsail_get_bucket_access_keys/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name of the bucket for which to return access keys.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_bucket_access_keys
lightsail_get_bucket_access_keys <- function(bucketName) {
  op <- new_operation(
    name = "GetBucketAccessKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_bucket_access_keys_input(bucketName = bucketName)
  output <- .lightsail$get_bucket_access_keys_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_bucket_access_keys <- lightsail_get_bucket_access_keys

#' Returns the bundles that you can apply to a Amazon Lightsail bucket
#'
#' @description
#' Returns the bundles that you can apply to a Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_bucket_bundles/](https://www.paws-r-sdk.com/docs/lightsail_get_bucket_bundles/) for full documentation.
#'
#' @param includeInactive A Boolean value that indicates whether to include inactive (unavailable)
#' bundles in the response of your request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_bucket_bundles
lightsail_get_bucket_bundles <- function(includeInactive = NULL) {
  op <- new_operation(
    name = "GetBucketBundles",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_bucket_bundles_input(includeInactive = includeInactive)
  output <- .lightsail$get_bucket_bundles_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_bucket_bundles <- lightsail_get_bucket_bundles

#' Returns the data points of a specific metric for an Amazon Lightsail
#' bucket
#'
#' @description
#' Returns the data points of a specific metric for an Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_bucket_metric_data/](https://www.paws-r-sdk.com/docs/lightsail_get_bucket_metric_data/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name of the bucket for which to get metric data.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid bucket metric names are listed below, along with the most useful
#' statistics to include in your request, and the published unit value.
#' 
#' These bucket metrics are reported once per day.
#' 
#' -   **`BucketSizeBytes`** - The amount of data in bytes stored in a
#'     bucket. This value is calculated by summing the size of all objects
#'     in the bucket (including object versions), including the size of all
#'     parts for all incomplete multipart uploads to the bucket.
#' 
#'     Statistics: The most useful statistic is `Maximum`.
#' 
#'     Unit: The published unit is `Bytes`.
#' 
#' -   **`NumberOfObjects`** - The total number of objects stored in a
#'     bucket. This value is calculated by counting all objects in the
#'     bucket (including object versions) and the total number of parts for
#'     all incomplete multipart uploads to the bucket.
#' 
#'     Statistics: The most useful statistic is `Average`.
#' 
#'     Unit: The published unit is `Count`.
#' @param startTime &#91;required&#93; The timestamp indicating the earliest data to be returned.
#' @param endTime &#91;required&#93; The timestamp indicating the latest data to be returned.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' 
#' Bucket storage metrics are reported once per day. Therefore, you should
#' specify a period of 86400 seconds, which is the number of seconds in a
#' day.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - The sum of all values submitted for the matching metric. You
#'     can use this statistic to determine the total volume of a metric.
#' 
#' -   `Average` - The value of `Sum` / `SampleCount` during the specified
#'     period. By comparing this statistic with the `Minimum` and `Maximum`
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the `Minimum` and `Maximum` values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#' @param unit &#91;required&#93; The unit for the metric data request.
#' 
#' Valid units depend on the metric data being requested. For the valid
#' units with each available metric, see the `metricName` parameter.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_bucket_metric_data
lightsail_get_bucket_metric_data <- function(bucketName, metricName, startTime, endTime, period, statistics, unit) {
  op <- new_operation(
    name = "GetBucketMetricData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_bucket_metric_data_input(bucketName = bucketName, metricName = metricName, startTime = startTime, endTime = endTime, period = period, statistics = statistics, unit = unit)
  output <- .lightsail$get_bucket_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_bucket_metric_data <- lightsail_get_bucket_metric_data

#' Returns information about one or more Amazon Lightsail buckets
#'
#' @description
#' Returns information about one or more Amazon Lightsail buckets. The information returned includes the synchronization status of the Amazon Simple Storage Service (Amazon S3) account-level block public access feature for your Lightsail buckets.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_buckets/](https://www.paws-r-sdk.com/docs/lightsail_get_buckets/) for full documentation.
#'
#' @param bucketName The name of the bucket for which to return information.
#' 
#' When omitted, the response includes all of your buckets in the Amazon
#' Web Services Region where the request is made.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_buckets`][lightsail_get_buckets] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#' @param includeConnectedResources A Boolean value that indicates whether to include Lightsail instances
#' that were given access to the bucket using the
#' [`set_resource_access_for_bucket`][lightsail_set_resource_access_for_bucket]
#' action.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_buckets
lightsail_get_buckets <- function(bucketName = NULL, pageToken = NULL, includeConnectedResources = NULL) {
  op <- new_operation(
    name = "GetBuckets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_buckets_input(bucketName = bucketName, pageToken = pageToken, includeConnectedResources = includeConnectedResources)
  output <- .lightsail$get_buckets_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_buckets <- lightsail_get_buckets

#' Returns the bundles that you can apply to an Amazon Lightsail instance
#' when you create it
#'
#' @description
#' Returns the bundles that you can apply to an Amazon Lightsail instance when you create it.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_bundles/](https://www.paws-r-sdk.com/docs/lightsail_get_bundles/) for full documentation.
#'
#' @param includeInactive A Boolean value that indicates whether to include inactive (unavailable)
#' bundles in the response of your request.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_bundles`][lightsail_get_bundles] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#' @param appCategory Returns a list of bundles that are specific to Lightsail for Research.
#' 
#' You must use this parameter to view Lightsail for Research bundles.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_bundles
lightsail_get_bundles <- function(includeInactive = NULL, pageToken = NULL, appCategory = NULL) {
  op <- new_operation(
    name = "GetBundles",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "bundles"),
    stream_api = FALSE
  )
  input <- .lightsail$get_bundles_input(includeInactive = includeInactive, pageToken = pageToken, appCategory = appCategory)
  output <- .lightsail$get_bundles_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_bundles <- lightsail_get_bundles

#' Returns information about one or more Amazon Lightsail SSL/TLS
#' certificates
#'
#' @description
#' Returns information about one or more Amazon Lightsail SSL/TLS certificates.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_certificates/](https://www.paws-r-sdk.com/docs/lightsail_get_certificates/) for full documentation.
#'
#' @param certificateStatuses The status of the certificates for which to return information.
#' 
#' For example, specify `ISSUED` to return only certificates with an
#' `ISSUED` status.
#' 
#' When omitted, the response includes all of your certificates in the
#' Amazon Web Services Region where the request is made, regardless of
#' their current status.
#' @param includeCertificateDetails Indicates whether to include detailed information about the certificates
#' in the response.
#' 
#' When omitted, the response includes only the certificate names, Amazon
#' Resource Names (ARNs), domain names, and tags.
#' @param certificateName The name for the certificate for which to return information.
#' 
#' When omitted, the response includes all of your certificates in the
#' Amazon Web Services Region where the request is made.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_certificates`][lightsail_get_certificates] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_certificates
lightsail_get_certificates <- function(certificateStatuses = NULL, includeCertificateDetails = NULL, certificateName = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetCertificates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_certificates_input(certificateStatuses = certificateStatuses, includeCertificateDetails = includeCertificateDetails, certificateName = certificateName, pageToken = pageToken)
  output <- .lightsail$get_certificates_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_certificates <- lightsail_get_certificates

#' Returns the CloudFormation stack record created as a result of the
#' create cloud formation stack operation
#'
#' @description
#' Returns the CloudFormation stack record created as a result of the `create cloud formation stack` operation.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_cloud_formation_stack_records/](https://www.paws-r-sdk.com/docs/lightsail_get_cloud_formation_stack_records/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial `GetClouFormationStackRecords`
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_cloud_formation_stack_records
lightsail_get_cloud_formation_stack_records <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetCloudFormationStackRecords",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "cloudFormationStackRecords"),
    stream_api = FALSE
  )
  input <- .lightsail$get_cloud_formation_stack_records_input(pageToken = pageToken)
  output <- .lightsail$get_cloud_formation_stack_records_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_cloud_formation_stack_records <- lightsail_get_cloud_formation_stack_records

#' Returns information about the configured contact methods
#'
#' @description
#' Returns information about the configured contact methods. Specify a protocol in your request to return information about a specific contact method.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_contact_methods/](https://www.paws-r-sdk.com/docs/lightsail_get_contact_methods/) for full documentation.
#'
#' @param protocols The protocols used to send notifications, such as `Email`, or `SMS`
#' (text messaging).
#' 
#' Specify a protocol in your request to return information about a
#' specific contact method protocol.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_contact_methods
lightsail_get_contact_methods <- function(protocols = NULL) {
  op <- new_operation(
    name = "GetContactMethods",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_contact_methods_input(protocols = protocols)
  output <- .lightsail$get_contact_methods_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_contact_methods <- lightsail_get_contact_methods

#' Returns information about Amazon Lightsail containers, such as the
#' current version of the Lightsail Control (lightsailctl) plugin
#'
#' @description
#' Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control (lightsailctl) plugin.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_container_api_metadata/](https://www.paws-r-sdk.com/docs/lightsail_get_container_api_metadata/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_api_metadata
lightsail_get_container_api_metadata <- function() {
  op <- new_operation(
    name = "GetContainerAPIMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_container_api_metadata_input()
  output <- .lightsail$get_container_api_metadata_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_api_metadata <- lightsail_get_container_api_metadata

#' Returns the container images that are registered to your Amazon
#' Lightsail container service
#'
#' @description
#' Returns the container images that are registered to your Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_container_images/](https://www.paws-r-sdk.com/docs/lightsail_get_container_images/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to return registered
#' container images.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_images
lightsail_get_container_images <- function(serviceName) {
  op <- new_operation(
    name = "GetContainerImages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_container_images_input(serviceName = serviceName)
  output <- .lightsail$get_container_images_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_images <- lightsail_get_container_images

#' Returns the log events of a container of your Amazon Lightsail container
#' service
#'
#' @description
#' Returns the log events of a container of your Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_container_log/](https://www.paws-r-sdk.com/docs/lightsail_get_container_log/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to get a container log.
#' @param containerName &#91;required&#93; The name of the container that is either running or previously ran on
#' the container service for which to return a log.
#' @param startTime The start of the time interval for which to get log data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, specify `1538424000` as the start time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param endTime The end of the time interval for which to get log data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 9
#'     PM UTC, specify `1538427600` as the end time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param filterPattern The pattern to use to filter the returned log events to a specific term.
#' 
#' The following are a few examples of filter patterns that you can
#' specify:
#' 
#' -   To return all log events, specify a filter pattern of `""`.
#' 
#' -   To exclude log events that contain the `ERROR` term, and return all
#'     other log events, specify a filter pattern of `"-ERROR"`.
#' 
#' -   To return log events that contain the `ERROR` term, specify a filter
#'     pattern of `"ERROR"`.
#' 
#' -   To return log events that contain both the `ERROR` and `Exception`
#'     terms, specify a filter pattern of `"ERROR Exception"`.
#' 
#' -   To return log events that contain the `ERROR` *or* the `Exception`
#'     term, specify a filter pattern of `"?ERROR ?Exception"`.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_container_log`][lightsail_get_container_log] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_log
lightsail_get_container_log <- function(serviceName, containerName, startTime = NULL, endTime = NULL, filterPattern = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetContainerLog",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_container_log_input(serviceName = serviceName, containerName = containerName, startTime = startTime, endTime = endTime, filterPattern = filterPattern, pageToken = pageToken)
  output <- .lightsail$get_container_log_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_log <- lightsail_get_container_log

#' Returns the deployments for your Amazon Lightsail container service
#'
#' @description
#' Returns the deployments for your Amazon Lightsail container service
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_container_service_deployments/](https://www.paws-r-sdk.com/docs/lightsail_get_container_service_deployments/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to return deployments.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_service_deployments
lightsail_get_container_service_deployments <- function(serviceName) {
  op <- new_operation(
    name = "GetContainerServiceDeployments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_container_service_deployments_input(serviceName = serviceName)
  output <- .lightsail$get_container_service_deployments_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_service_deployments <- lightsail_get_container_service_deployments

#' Returns the data points of a specific metric of your Amazon Lightsail
#' container service
#'
#' @description
#' Returns the data points of a specific metric of your Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_container_service_metric_data/](https://www.paws-r-sdk.com/docs/lightsail_get_container_service_metric_data/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to get metric data.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid container service metric names are listed below, along with the
#' most useful statistics to include in your request, and the published
#' unit value.
#' 
#' -   `CPUUtilization` - The average percentage of compute units that are
#'     currently in use across all nodes of the container service. This
#'     metric identifies the processing power required to run containers on
#'     each node of the container service.
#' 
#'     Statistics: The most useful statistics are `Maximum` and `Average`.
#' 
#'     Unit: The published unit is `Percent`.
#' 
#' -   `MemoryUtilization` - The average percentage of available memory
#'     that is currently in use across all nodes of the container service.
#'     This metric identifies the memory required to run containers on each
#'     node of the container service.
#' 
#'     Statistics: The most useful statistics are `Maximum` and `Average`.
#' 
#'     Unit: The published unit is `Percent`.
#' @param startTime &#91;required&#93; The start time of the time period.
#' @param endTime &#91;required&#93; The end time of the time period.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' 
#' All container service metric data is available in 5-minute (300 seconds)
#' granularity.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of `Sum` / `SampleCount` during the specified
#'     period. By comparing this statistic with the `Minimum` and `Maximum`
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the `Minimum` and `Maximum` values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_service_metric_data
lightsail_get_container_service_metric_data <- function(serviceName, metricName, startTime, endTime, period, statistics) {
  op <- new_operation(
    name = "GetContainerServiceMetricData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_container_service_metric_data_input(serviceName = serviceName, metricName = metricName, startTime = startTime, endTime = endTime, period = period, statistics = statistics)
  output <- .lightsail$get_container_service_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_service_metric_data <- lightsail_get_container_service_metric_data

#' Returns the list of powers that can be specified for your Amazon
#' Lightsail container services
#'
#' @description
#' Returns the list of powers that can be specified for your Amazon Lightsail container services.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_container_service_powers/](https://www.paws-r-sdk.com/docs/lightsail_get_container_service_powers/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_service_powers
lightsail_get_container_service_powers <- function() {
  op <- new_operation(
    name = "GetContainerServicePowers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_container_service_powers_input()
  output <- .lightsail$get_container_service_powers_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_service_powers <- lightsail_get_container_service_powers

#' Returns information about one or more of your Amazon Lightsail container
#' services
#'
#' @description
#' Returns information about one or more of your Amazon Lightsail container services.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_container_services/](https://www.paws-r-sdk.com/docs/lightsail_get_container_services/) for full documentation.
#'
#' @param serviceName The name of the container service for which to return information.
#' 
#' When omitted, the response includes all of your container services in
#' the Amazon Web Services Region where the request is made.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_services
lightsail_get_container_services <- function(serviceName = NULL) {
  op <- new_operation(
    name = "GetContainerServices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_container_services_input(serviceName = serviceName)
  output <- .lightsail$get_container_services_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_services <- lightsail_get_container_services

#' Retrieves information about the cost estimate for a specified resource
#'
#' @description
#' Retrieves information about the cost estimate for a specified resource. A cost estimate will not generate for a resource that has been deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_cost_estimate/](https://www.paws-r-sdk.com/docs/lightsail_get_cost_estimate/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The resource name.
#' @param startTime &#91;required&#93; The cost estimate start time.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you want to use a start time of October 1, 2018, at
#'     8 PM UTC, specify `1538424000` as the start time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param endTime &#91;required&#93; The cost estimate end time.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you want to use an end time of October 1, 2018, at 9
#'     PM UTC, specify `1538427600` as the end time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#'
#' @keywords internal
#'
#' @rdname lightsail_get_cost_estimate
lightsail_get_cost_estimate <- function(resourceName, startTime, endTime) {
  op <- new_operation(
    name = "GetCostEstimate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_cost_estimate_input(resourceName = resourceName, startTime = startTime, endTime = endTime)
  output <- .lightsail$get_cost_estimate_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_cost_estimate <- lightsail_get_cost_estimate

#' Returns information about a specific block storage disk
#'
#' @description
#' Returns information about a specific block storage disk.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_disk/](https://www.paws-r-sdk.com/docs/lightsail_get_disk/) for full documentation.
#'
#' @param diskName &#91;required&#93; The name of the disk (`my-disk`).
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk
lightsail_get_disk <- function(diskName) {
  op <- new_operation(
    name = "GetDisk",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_disk_input(diskName = diskName)
  output <- .lightsail$get_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk <- lightsail_get_disk

#' Returns information about a specific block storage disk snapshot
#'
#' @description
#' Returns information about a specific block storage disk snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_disk_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_get_disk_snapshot/) for full documentation.
#'
#' @param diskSnapshotName &#91;required&#93; The name of the disk snapshot (`my-disk-snapshot`).
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk_snapshot
lightsail_get_disk_snapshot <- function(diskSnapshotName) {
  op <- new_operation(
    name = "GetDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_disk_snapshot_input(diskSnapshotName = diskSnapshotName)
  output <- .lightsail$get_disk_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk_snapshot <- lightsail_get_disk_snapshot

#' Returns information about all block storage disk snapshots in your AWS
#' account and region
#'
#' @description
#' Returns information about all block storage disk snapshots in your AWS account and region.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_disk_snapshots/](https://www.paws-r-sdk.com/docs/lightsail_get_disk_snapshots/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_disk_snapshots`][lightsail_get_disk_snapshots] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk_snapshots
lightsail_get_disk_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDiskSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "diskSnapshots"),
    stream_api = FALSE
  )
  input <- .lightsail$get_disk_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_disk_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk_snapshots <- lightsail_get_disk_snapshots

#' Returns information about all block storage disks in your AWS account
#' and region
#'
#' @description
#' Returns information about all block storage disks in your AWS account and region.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_disks/](https://www.paws-r-sdk.com/docs/lightsail_get_disks/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_disks`][lightsail_get_disks] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disks
lightsail_get_disks <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDisks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "disks"),
    stream_api = FALSE
  )
  input <- .lightsail$get_disks_input(pageToken = pageToken)
  output <- .lightsail$get_disks_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disks <- lightsail_get_disks

#' Returns the bundles that can be applied to your Amazon Lightsail content
#' delivery network (CDN) distributions
#'
#' @description
#' Returns the bundles that can be applied to your Amazon Lightsail content delivery network (CDN) distributions.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_distribution_bundles/](https://www.paws-r-sdk.com/docs/lightsail_get_distribution_bundles/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_get_distribution_bundles
lightsail_get_distribution_bundles <- function() {
  op <- new_operation(
    name = "GetDistributionBundles",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_distribution_bundles_input()
  output <- .lightsail$get_distribution_bundles_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distribution_bundles <- lightsail_get_distribution_bundles

#' Returns the timestamp and status of the last cache reset of a specific
#' Amazon Lightsail content delivery network (CDN) distribution
#'
#' @description
#' Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_distribution_latest_cache_reset/](https://www.paws-r-sdk.com/docs/lightsail_get_distribution_latest_cache_reset/) for full documentation.
#'
#' @param distributionName The name of the distribution for which to return the timestamp of the
#' last cache reset.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' 
#' When omitted, the response includes the latest cache reset timestamp of
#' all your distributions.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_distribution_latest_cache_reset
lightsail_get_distribution_latest_cache_reset <- function(distributionName = NULL) {
  op <- new_operation(
    name = "GetDistributionLatestCacheReset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_distribution_latest_cache_reset_input(distributionName = distributionName)
  output <- .lightsail$get_distribution_latest_cache_reset_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distribution_latest_cache_reset <- lightsail_get_distribution_latest_cache_reset

#' Returns the data points of a specific metric for an Amazon Lightsail
#' content delivery network (CDN) distribution
#'
#' @description
#' Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_distribution_metric_data/](https://www.paws-r-sdk.com/docs/lightsail_get_distribution_metric_data/) for full documentation.
#'
#' @param distributionName &#91;required&#93; The name of the distribution for which to get metric data.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid distribution metric names are listed below, along with the most
#' useful `statistics` to include in your request, and the published `unit`
#' value.
#' 
#' -   **`Requests`** - The total number of viewer requests received by
#'     your Lightsail distribution, for all HTTP methods, and for both HTTP
#'     and HTTPS requests.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `None`.
#' 
#' -   **`BytesDownloaded`** - The number of bytes downloaded by viewers
#'     for GET, HEAD, and OPTIONS requests.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `None`.
#' 
#' -   **`BytesUploaded `** - The number of bytes uploaded to your origin
#'     by your Lightsail distribution, using POST and PUT requests.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `None`.
#' 
#' -   **`TotalErrorRate`** - The percentage of all viewer requests for
#'     which the response's HTTP status code was 4xx or 5xx.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`4xxErrorRate`** - The percentage of all viewer requests for which
#'     the response's HTTP status cod was 4xx. In these cases, the client
#'     or client viewer may have made an error. For example, a status code
#'     of 404 (Not Found) means that the client requested an object that
#'     could not be found.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`5xxErrorRate`** - The percentage of all viewer requests for which
#'     the response's HTTP status code was 5xx. In these cases, the origin
#'     server did not satisfy the requests. For example, a status code of
#'     503 (Service Unavailable) means that the origin server is currently
#'     unavailable.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' @param startTime &#91;required&#93; The start of the time interval for which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, specify `1538424000` as the start time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param endTime &#91;required&#93; The end of the time interval for which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 9
#'     PM UTC, specify `1538427600` as the end time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param period &#91;required&#93; The granularity, in seconds, for the metric data points that will be
#' returned.
#' @param unit &#91;required&#93; The unit for the metric data request.
#' 
#' Valid units depend on the metric data being requested. For the valid
#' units with each available metric, see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_distribution_metric_data
lightsail_get_distribution_metric_data <- function(distributionName, metricName, startTime, endTime, period, unit, statistics) {
  op <- new_operation(
    name = "GetDistributionMetricData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_distribution_metric_data_input(distributionName = distributionName, metricName = metricName, startTime = startTime, endTime = endTime, period = period, unit = unit, statistics = statistics)
  output <- .lightsail$get_distribution_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distribution_metric_data <- lightsail_get_distribution_metric_data

#' Returns information about one or more of your Amazon Lightsail content
#' delivery network (CDN) distributions
#'
#' @description
#' Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_distributions/](https://www.paws-r-sdk.com/docs/lightsail_get_distributions/) for full documentation.
#'
#' @param distributionName The name of the distribution for which to return information.
#' 
#' When omitted, the response includes all of your distributions in the
#' Amazon Web Services Region where the request is made.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_distributions`][lightsail_get_distributions] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_distributions
lightsail_get_distributions <- function(distributionName = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetDistributions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_distributions_input(distributionName = distributionName, pageToken = pageToken)
  output <- .lightsail$get_distributions_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distributions <- lightsail_get_distributions

#' Returns information about a specific domain recordset
#'
#' @description
#' Returns information about a specific domain recordset.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_domain/](https://www.paws-r-sdk.com/docs/lightsail_get_domain/) for full documentation.
#'
#' @param domainName &#91;required&#93; The domain name for which your want to return information about.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_domain
lightsail_get_domain <- function(domainName) {
  op <- new_operation(
    name = "GetDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_domain_input(domainName = domainName)
  output <- .lightsail$get_domain_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_domain <- lightsail_get_domain

#' Returns a list of all domains in the user's account
#'
#' @description
#' Returns a list of all domains in the user's account.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_domains/](https://www.paws-r-sdk.com/docs/lightsail_get_domains/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_domains`][lightsail_get_domains] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_domains
lightsail_get_domains <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "domains"),
    stream_api = FALSE
  )
  input <- .lightsail$get_domains_input(pageToken = pageToken)
  output <- .lightsail$get_domains_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_domains <- lightsail_get_domains

#' Returns all export snapshot records created as a result of the export
#' snapshot operation
#'
#' @description
#' Returns all export snapshot records created as a result of the `export snapshot` operation.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_export_snapshot_records/](https://www.paws-r-sdk.com/docs/lightsail_get_export_snapshot_records/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_export_snapshot_records`][lightsail_get_export_snapshot_records]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_export_snapshot_records
lightsail_get_export_snapshot_records <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetExportSnapshotRecords",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "exportSnapshotRecords"),
    stream_api = FALSE
  )
  input <- .lightsail$get_export_snapshot_records_input(pageToken = pageToken)
  output <- .lightsail$get_export_snapshot_records_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_export_snapshot_records <- lightsail_get_export_snapshot_records

#' Returns information about a specific Amazon Lightsail instance, which is
#' a virtual private server
#'
#' @description
#' Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instance/](https://www.paws-r-sdk.com/docs/lightsail_get_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance
lightsail_get_instance <- function(instanceName) {
  op <- new_operation(
    name = "GetInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_instance_input(instanceName = instanceName)
  output <- .lightsail$get_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance <- lightsail_get_instance

#' Returns temporary SSH keys you can use to connect to a specific virtual
#' private server, or instance
#'
#' @description
#' Returns temporary SSH keys you can use to connect to a specific virtual private server, or *instance*.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instance_access_details/](https://www.paws-r-sdk.com/docs/lightsail_get_instance_access_details/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance to access.
#' @param protocol The protocol to use to connect to your instance. Defaults to `ssh`.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_access_details
lightsail_get_instance_access_details <- function(instanceName, protocol = NULL) {
  op <- new_operation(
    name = "GetInstanceAccessDetails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_instance_access_details_input(instanceName = instanceName, protocol = protocol)
  output <- .lightsail$get_instance_access_details_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_access_details <- lightsail_get_instance_access_details

#' Returns the data points for the specified Amazon Lightsail instance
#' metric, given an instance name
#'
#' @description
#' Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instance_metric_data/](https://www.paws-r-sdk.com/docs/lightsail_get_instance_metric_data/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance for which you want to get metrics data.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid instance metric names are listed below, along with the most useful
#' `statistics` to include in your request, and the published `unit` value.
#' 
#' -   **`BurstCapacityPercentage`** - The percentage of CPU performance
#'     available for your instance to burst above its baseline. Your
#'     instance continuously accrues and consumes burst capacity. Burst
#'     capacity stops accruing when your instance's
#'     `BurstCapacityPercentage` reaches 100%. For more information, see
#'     [Viewing instance burst capacity in Amazon
#'     Lightsail](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-viewing-instance-burst-capacity.html).
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`BurstCapacityTime`** - The available amount of time for your
#'     instance to burst at 100% CPU utilization. Your instance
#'     continuously accrues and consumes burst capacity. Burst capacity
#'     time stops accruing when your instance's `BurstCapacityPercentage`
#'     metric reaches 100%.
#' 
#'     Burst capacity time is consumed at the full rate only when your
#'     instance operates at 100% CPU utilization. For example, if your
#'     instance operates at 50% CPU utilization in the burstable zone for a
#'     5-minute period, then it consumes CPU burst capacity minutes at a
#'     50% rate in that period. Your instance consumed 2 minutes and 30
#'     seconds of CPU burst capacity minutes in the 5-minute period. For
#'     more information, see [Viewing instance burst capacity in Amazon
#'     Lightsail](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-viewing-instance-burst-capacity.html).
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Seconds`.
#' 
#' -   **`CPUUtilization`** - The percentage of allocated compute units
#'     that are currently in use on the instance. This metric identifies
#'     the processing power to run the applications on the instance. Tools
#'     in your operating system can show a lower percentage than Lightsail
#'     when the instance is not allocated a full processor core.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`NetworkIn`** - The number of bytes received on all network
#'     interfaces by the instance. This metric identifies the volume of
#'     incoming network traffic to the instance. The number reported is the
#'     number of bytes received during the period. Because this metric is
#'     reported in 5-minute intervals, divide the reported number by 300 to
#'     find Bytes/second.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Bytes`.
#' 
#' -   **`NetworkOut`** - The number of bytes sent out on all network
#'     interfaces by the instance. This metric identifies the volume of
#'     outgoing network traffic from the instance. The number reported is
#'     the number of bytes sent during the period. Because this metric is
#'     reported in 5-minute intervals, divide the reported number by 300 to
#'     find Bytes/second.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Bytes`.
#' 
#' -   **`StatusCheckFailed`** - Reports whether the instance passed or
#'     failed both the instance status check and the system status check.
#'     This metric can be either 0 (passed) or 1 (failed). This metric data
#'     is available in 1-minute (60 seconds) granularity.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`StatusCheckFailed_Instance`** - Reports whether the instance
#'     passed or failed the instance status check. This metric can be
#'     either 0 (passed) or 1 (failed). This metric data is available in
#'     1-minute (60 seconds) granularity.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`StatusCheckFailed_System`** - Reports whether the instance passed
#'     or failed the system status check. This metric can be either 0
#'     (passed) or 1 (failed). This metric data is available in 1-minute
#'     (60 seconds) granularity.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`MetadataNoToken`** - Reports the number of times that the
#'     instance metadata service was successfully accessed without a token.
#'     This metric determines if there are any processes accessing instance
#'     metadata by using Instance Metadata Service Version 1, which doesn't
#'     use a token. If all requests use token-backed sessions, such as
#'     Instance Metadata Service Version 2, then the value is 0.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' 
#' The `StatusCheckFailed`, `StatusCheckFailed_Instance`, and
#' `StatusCheckFailed_System` instance metric data is available in 1-minute
#' (60 seconds) granularity. All other instance metric data is available in
#' 5-minute (300 seconds) granularity.
#' @param startTime &#91;required&#93; The start time of the time period.
#' @param endTime &#91;required&#93; The end time of the time period.
#' @param unit &#91;required&#93; The unit for the metric data request. Valid units depend on the metric
#' data being requested. For the valid units to specify with each available
#' metric, see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_metric_data
lightsail_get_instance_metric_data <- function(instanceName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetInstanceMetricData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_instance_metric_data_input(instanceName = instanceName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_instance_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_metric_data <- lightsail_get_instance_metric_data

#' Returns the firewall port states for a specific Amazon Lightsail
#' instance, the IP addresses allowed to connect to the instance through
#' the ports, and the protocol
#'
#' @description
#' Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to the instance through the ports, and the protocol.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instance_port_states/](https://www.paws-r-sdk.com/docs/lightsail_get_instance_port_states/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance for which to return firewall port states.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_port_states
lightsail_get_instance_port_states <- function(instanceName) {
  op <- new_operation(
    name = "GetInstancePortStates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_instance_port_states_input(instanceName = instanceName)
  output <- .lightsail$get_instance_port_states_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_port_states <- lightsail_get_instance_port_states

#' Returns information about a specific instance snapshot
#'
#' @description
#' Returns information about a specific instance snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instance_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_get_instance_snapshot/) for full documentation.
#'
#' @param instanceSnapshotName &#91;required&#93; The name of the snapshot for which you are requesting information.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_snapshot
lightsail_get_instance_snapshot <- function(instanceSnapshotName) {
  op <- new_operation(
    name = "GetInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName)
  output <- .lightsail$get_instance_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_snapshot <- lightsail_get_instance_snapshot

#' Returns all instance snapshots for the user's account
#'
#' @description
#' Returns all instance snapshots for the user's account.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instance_snapshots/](https://www.paws-r-sdk.com/docs/lightsail_get_instance_snapshots/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_instance_snapshots`][lightsail_get_instance_snapshots] request. If
#' your results are paginated, the response will return a next page token
#' that you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_snapshots
lightsail_get_instance_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetInstanceSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "instanceSnapshots"),
    stream_api = FALSE
  )
  input <- .lightsail$get_instance_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_instance_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_snapshots <- lightsail_get_instance_snapshots

#' Returns the state of a specific instance
#'
#' @description
#' Returns the state of a specific instance. Works on one instance at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instance_state/](https://www.paws-r-sdk.com/docs/lightsail_get_instance_state/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance to get state information about.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_state
lightsail_get_instance_state <- function(instanceName) {
  op <- new_operation(
    name = "GetInstanceState",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_instance_state_input(instanceName = instanceName)
  output <- .lightsail$get_instance_state_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_state <- lightsail_get_instance_state

#' Returns information about all Amazon Lightsail virtual private servers,
#' or instances
#'
#' @description
#' Returns information about all Amazon Lightsail virtual private servers, or *instances*.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_instances/](https://www.paws-r-sdk.com/docs/lightsail_get_instances/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_instances`][lightsail_get_instances] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instances
lightsail_get_instances <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "instances"),
    stream_api = FALSE
  )
  input <- .lightsail$get_instances_input(pageToken = pageToken)
  output <- .lightsail$get_instances_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instances <- lightsail_get_instances

#' Returns information about a specific key pair
#'
#' @description
#' Returns information about a specific key pair.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_key_pair/](https://www.paws-r-sdk.com/docs/lightsail_get_key_pair/) for full documentation.
#'
#' @param keyPairName &#91;required&#93; The name of the key pair for which you are requesting information.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_key_pair
lightsail_get_key_pair <- function(keyPairName) {
  op <- new_operation(
    name = "GetKeyPair",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_key_pair_input(keyPairName = keyPairName)
  output <- .lightsail$get_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_key_pair <- lightsail_get_key_pair

#' Returns information about all key pairs in the user's account
#'
#' @description
#' Returns information about all key pairs in the user's account.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_key_pairs/](https://www.paws-r-sdk.com/docs/lightsail_get_key_pairs/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_key_pairs`][lightsail_get_key_pairs] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#' @param includeDefaultKeyPair A Boolean value that indicates whether to include the default key pair
#' in the response of your request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_key_pairs
lightsail_get_key_pairs <- function(pageToken = NULL, includeDefaultKeyPair = NULL) {
  op <- new_operation(
    name = "GetKeyPairs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "keyPairs"),
    stream_api = FALSE
  )
  input <- .lightsail$get_key_pairs_input(pageToken = pageToken, includeDefaultKeyPair = includeDefaultKeyPair)
  output <- .lightsail$get_key_pairs_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_key_pairs <- lightsail_get_key_pairs

#' Returns information about the specified Lightsail load balancer
#'
#' @description
#' Returns information about the specified Lightsail load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer/](https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer
lightsail_get_load_balancer <- function(loadBalancerName) {
  op <- new_operation(
    name = "GetLoadBalancer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_load_balancer_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$get_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer <- lightsail_get_load_balancer

#' Returns information about health metrics for your Lightsail load
#' balancer
#'
#' @description
#' Returns information about health metrics for your Lightsail load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer_metric_data/](https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer_metric_data/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid load balancer metric names are listed below, along with the most
#' useful `statistics` to include in your request, and the published `unit`
#' value.
#' 
#' -   **`ClientTLSNegotiationErrorCount`** - The number of TLS connections
#'     initiated by the client that did not establish a session with the
#'     load balancer due to a TLS error generated by the load balancer.
#'     Possible causes include a mismatch of ciphers or protocols.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HealthyHostCount`** - The number of target instances that are
#'     considered healthy.
#' 
#'     `Statistics`: The most useful statistic are `Average`, `Minimum`,
#'     and `Maximum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_2XX_Count`** - The number of HTTP 2XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_3XX_Count`** - The number of HTTP 3XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_4XX_Count`** - The number of HTTP 4XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_5XX_Count`** - The number of HTTP 5XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_LB_4XX_Count`** - The number of HTTP 4XX client error
#'     codes that originated from the load balancer. Client errors are
#'     generated when requests are malformed or incomplete. These requests
#'     were not received by the target instance. This count does not
#'     include response codes generated by the target instances.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_LB_5XX_Count`** - The number of HTTP 5XX server error
#'     codes that originated from the load balancer. This does not include
#'     any response codes generated by the target instance. This metric is
#'     reported if there are no healthy instances attached to the load
#'     balancer, or if the request rate exceeds the capacity of the
#'     instances (spillover) or the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`InstanceResponseTime`** - The time elapsed, in seconds, after the
#'     request leaves the load balancer until a response from the target
#'     instance is received.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Seconds`.
#' 
#' -   **`RejectedConnectionCount`** - The number of connections that were
#'     rejected because the load balancer had reached its maximum number of
#'     connections.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`RequestCount`** - The number of requests processed over IPv4.
#'     This count includes only the requests with a response generated by a
#'     target instance of the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`UnhealthyHostCount`** - The number of target instances that are
#'     considered unhealthy.
#' 
#'     `Statistics`: The most useful statistic are `Average`, `Minimum`,
#'     and `Maximum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' @param startTime &#91;required&#93; The start time of the period.
#' @param endTime &#91;required&#93; The end time of the period.
#' @param unit &#91;required&#93; The unit for the metric data request. Valid units depend on the metric
#' data being requested. For the valid units with each available metric,
#' see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer_metric_data
lightsail_get_load_balancer_metric_data <- function(loadBalancerName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetLoadBalancerMetricData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_load_balancer_metric_data_input(loadBalancerName = loadBalancerName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_load_balancer_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer_metric_data <- lightsail_get_load_balancer_metric_data

#' Returns information about the TLS certificates that are associated with
#' the specified Lightsail load balancer
#'
#' @description
#' Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer_tls_certificates/](https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer_tls_certificates/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer you associated with your SSL/TLS
#' certificate.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer_tls_certificates
lightsail_get_load_balancer_tls_certificates <- function(loadBalancerName) {
  op <- new_operation(
    name = "GetLoadBalancerTlsCertificates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_load_balancer_tls_certificates_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$get_load_balancer_tls_certificates_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer_tls_certificates <- lightsail_get_load_balancer_tls_certificates

#' Returns a list of TLS security policies that you can apply to Lightsail
#' load balancers
#'
#' @description
#' Returns a list of TLS security policies that you can apply to Lightsail load balancers.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer_tls_policies/](https://www.paws-r-sdk.com/docs/lightsail_get_load_balancer_tls_policies/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_load_balancer_tls_policies`][lightsail_get_load_balancer_tls_policies]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer_tls_policies
lightsail_get_load_balancer_tls_policies <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetLoadBalancerTlsPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_load_balancer_tls_policies_input(pageToken = pageToken)
  output <- .lightsail$get_load_balancer_tls_policies_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer_tls_policies <- lightsail_get_load_balancer_tls_policies

#' Returns information about all load balancers in an account
#'
#' @description
#' Returns information about all load balancers in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_load_balancers/](https://www.paws-r-sdk.com/docs/lightsail_get_load_balancers/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_load_balancers`][lightsail_get_load_balancers] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancers
lightsail_get_load_balancers <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetLoadBalancers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "loadBalancers"),
    stream_api = FALSE
  )
  input <- .lightsail$get_load_balancers_input(pageToken = pageToken)
  output <- .lightsail$get_load_balancers_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancers <- lightsail_get_load_balancers

#' Returns information about a specific operation
#'
#' @description
#' Returns information about a specific operation. Operations include events such as when you create an instance, allocate a static IP, attach a static IP, and so on.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_operation/](https://www.paws-r-sdk.com/docs/lightsail_get_operation/) for full documentation.
#'
#' @param operationId &#91;required&#93; A GUID used to identify the operation.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operation
lightsail_get_operation <- function(operationId) {
  op <- new_operation(
    name = "GetOperation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_operation_input(operationId = operationId)
  output <- .lightsail$get_operation_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operation <- lightsail_get_operation

#' Returns information about all operations
#'
#' @description
#' Returns information about all operations.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_operations/](https://www.paws-r-sdk.com/docs/lightsail_get_operations/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_operations`][lightsail_get_operations] request. If your results
#' are paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operations
lightsail_get_operations <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetOperations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "operations"),
    stream_api = FALSE
  )
  input <- .lightsail$get_operations_input(pageToken = pageToken)
  output <- .lightsail$get_operations_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operations <- lightsail_get_operations

#' Gets operations for a specific resource (an instance or a static IP)
#'
#' @description
#' Gets operations for a specific resource (an instance or a static IP).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_operations_for_resource/](https://www.paws-r-sdk.com/docs/lightsail_get_operations_for_resource/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the resource for which you are requesting information.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_operations_for_resource`][lightsail_get_operations_for_resource]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operations_for_resource
lightsail_get_operations_for_resource <- function(resourceName, pageToken = NULL) {
  op <- new_operation(
    name = "GetOperationsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_operations_for_resource_input(resourceName = resourceName, pageToken = pageToken)
  output <- .lightsail$get_operations_for_resource_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operations_for_resource <- lightsail_get_operations_for_resource

#' Returns a list of all valid regions for Amazon Lightsail
#'
#' @description
#' Returns a list of all valid regions for Amazon Lightsail. Use the `include availability zones` parameter to also return the Availability Zones in a region.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_regions/](https://www.paws-r-sdk.com/docs/lightsail_get_regions/) for full documentation.
#'
#' @param includeAvailabilityZones A Boolean value indicating whether to also include Availability Zones in
#' your get regions request. Availability Zones are indicated with a
#' letter: `us-east-2a`.
#' @param includeRelationalDatabaseAvailabilityZones A Boolean value indicating whether to also include Availability Zones
#' for databases in your get regions request. Availability Zones are
#' indicated with a letter (`us-east-2a`).
#'
#' @keywords internal
#'
#' @rdname lightsail_get_regions
lightsail_get_regions <- function(includeAvailabilityZones = NULL, includeRelationalDatabaseAvailabilityZones = NULL) {
  op <- new_operation(
    name = "GetRegions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_regions_input(includeAvailabilityZones = includeAvailabilityZones, includeRelationalDatabaseAvailabilityZones = includeRelationalDatabaseAvailabilityZones)
  output <- .lightsail$get_regions_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_regions <- lightsail_get_regions

#' Returns information about a specific database in Amazon Lightsail
#'
#' @description
#' Returns information about a specific database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database that you are looking up.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database
lightsail_get_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "GetRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$get_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database <- lightsail_get_relational_database

#' Returns a list of available database blueprints in Amazon Lightsail
#'
#' @description
#' Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine version of a database.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_blueprints/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_blueprints/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_blueprints`][lightsail_get_relational_database_blueprints]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_blueprints
lightsail_get_relational_database_blueprints <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseBlueprints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "blueprints"),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_blueprints_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_blueprints_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_blueprints <- lightsail_get_relational_database_blueprints

#' Returns the list of bundles that are available in Amazon Lightsail
#'
#' @description
#' Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance specifications for a database.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_bundles/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_bundles/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_bundles`][lightsail_get_relational_database_bundles]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#' @param includeInactive A Boolean value that indicates whether to include inactive (unavailable)
#' bundles in the response of your request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_bundles
lightsail_get_relational_database_bundles <- function(pageToken = NULL, includeInactive = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseBundles",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "bundles"),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_bundles_input(pageToken = pageToken, includeInactive = includeInactive)
  output <- .lightsail$get_relational_database_bundles_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_bundles <- lightsail_get_relational_database_bundles

#' Returns a list of events for a specific database in Amazon Lightsail
#'
#' @description
#' Returns a list of events for a specific database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_events/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_events/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database from which to get events.
#' @param durationInMinutes The number of minutes in the past from which to retrieve events. For
#' example, to get all events from the past 2 hours, enter 120.
#' 
#' Default: `60`
#' 
#' The minimum is 1 and the maximum is 14 days (20160 minutes).
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_events`][lightsail_get_relational_database_events]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_events
lightsail_get_relational_database_events <- function(relationalDatabaseName, durationInMinutes = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "relationalDatabaseEvents"),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_events_input(relationalDatabaseName = relationalDatabaseName, durationInMinutes = durationInMinutes, pageToken = pageToken)
  output <- .lightsail$get_relational_database_events_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_events <- lightsail_get_relational_database_events

#' Returns a list of log events for a database in Amazon Lightsail
#'
#' @description
#' Returns a list of log events for a database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_log_events/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_log_events/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get log events.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#' 
#' Use the `get relational database log streams` operation to get a list of
#' available log streams.
#' @param startTime The start of the time interval from which to get log events.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, then you input `1538424000` as the start time.
#' @param endTime The end of the time interval from which to get log events.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 8
#'     PM UTC, then you input `1538424000` as the end time.
#' @param startFromHead Parameter to specify if the log should start from head or tail. If
#' `true` is specified, the log event starts from the head of the log. If
#' `false` is specified, the log event starts from the tail of the log.
#' 
#' For PostgreSQL, the default value of `false` is the only option
#' available.
#' @param pageToken The token to advance to the next or previous page of results from your
#' request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_log_events`][lightsail_get_relational_database_log_events]
#' request. If your results are paginated, the response will return a next
#' forward token and/or next backward token that you can specify as the
#' page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_log_events
lightsail_get_relational_database_log_events <- function(relationalDatabaseName, logStreamName, startTime = NULL, endTime = NULL, startFromHead = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseLogEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_log_events_input(relationalDatabaseName = relationalDatabaseName, logStreamName = logStreamName, startTime = startTime, endTime = endTime, startFromHead = startFromHead, pageToken = pageToken)
  output <- .lightsail$get_relational_database_log_events_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_log_events <- lightsail_get_relational_database_log_events

#' Returns a list of available log streams for a specific database in
#' Amazon Lightsail
#'
#' @description
#' Returns a list of available log streams for a specific database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_log_streams/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_log_streams/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get log streams.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_log_streams
lightsail_get_relational_database_log_streams <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "GetRelationalDatabaseLogStreams",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_log_streams_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$get_relational_database_log_streams_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_log_streams <- lightsail_get_relational_database_log_streams

#' Returns the current, previous, or pending versions of the master user
#' password for a Lightsail database
#'
#' @description
#' Returns the current, previous, or pending versions of the master user password for a Lightsail database.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_master_user_password/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_master_user_password/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get the master user password.
#' @param passwordVersion The password version to return.
#' 
#' Specifying `CURRENT` or `PREVIOUS` returns the current or previous
#' passwords respectively. Specifying `PENDING` returns the newest version
#' of the password that will rotate to `CURRENT`. After the `PENDING`
#' password rotates to `CURRENT`, the `PENDING` password is no longer
#' available.
#' 
#' Default: `CURRENT`
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_master_user_password
lightsail_get_relational_database_master_user_password <- function(relationalDatabaseName, passwordVersion = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseMasterUserPassword",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_master_user_password_input(relationalDatabaseName = relationalDatabaseName, passwordVersion = passwordVersion)
  output <- .lightsail$get_relational_database_master_user_password_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_master_user_password <- lightsail_get_relational_database_master_user_password

#' Returns the data points of the specified metric for a database in Amazon
#' Lightsail
#'
#' @description
#' Returns the data points of the specified metric for a database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_metric_data/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_metric_data/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database from which to get metric data.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid relational database metric names are listed below, along with the
#' most useful `statistics` to include in your request, and the published
#' `unit` value. All relational database metric data is available in
#' 1-minute (60 seconds) granularity.
#' 
#' -   **`CPUUtilization`** - The percentage of CPU utilization currently
#'     in use on the database.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`DatabaseConnections`** - The number of database connections in
#'     use.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`DiskQueueDepth`** - The number of outstanding IOs (read/write
#'     requests) that are waiting to access the disk.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`FreeStorageSpace`** - The amount of available storage space.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Bytes`.
#' 
#' -   **`NetworkReceiveThroughput`** - The incoming (Receive) network
#'     traffic on the database, including both customer database traffic
#'     and AWS traffic used for monitoring and replication.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Bytes/Second`.
#' 
#' -   **`NetworkTransmitThroughput`** - The outgoing (Transmit) network
#'     traffic on the database, including both customer database traffic
#'     and AWS traffic used for monitoring and replication.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Bytes/Second`.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' 
#' All relational database metric data is available in 1-minute (60
#' seconds) granularity.
#' @param startTime &#91;required&#93; The start of the time interval from which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, then you input `1538424000` as the start time.
#' @param endTime &#91;required&#93; The end of the time interval from which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 8
#'     PM UTC, then you input `1538424000` as the end time.
#' @param unit &#91;required&#93; The unit for the metric data request. Valid units depend on the metric
#' data being requested. For the valid units with each available metric,
#' see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_metric_data
lightsail_get_relational_database_metric_data <- function(relationalDatabaseName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetRelationalDatabaseMetricData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_metric_data_input(relationalDatabaseName = relationalDatabaseName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_relational_database_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_metric_data <- lightsail_get_relational_database_metric_data

#' Returns all of the runtime parameters offered by the underlying database
#' software, or engine, for a specific database in Amazon Lightsail
#'
#' @description
#' Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_parameters/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_parameters/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get parameters.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_parameters`][lightsail_get_relational_database_parameters]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_parameters
lightsail_get_relational_database_parameters <- function(relationalDatabaseName, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseParameters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "parameters"),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_parameters_input(relationalDatabaseName = relationalDatabaseName, pageToken = pageToken)
  output <- .lightsail$get_relational_database_parameters_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_parameters <- lightsail_get_relational_database_parameters

#' Returns information about a specific database snapshot in Amazon
#' Lightsail
#'
#' @description
#' Returns information about a specific database snapshot in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_snapshot/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_snapshot/) for full documentation.
#'
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name of the database snapshot for which to get information.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_snapshot
lightsail_get_relational_database_snapshot <- function(relationalDatabaseSnapshotName) {
  op <- new_operation(
    name = "GetRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_snapshot_input(relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$get_relational_database_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_snapshot <- lightsail_get_relational_database_snapshot

#' Returns information about all of your database snapshots in Amazon
#' Lightsail
#'
#' @description
#' Returns information about all of your database snapshots in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_snapshots/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_database_snapshots/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_snapshots`][lightsail_get_relational_database_snapshots]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_snapshots
lightsail_get_relational_database_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "relationalDatabaseSnapshots"),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_database_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_snapshots <- lightsail_get_relational_database_snapshots

#' Returns information about all of your databases in Amazon Lightsail
#'
#' @description
#' Returns information about all of your databases in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_relational_databases/](https://www.paws-r-sdk.com/docs/lightsail_get_relational_databases/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_databases`][lightsail_get_relational_databases]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_databases
lightsail_get_relational_databases <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabases",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "relationalDatabases"),
    stream_api = FALSE
  )
  input <- .lightsail$get_relational_databases_input(pageToken = pageToken)
  output <- .lightsail$get_relational_databases_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_databases <- lightsail_get_relational_databases

#' Returns detailed information for five of the most recent
#' SetupInstanceHttps requests that were ran on the target instance
#'
#' @description
#' Returns detailed information for five of the most recent [`setup_instance_https`][lightsail_setup_instance_https] requests that were ran on the target instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_setup_history/](https://www.paws-r-sdk.com/docs/lightsail_get_setup_history/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the resource for which you are requesting information.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_setup_history`][lightsail_get_setup_history] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_setup_history
lightsail_get_setup_history <- function(resourceName, pageToken = NULL) {
  op <- new_operation(
    name = "GetSetupHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_setup_history_input(resourceName = resourceName, pageToken = pageToken)
  output <- .lightsail$get_setup_history_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_setup_history <- lightsail_get_setup_history

#' Returns information about an Amazon Lightsail static IP
#'
#' @description
#' Returns information about an Amazon Lightsail static IP.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_static_ip/](https://www.paws-r-sdk.com/docs/lightsail_get_static_ip/) for full documentation.
#'
#' @param staticIpName &#91;required&#93; The name of the static IP in Lightsail.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_static_ip
lightsail_get_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "GetStaticIp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$get_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$get_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_static_ip <- lightsail_get_static_ip

#' Returns information about all static IPs in the user's account
#'
#' @description
#' Returns information about all static IPs in the user's account.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_get_static_ips/](https://www.paws-r-sdk.com/docs/lightsail_get_static_ips/) for full documentation.
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_static_ips`][lightsail_get_static_ips] request. If your results
#' are paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @keywords internal
#'
#' @rdname lightsail_get_static_ips
lightsail_get_static_ips <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetStaticIps",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "pageToken", output_token = "nextPageToken", result_key = "staticIps"),
    stream_api = FALSE
  )
  input <- .lightsail$get_static_ips_input(pageToken = pageToken)
  output <- .lightsail$get_static_ips_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_static_ips <- lightsail_get_static_ips

#' Imports a public SSH key from a specific key pair
#'
#' @description
#' Imports a public SSH key from a specific key pair.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_import_key_pair/](https://www.paws-r-sdk.com/docs/lightsail_import_key_pair/) for full documentation.
#'
#' @param keyPairName &#91;required&#93; The name of the key pair for which you want to import the public key.
#' @param publicKeyBase64 &#91;required&#93; A base64-encoded public key of the `ssh-rsa` type.
#'
#' @keywords internal
#'
#' @rdname lightsail_import_key_pair
lightsail_import_key_pair <- function(keyPairName, publicKeyBase64) {
  op <- new_operation(
    name = "ImportKeyPair",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$import_key_pair_input(keyPairName = keyPairName, publicKeyBase64 = publicKeyBase64)
  output <- .lightsail$import_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$import_key_pair <- lightsail_import_key_pair

#' Returns a Boolean value indicating whether your Lightsail VPC is peered
#'
#' @description
#' Returns a Boolean value indicating whether your Lightsail VPC is peered.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_is_vpc_peered/](https://www.paws-r-sdk.com/docs/lightsail_is_vpc_peered/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_is_vpc_peered
lightsail_is_vpc_peered <- function() {
  op <- new_operation(
    name = "IsVpcPeered",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$is_vpc_peered_input()
  output <- .lightsail$is_vpc_peered_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$is_vpc_peered <- lightsail_is_vpc_peered

#' Opens ports for a specific Amazon Lightsail instance, and specifies the
#' IP addresses allowed to connect to the instance through the ports, and
#' the protocol
#'
#' @description
#' Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_open_instance_public_ports/](https://www.paws-r-sdk.com/docs/lightsail_open_instance_public_ports/) for full documentation.
#'
#' @param portInfo &#91;required&#93; An object to describe the ports to open for the specified instance.
#' @param instanceName &#91;required&#93; The name of the instance for which to open ports.
#'
#' @keywords internal
#'
#' @rdname lightsail_open_instance_public_ports
lightsail_open_instance_public_ports <- function(portInfo, instanceName) {
  op <- new_operation(
    name = "OpenInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$open_instance_public_ports_input(portInfo = portInfo, instanceName = instanceName)
  output <- .lightsail$open_instance_public_ports_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$open_instance_public_ports <- lightsail_open_instance_public_ports

#' Peers the Lightsail VPC with the user's default VPC
#'
#' @description
#' Peers the Lightsail VPC with the user's default VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_peer_vpc/](https://www.paws-r-sdk.com/docs/lightsail_peer_vpc/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_peer_vpc
lightsail_peer_vpc <- function() {
  op <- new_operation(
    name = "PeerVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$peer_vpc_input()
  output <- .lightsail$peer_vpc_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$peer_vpc <- lightsail_peer_vpc

#' Creates or updates an alarm, and associates it with the specified metric
#'
#' @description
#' Creates or updates an alarm, and associates it with the specified metric.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_put_alarm/](https://www.paws-r-sdk.com/docs/lightsail_put_alarm/) for full documentation.
#'
#' @param alarmName &#91;required&#93; The name for the alarm. Specify the name of an existing alarm to update,
#' and overwrite the previous configuration of the alarm.
#' @param metricName &#91;required&#93; The name of the metric to associate with the alarm.
#' 
#' You can configure up to two alarms per metric.
#' 
#' The following metrics are available for each resource type:
#' 
#' -   **Instances**: `BurstCapacityPercentage`, `BurstCapacityTime`,
#'     `CPUUtilization`, `NetworkIn`, `NetworkOut`, `StatusCheckFailed`,
#'     `StatusCheckFailed_Instance`, and `StatusCheckFailed_System`.
#' 
#' -   **Load balancers**: `ClientTLSNegotiationErrorCount`,
#'     `HealthyHostCount`, `UnhealthyHostCount`, `HTTPCode_LB_4XX_Count`,
#'     `HTTPCode_LB_5XX_Count`, `HTTPCode_Instance_2XX_Count`,
#'     `HTTPCode_Instance_3XX_Count`, `HTTPCode_Instance_4XX_Count`,
#'     `HTTPCode_Instance_5XX_Count`, `InstanceResponseTime`,
#'     `RejectedConnectionCount`, and `RequestCount`.
#' 
#' -   **Relational databases**: `CPUUtilization`, `DatabaseConnections`,
#'     `DiskQueueDepth`, `FreeStorageSpace`, `NetworkReceiveThroughput`,
#'     and `NetworkTransmitThroughput`.
#' 
#' For more information about these metrics, see [Metrics available in
#' Lightsail](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-resource-health-metrics.html#available-metrics).
#' @param monitoredResourceName &#91;required&#93; The name of the Lightsail resource that will be monitored.
#' 
#' Instances, load balancers, and relational databases are the only
#' Lightsail resources that can currently be monitored by alarms.
#' @param comparisonOperator &#91;required&#93; The arithmetic operation to use when comparing the specified statistic
#' to the threshold. The specified statistic value is used as the first
#' operand.
#' @param threshold &#91;required&#93; The value against which the specified statistic is compared.
#' @param evaluationPeriods &#91;required&#93; The number of most recent periods over which data is compared to the
#' specified threshold. If you are setting an "M out of N" alarm, this
#' value (`evaluationPeriods`) is the N.
#' 
#' If you are setting an alarm that requires that a number of consecutive
#' data points be breaching to trigger the alarm, this value specifies the
#' rolling period of time in which data points are evaluated.
#' 
#' Each evaluation period is five minutes long. For example, specify an
#' evaluation period of 24 to evaluate a metric over a rolling period of
#' two hours.
#' 
#' You can specify a minimum valuation period of 1 (5 minutes), and a
#' maximum evaluation period of 288 (24 hours).
#' @param datapointsToAlarm The number of data points that must be not within the specified
#' threshold to trigger the alarm. If you are setting an "M out of N"
#' alarm, this value (`datapointsToAlarm`) is the M.
#' @param treatMissingData Sets how this alarm will handle missing data points.
#' 
#' An alarm can treat missing data in the following ways:
#' 
#' -   `breaching` - Assume the missing data is not within the threshold.
#'     Missing data counts towards the number of times the metric is not
#'     within the threshold.
#' 
#' -   `notBreaching` - Assume the missing data is within the threshold.
#'     Missing data does not count towards the number of times the metric
#'     is not within the threshold.
#' 
#' -   `ignore` - Ignore the missing data. Maintains the current alarm
#'     state.
#' 
#' -   `missing` - Missing data is treated as missing.
#' 
#' If `treatMissingData` is not specified, the default behavior of
#' `missing` is used.
#' @param contactProtocols The contact protocols to use for the alarm, such as `Email`, `SMS` (text
#' messaging), or both.
#' 
#' A notification is sent via the specified contact protocol if
#' notifications are enabled for the alarm, and when the alarm is
#' triggered.
#' 
#' A notification is not sent if a contact protocol is not specified, if
#' the specified contact protocol is not configured in the Amazon Web
#' Services Region, or if notifications are not enabled for the alarm using
#' the `notificationEnabled` paramater.
#' 
#' Use the [`create_contact_method`][lightsail_create_contact_method]
#' action to configure a contact protocol in an Amazon Web Services Region.
#' @param notificationTriggers The alarm states that trigger a notification.
#' 
#' An alarm has the following possible states:
#' 
#' -   `ALARM` - The metric is outside of the defined threshold.
#' 
#' -   `INSUFFICIENT_DATA` - The alarm has just started, the metric is not
#'     available, or not enough data is available for the metric to
#'     determine the alarm state.
#' 
#' -   `OK` - The metric is within the defined threshold.
#' 
#' When you specify a notification trigger, the `ALARM` state must be
#' specified. The `INSUFFICIENT_DATA` and `OK` states can be specified in
#' addition to the `ALARM` state.
#' 
#' -   If you specify `OK` as an alarm trigger, a notification is sent when
#'     the alarm switches from an `ALARM` or `INSUFFICIENT_DATA` alarm
#'     state to an `OK` state. This can be thought of as an *all clear*
#'     alarm notification.
#' 
#' -   If you specify `INSUFFICIENT_DATA` as the alarm trigger, a
#'     notification is sent when the alarm switches from an `OK` or `ALARM`
#'     alarm state to an `INSUFFICIENT_DATA` state.
#' 
#' The notification trigger defaults to `ALARM` if you don't specify this
#' parameter.
#' @param notificationEnabled Indicates whether the alarm is enabled.
#' 
#' Notifications are enabled by default if you don't specify this
#' parameter.
#'
#' @keywords internal
#'
#' @rdname lightsail_put_alarm
lightsail_put_alarm <- function(alarmName, metricName, monitoredResourceName, comparisonOperator, threshold, evaluationPeriods, datapointsToAlarm = NULL, treatMissingData = NULL, contactProtocols = NULL, notificationTriggers = NULL, notificationEnabled = NULL) {
  op <- new_operation(
    name = "PutAlarm",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$put_alarm_input(alarmName = alarmName, metricName = metricName, monitoredResourceName = monitoredResourceName, comparisonOperator = comparisonOperator, threshold = threshold, evaluationPeriods = evaluationPeriods, datapointsToAlarm = datapointsToAlarm, treatMissingData = treatMissingData, contactProtocols = contactProtocols, notificationTriggers = notificationTriggers, notificationEnabled = notificationEnabled)
  output <- .lightsail$put_alarm_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$put_alarm <- lightsail_put_alarm

#' Opens ports for a specific Amazon Lightsail instance, and specifies the
#' IP addresses allowed to connect to the instance through the ports, and
#' the protocol
#'
#' @description
#' Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the instance through the ports, and the protocol. This action also closes all currently open ports that are not included in the request. Include all of the ports and the protocols you want to open in your [`put_instance_public_ports`][lightsail_put_instance_public_ports]request. Or use the [`open_instance_public_ports`][lightsail_open_instance_public_ports] action to open ports without closing currently open ports.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_put_instance_public_ports/](https://www.paws-r-sdk.com/docs/lightsail_put_instance_public_ports/) for full documentation.
#'
#' @param portInfos &#91;required&#93; An array of objects to describe the ports to open for the specified
#' instance.
#' @param instanceName &#91;required&#93; The name of the instance for which to open ports.
#'
#' @keywords internal
#'
#' @rdname lightsail_put_instance_public_ports
lightsail_put_instance_public_ports <- function(portInfos, instanceName) {
  op <- new_operation(
    name = "PutInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$put_instance_public_ports_input(portInfos = portInfos, instanceName = instanceName)
  output <- .lightsail$put_instance_public_ports_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$put_instance_public_ports <- lightsail_put_instance_public_ports

#' Restarts a specific instance
#'
#' @description
#' Restarts a specific instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_reboot_instance/](https://www.paws-r-sdk.com/docs/lightsail_reboot_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance to reboot.
#'
#' @keywords internal
#'
#' @rdname lightsail_reboot_instance
lightsail_reboot_instance <- function(instanceName) {
  op <- new_operation(
    name = "RebootInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$reboot_instance_input(instanceName = instanceName)
  output <- .lightsail$reboot_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reboot_instance <- lightsail_reboot_instance

#' Restarts a specific database in Amazon Lightsail
#'
#' @description
#' Restarts a specific database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_reboot_relational_database/](https://www.paws-r-sdk.com/docs/lightsail_reboot_relational_database/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to reboot.
#'
#' @keywords internal
#'
#' @rdname lightsail_reboot_relational_database
lightsail_reboot_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "RebootRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$reboot_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$reboot_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reboot_relational_database <- lightsail_reboot_relational_database

#' Registers a container image to your Amazon Lightsail container service
#'
#' @description
#' Registers a container image to your Amazon Lightsail container service.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_register_container_image/](https://www.paws-r-sdk.com/docs/lightsail_register_container_image/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to register a container
#' image.
#' @param label &#91;required&#93; The label for the container image when it's registered to the container
#' service.
#' 
#' Use a descriptive label that you can use to track the different versions
#' of your registered container images.
#' 
#' Use the [`get_container_images`][lightsail_get_container_images] action
#' to return the container images registered to a Lightsail container
#' service. The label is the `<imagelabel>` portion of the following image
#' name example:
#' 
#' -   `:container-service-1.<imagelabel>.1`
#' 
#' If the name of your container service is `mycontainerservice`, and the
#' label that you specify is `mystaticwebsite`, then the name of the
#' registered container image will be
#' `:mycontainerservice.mystaticwebsite.1`.
#' 
#' The number at the end of these image name examples represents the
#' version of the registered container image. If you push and register
#' another container image to the same Lightsail container service, with
#' the same label, then the version number for the new registered container
#' image will be `2`. If you push and register another container image, the
#' version number will be `3`, and so on.
#' @param digest &#91;required&#93; The digest of the container image to be registered.
#'
#' @keywords internal
#'
#' @rdname lightsail_register_container_image
lightsail_register_container_image <- function(serviceName, label, digest) {
  op <- new_operation(
    name = "RegisterContainerImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$register_container_image_input(serviceName = serviceName, label = label, digest = digest)
  output <- .lightsail$register_container_image_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$register_container_image <- lightsail_register_container_image

#' Deletes a specific static IP from your account
#'
#' @description
#' Deletes a specific static IP from your account.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_release_static_ip/](https://www.paws-r-sdk.com/docs/lightsail_release_static_ip/) for full documentation.
#'
#' @param staticIpName &#91;required&#93; The name of the static IP to delete.
#'
#' @keywords internal
#'
#' @rdname lightsail_release_static_ip
lightsail_release_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "ReleaseStaticIp",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$release_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$release_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$release_static_ip <- lightsail_release_static_ip

#' Deletes currently cached content from your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_reset_distribution_cache/](https://www.paws-r-sdk.com/docs/lightsail_reset_distribution_cache/) for full documentation.
#'
#' @param distributionName The name of the distribution for which to reset cache.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_reset_distribution_cache
lightsail_reset_distribution_cache <- function(distributionName = NULL) {
  op <- new_operation(
    name = "ResetDistributionCache",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$reset_distribution_cache_input(distributionName = distributionName)
  output <- .lightsail$reset_distribution_cache_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reset_distribution_cache <- lightsail_reset_distribution_cache

#' Sends a verification request to an email contact method to ensure it's
#' owned by the requester
#'
#' @description
#' Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact methods don't need to be verified.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_send_contact_method_verification/](https://www.paws-r-sdk.com/docs/lightsail_send_contact_method_verification/) for full documentation.
#'
#' @param protocol &#91;required&#93; The protocol to verify, such as `Email` or `SMS` (text messaging).
#'
#' @keywords internal
#'
#' @rdname lightsail_send_contact_method_verification
lightsail_send_contact_method_verification <- function(protocol) {
  op <- new_operation(
    name = "SendContactMethodVerification",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$send_contact_method_verification_input(protocol = protocol)
  output <- .lightsail$send_contact_method_verification_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$send_contact_method_verification <- lightsail_send_contact_method_verification

#' Sets the IP address type for an Amazon Lightsail resource
#'
#' @description
#' Sets the IP address type for an Amazon Lightsail resource.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_set_ip_address_type/](https://www.paws-r-sdk.com/docs/lightsail_set_ip_address_type/) for full documentation.
#'
#' @param resourceType &#91;required&#93; The resource type.
#' 
#' The resource values are `Distribution`, `Instance`, and `LoadBalancer`.
#' 
#' Distribution-related APIs are available only in the N. Virginia
#' (`us-east-1`) Amazon Web Services Region. Set your Amazon Web Services
#' Region configuration to `us-east-1` to create, view, or edit
#' distributions.
#' @param resourceName &#91;required&#93; The name of the resource for which to set the IP address type.
#' @param ipAddressType &#91;required&#93; The IP address type to set for the specified resource.
#' 
#' The possible values are `ipv4` for IPv4 only, `ipv6` for IPv6 only, and
#' `dualstack` for IPv4 and IPv6.
#' @param acceptBundleUpdate Required parameter to accept the instance bundle update when changing
#' to, and from, IPv6-only.
#' 
#' An instance bundle will change when switching from `dual-stack` or
#' `ipv4`, to `ipv6`. It also changes when switching from `ipv6`, to
#' `dual-stack` or `ipv4`.
#' 
#' You must include this parameter in the command to update the bundle. For
#' example, if you switch from `dual-stack` to `ipv6`, the bundle will be
#' updated, and billing for the IPv6-only instance bundle begins
#' immediately.
#'
#' @keywords internal
#'
#' @rdname lightsail_set_ip_address_type
lightsail_set_ip_address_type <- function(resourceType, resourceName, ipAddressType, acceptBundleUpdate = NULL) {
  op <- new_operation(
    name = "SetIpAddressType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$set_ip_address_type_input(resourceType = resourceType, resourceName = resourceName, ipAddressType = ipAddressType, acceptBundleUpdate = acceptBundleUpdate)
  output <- .lightsail$set_ip_address_type_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$set_ip_address_type <- lightsail_set_ip_address_type

#' Sets the Amazon Lightsail resources that can access the specified
#' Lightsail bucket
#'
#' @description
#' Sets the Amazon Lightsail resources that can access the specified Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_set_resource_access_for_bucket/](https://www.paws-r-sdk.com/docs/lightsail_set_resource_access_for_bucket/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the Lightsail instance for which to set bucket access. The
#' instance must be in a running or stopped state.
#' @param bucketName &#91;required&#93; The name of the bucket for which to set access to another Lightsail
#' resource.
#' @param access &#91;required&#93; The access setting.
#' 
#' The following access settings are available:
#' 
#' -   `allow` - Allows access to the bucket and its objects.
#' 
#' -   `deny` - Denies access to the bucket and its objects. Use this
#'     setting to remove access for a resource previously set to `allow`.
#'
#' @keywords internal
#'
#' @rdname lightsail_set_resource_access_for_bucket
lightsail_set_resource_access_for_bucket <- function(resourceName, bucketName, access) {
  op <- new_operation(
    name = "SetResourceAccessForBucket",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$set_resource_access_for_bucket_input(resourceName = resourceName, bucketName = bucketName, access = access)
  output <- .lightsail$set_resource_access_for_bucket_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$set_resource_access_for_bucket <- lightsail_set_resource_access_for_bucket

#' Creates an SSL/TLS certificate that secures traffic for your website
#'
#' @description
#' Creates an SSL/TLS certificate that secures traffic for your website. After the certificate is created, it is installed on the specified Lightsail instance.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_setup_instance_https/](https://www.paws-r-sdk.com/docs/lightsail_setup_instance_https/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the Lightsail instance.
#' @param emailAddress &#91;required&#93; The contact method for SSL/TLS certificate renewal alerts. You can enter
#' one email address.
#' @param domainNames &#91;required&#93; The name of the domain and subdomains that were specified for the
#' SSL/TLS certificate.
#' @param certificateProvider &#91;required&#93; The certificate authority that issues the SSL/TLS certificate.
#'
#' @keywords internal
#'
#' @rdname lightsail_setup_instance_https
lightsail_setup_instance_https <- function(instanceName, emailAddress, domainNames, certificateProvider) {
  op <- new_operation(
    name = "SetupInstanceHttps",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$setup_instance_https_input(instanceName = instanceName, emailAddress = emailAddress, domainNames = domainNames, certificateProvider = certificateProvider)
  output <- .lightsail$setup_instance_https_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$setup_instance_https <- lightsail_setup_instance_https

#' Initiates a graphical user interface (GUI) session that’s used to access
#' a virtual computer’s operating system and application
#'
#' @description
#' Initiates a graphical user interface (GUI) session that’s used to access a virtual computer’s operating system and application. The session will be active for 1 hour. Use this action to resume the session after it expires.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_start_gui_session/](https://www.paws-r-sdk.com/docs/lightsail_start_gui_session/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The resource name.
#'
#' @keywords internal
#'
#' @rdname lightsail_start_gui_session
lightsail_start_gui_session <- function(resourceName) {
  op <- new_operation(
    name = "StartGUISession",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$start_gui_session_input(resourceName = resourceName)
  output <- .lightsail$start_gui_session_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$start_gui_session <- lightsail_start_gui_session

#' Starts a specific Amazon Lightsail instance from a stopped state
#'
#' @description
#' Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the `reboot instance` operation.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_start_instance/](https://www.paws-r-sdk.com/docs/lightsail_start_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance (a virtual private server) to start.
#'
#' @keywords internal
#'
#' @rdname lightsail_start_instance
lightsail_start_instance <- function(instanceName) {
  op <- new_operation(
    name = "StartInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$start_instance_input(instanceName = instanceName)
  output <- .lightsail$start_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$start_instance <- lightsail_start_instance

#' Starts a specific database from a stopped state in Amazon Lightsail
#'
#' @description
#' Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the `reboot relational database` operation.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_start_relational_database/](https://www.paws-r-sdk.com/docs/lightsail_start_relational_database/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to start.
#'
#' @keywords internal
#'
#' @rdname lightsail_start_relational_database
lightsail_start_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "StartRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$start_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$start_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$start_relational_database <- lightsail_start_relational_database

#' Terminates a web-based NICE DCV session that’s used to access a virtual
#' computer’s operating system or application
#'
#' @description
#' Terminates a web-based NICE DCV session that’s used to access a virtual computer’s operating system or application. The session will close and any unsaved data will be lost.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_stop_gui_session/](https://www.paws-r-sdk.com/docs/lightsail_stop_gui_session/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The resource name.
#'
#' @keywords internal
#'
#' @rdname lightsail_stop_gui_session
lightsail_stop_gui_session <- function(resourceName) {
  op <- new_operation(
    name = "StopGUISession",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$stop_gui_session_input(resourceName = resourceName)
  output <- .lightsail$stop_gui_session_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$stop_gui_session <- lightsail_stop_gui_session

#' Stops a specific Amazon Lightsail instance that is currently running
#'
#' @description
#' Stops a specific Amazon Lightsail instance that is currently running.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_stop_instance/](https://www.paws-r-sdk.com/docs/lightsail_stop_instance/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance (a virtual private server) to stop.
#' @param force When set to `True`, forces a Lightsail instance that is stuck in a
#' `stopping` state to stop.
#' 
#' Only use the `force` parameter if your instance is stuck in the
#' `stopping` state. In any other state, your instance should stop normally
#' without adding this parameter to your API request.
#'
#' @keywords internal
#'
#' @rdname lightsail_stop_instance
lightsail_stop_instance <- function(instanceName, force = NULL) {
  op <- new_operation(
    name = "StopInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$stop_instance_input(instanceName = instanceName, force = force)
  output <- .lightsail$stop_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$stop_instance <- lightsail_stop_instance

#' Stops a specific database that is currently running in Amazon Lightsail
#'
#' @description
#' Stops a specific database that is currently running in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_stop_relational_database/](https://www.paws-r-sdk.com/docs/lightsail_stop_relational_database/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to stop.
#' @param relationalDatabaseSnapshotName The name of your new database snapshot to be created before stopping
#' your database.
#'
#' @keywords internal
#'
#' @rdname lightsail_stop_relational_database
lightsail_stop_relational_database <- function(relationalDatabaseName, relationalDatabaseSnapshotName = NULL) {
  op <- new_operation(
    name = "StopRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$stop_relational_database_input(relationalDatabaseName = relationalDatabaseName, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$stop_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$stop_relational_database <- lightsail_stop_relational_database

#' Adds one or more tags to the specified Amazon Lightsail resource
#'
#' @description
#' Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see the [Amazon Lightsail Developer Guide](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-tags.html).
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_tag_resource/](https://www.paws-r-sdk.com/docs/lightsail_tag_resource/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the resource to which you are adding tags.
#' @param resourceArn The Amazon Resource Name (ARN) of the resource to which you want to add
#' a tag.
#' @param tags &#91;required&#93; The tag key and optional value.
#'
#' @keywords internal
#'
#' @rdname lightsail_tag_resource
lightsail_tag_resource <- function(resourceName, resourceArn = NULL, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$tag_resource_input(resourceName = resourceName, resourceArn = resourceArn, tags = tags)
  output <- .lightsail$tag_resource_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$tag_resource <- lightsail_tag_resource

#' Tests an alarm by displaying a banner on the Amazon Lightsail console
#'
#' @description
#' Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured for the specified alarm, the test also sends a notification to the notification protocol (`Email` and/or `SMS`) configured for the alarm.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_test_alarm/](https://www.paws-r-sdk.com/docs/lightsail_test_alarm/) for full documentation.
#'
#' @param alarmName &#91;required&#93; The name of the alarm to test.
#' @param state &#91;required&#93; The alarm state to test.
#' 
#' An alarm has the following possible states that can be tested:
#' 
#' -   `ALARM` - The metric is outside of the defined threshold.
#' 
#' -   `INSUFFICIENT_DATA` - The alarm has just started, the metric is not
#'     available, or not enough data is available for the metric to
#'     determine the alarm state.
#' 
#' -   `OK` - The metric is within the defined threshold.
#'
#' @keywords internal
#'
#' @rdname lightsail_test_alarm
lightsail_test_alarm <- function(alarmName, state) {
  op <- new_operation(
    name = "TestAlarm",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$test_alarm_input(alarmName = alarmName, state = state)
  output <- .lightsail$test_alarm_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$test_alarm <- lightsail_test_alarm

#' Unpeers the Lightsail VPC from the user's default VPC
#'
#' @description
#' Unpeers the Lightsail VPC from the user's default VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_unpeer_vpc/](https://www.paws-r-sdk.com/docs/lightsail_unpeer_vpc/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname lightsail_unpeer_vpc
lightsail_unpeer_vpc <- function() {
  op <- new_operation(
    name = "UnpeerVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$unpeer_vpc_input()
  output <- .lightsail$unpeer_vpc_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$unpeer_vpc <- lightsail_unpeer_vpc

#' Deletes the specified set of tag keys and their values from the
#' specified Amazon Lightsail resource
#'
#' @description
#' Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_untag_resource/](https://www.paws-r-sdk.com/docs/lightsail_untag_resource/) for full documentation.
#'
#' @param resourceName &#91;required&#93; The name of the resource from which you are removing a tag.
#' @param resourceArn The Amazon Resource Name (ARN) of the resource from which you want to
#' remove a tag.
#' @param tagKeys &#91;required&#93; The tag keys to delete from the specified resource.
#'
#' @keywords internal
#'
#' @rdname lightsail_untag_resource
lightsail_untag_resource <- function(resourceName, resourceArn = NULL, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$untag_resource_input(resourceName = resourceName, resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .lightsail$untag_resource_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$untag_resource <- lightsail_untag_resource

#' Updates an existing Amazon Lightsail bucket
#'
#' @description
#' Updates an existing Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_bucket/](https://www.paws-r-sdk.com/docs/lightsail_update_bucket/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name of the bucket to update.
#' @param accessRules An object that sets the public accessibility of objects in the specified
#' bucket.
#' @param versioning Specifies whether to enable or suspend versioning of objects in the
#' bucket.
#' 
#' The following options can be specified:
#' 
#' -   `Enabled` - Enables versioning of objects in the specified bucket.
#' 
#' -   `Suspended` - Suspends versioning of objects in the specified
#'     bucket. Existing object versions are retained.
#' @param readonlyAccessAccounts An array of strings to specify the Amazon Web Services account IDs that
#' can access the bucket.
#' 
#' You can give a maximum of 10 Amazon Web Services accounts access to a
#' bucket.
#' @param accessLogConfig An object that describes the access log configuration for the bucket.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_bucket
lightsail_update_bucket <- function(bucketName, accessRules = NULL, versioning = NULL, readonlyAccessAccounts = NULL, accessLogConfig = NULL) {
  op <- new_operation(
    name = "UpdateBucket",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_bucket_input(bucketName = bucketName, accessRules = accessRules, versioning = versioning, readonlyAccessAccounts = readonlyAccessAccounts, accessLogConfig = accessLogConfig)
  output <- .lightsail$update_bucket_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_bucket <- lightsail_update_bucket

#' Updates the bundle, or storage plan, of an existing Amazon Lightsail
#' bucket
#'
#' @description
#' Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_bucket_bundle/](https://www.paws-r-sdk.com/docs/lightsail_update_bucket_bundle/) for full documentation.
#'
#' @param bucketName &#91;required&#93; The name of the bucket for which to update the bundle.
#' @param bundleId &#91;required&#93; The ID of the new bundle to apply to the bucket.
#' 
#' Use the [`get_bucket_bundles`][lightsail_get_bucket_bundles] action to
#' get a list of bundle IDs that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_bucket_bundle
lightsail_update_bucket_bundle <- function(bucketName, bundleId) {
  op <- new_operation(
    name = "UpdateBucketBundle",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_bucket_bundle_input(bucketName = bucketName, bundleId = bundleId)
  output <- .lightsail$update_bucket_bundle_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_bucket_bundle <- lightsail_update_bucket_bundle

#' Updates the configuration of your Amazon Lightsail container service,
#' such as its power, scale, and public domain names
#'
#' @description
#' Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain names.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_container_service/](https://www.paws-r-sdk.com/docs/lightsail_update_container_service/) for full documentation.
#'
#' @param serviceName &#91;required&#93; The name of the container service to update.
#' @param power The power for the container service.
#' 
#' The power specifies the amount of memory, vCPUs, and base monthly cost
#' of each node of the container service. The `power` and `scale` of a
#' container service makes up its configured capacity. To determine the
#' monthly price of your container service, multiply the base price of the
#' `power` with the `scale` (the number of nodes) of the service.
#' 
#' Use the
#' [`get_container_service_powers`][lightsail_get_container_service_powers]
#' action to view the specifications of each power option.
#' @param scale The scale for the container service.
#' 
#' The scale specifies the allocated compute nodes of the container
#' service. The `power` and `scale` of a container service makes up its
#' configured capacity. To determine the monthly price of your container
#' service, multiply the base price of the `power` with the `scale` (the
#' number of nodes) of the service.
#' @param isDisabled A Boolean value to indicate whether the container service is disabled.
#' @param publicDomainNames The public domain names to use with the container service, such as
#' `example.com` and `www.example.com`.
#' 
#' You can specify up to four public domain names for a container service.
#' The domain names that you specify are used when you create a deployment
#' with a container configured as the public endpoint of your container
#' service.
#' 
#' If you don't specify public domain names, then you can use the default
#' domain of the container service.
#' 
#' You must create and validate an SSL/TLS certificate before you can use
#' public domain names with your container service. Use the
#' [`create_certificate`][lightsail_create_certificate] action to create a
#' certificate for the public domain names you want to use with your
#' container service.
#' 
#' You can specify public domain names using a string to array map as shown
#' in the example later on this page.
#' @param privateRegistryAccess An object to describe the configuration for the container service to
#' access private container image repositories, such as Amazon Elastic
#' Container Registry (Amazon ECR) private repositories.
#' 
#' For more information, see [Configuring access to an Amazon ECR private
#' repository for an Amazon Lightsail container
#' service](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-container-service-ecr-private-repo-access.html)
#' in the *Amazon Lightsail Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_container_service
lightsail_update_container_service <- function(serviceName, power = NULL, scale = NULL, isDisabled = NULL, publicDomainNames = NULL, privateRegistryAccess = NULL) {
  op <- new_operation(
    name = "UpdateContainerService",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_container_service_input(serviceName = serviceName, power = power, scale = scale, isDisabled = isDisabled, publicDomainNames = publicDomainNames, privateRegistryAccess = privateRegistryAccess)
  output <- .lightsail$update_container_service_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_container_service <- lightsail_update_container_service

#' Updates an existing Amazon Lightsail content delivery network (CDN)
#' distribution
#'
#' @description
#' Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_distribution/](https://www.paws-r-sdk.com/docs/lightsail_update_distribution/) for full documentation.
#'
#' @param distributionName &#91;required&#93; The name of the distribution to update.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param origin An object that describes the origin resource for the distribution, such
#' as a Lightsail instance, bucket, or load balancer.
#' 
#' The distribution pulls, caches, and serves content from the origin.
#' @param defaultCacheBehavior An object that describes the default cache behavior for the
#' distribution.
#' @param cacheBehaviorSettings An object that describes the cache behavior settings for the
#' distribution.
#' 
#' The `cacheBehaviorSettings` specified in your
#' `UpdateDistributionRequest` will replace your distribution's existing
#' settings.
#' @param cacheBehaviors An array of objects that describe the per-path cache behavior for the
#' distribution.
#' @param isEnabled Indicates whether to enable the distribution.
#' @param viewerMinimumTlsProtocolVersion Use this parameter to update the minimum TLS protocol version for the
#' SSL/TLS certificate that's attached to the distribution.
#' @param certificateName The name of the SSL/TLS certificate that you want to attach to the
#' distribution.
#' 
#' Only certificates with a status of `ISSUED` can be attached to a
#' distribution.
#' 
#' Use the [`get_certificates`][lightsail_get_certificates] action to get a
#' list of certificate names that you can specify.
#' @param useDefaultCertificate Indicates whether the default SSL/TLS certificate is attached to the
#' distribution. The default value is `true`. When `true`, the distribution
#' uses the default domain name such as `d111111abcdef8.cloudfront.net`.
#' 
#' Set this value to `false` to attach a new certificate to the
#' distribution.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_distribution
lightsail_update_distribution <- function(distributionName, origin = NULL, defaultCacheBehavior = NULL, cacheBehaviorSettings = NULL, cacheBehaviors = NULL, isEnabled = NULL, viewerMinimumTlsProtocolVersion = NULL, certificateName = NULL, useDefaultCertificate = NULL) {
  op <- new_operation(
    name = "UpdateDistribution",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_distribution_input(distributionName = distributionName, origin = origin, defaultCacheBehavior = defaultCacheBehavior, cacheBehaviorSettings = cacheBehaviorSettings, cacheBehaviors = cacheBehaviors, isEnabled = isEnabled, viewerMinimumTlsProtocolVersion = viewerMinimumTlsProtocolVersion, certificateName = certificateName, useDefaultCertificate = useDefaultCertificate)
  output <- .lightsail$update_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_distribution <- lightsail_update_distribution

#' Updates the bundle of your Amazon Lightsail content delivery network
#' (CDN) distribution
#'
#' @description
#' Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_distribution_bundle/](https://www.paws-r-sdk.com/docs/lightsail_update_distribution_bundle/) for full documentation.
#'
#' @param distributionName The name of the distribution for which to update the bundle.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param bundleId The bundle ID of the new bundle to apply to your distribution.
#' 
#' Use the [`get_distribution_bundles`][lightsail_get_distribution_bundles]
#' action to get a list of distribution bundle IDs that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_distribution_bundle
lightsail_update_distribution_bundle <- function(distributionName = NULL, bundleId = NULL) {
  op <- new_operation(
    name = "UpdateDistributionBundle",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_distribution_bundle_input(distributionName = distributionName, bundleId = bundleId)
  output <- .lightsail$update_distribution_bundle_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_distribution_bundle <- lightsail_update_distribution_bundle

#' Updates a domain recordset after it is created
#'
#' @description
#' Updates a domain recordset after it is created.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_domain_entry/](https://www.paws-r-sdk.com/docs/lightsail_update_domain_entry/) for full documentation.
#'
#' @param domainName &#91;required&#93; The name of the domain recordset to update.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about the domain
#' entry.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_domain_entry
lightsail_update_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "UpdateDomainEntry",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$update_domain_entry_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_domain_entry <- lightsail_update_domain_entry

#' Modifies the Amazon Lightsail instance metadata parameters on a running
#' or stopped instance
#'
#' @description
#' Modifies the Amazon Lightsail instance metadata parameters on a running or stopped instance. When you modify the parameters on a running instance, the [`get_instance`][lightsail_get_instance] or [`get_instances`][lightsail_get_instances] API operation initially responds with a state of `pending`. After the parameter modifications are successfully applied, the state changes to `applied` in subsequent [`get_instance`][lightsail_get_instance] or [`get_instances`][lightsail_get_instances] API calls. For more information, see [Use IMDSv2 with an Amazon Lightsail instance](https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-instance-metadata-service.html) in the *Amazon Lightsail Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_instance_metadata_options/](https://www.paws-r-sdk.com/docs/lightsail_update_instance_metadata_options/) for full documentation.
#'
#' @param instanceName &#91;required&#93; The name of the instance for which to update metadata parameters.
#' @param httpTokens The state of token usage for your instance metadata requests. If the
#' parameter is not specified in the request, the default state is
#' `optional`.
#' 
#' If the state is `optional`, you can choose whether to retrieve instance
#' metadata with a signed token header on your request. If you retrieve the
#' IAM role credentials without a token, the version 1.0 role credentials
#' are returned. If you retrieve the IAM role credentials by using a valid
#' signed token, the version 2.0 role credentials are returned.
#' 
#' If the state is `required`, you must send a signed token header with all
#' instance metadata retrieval requests. In this state, retrieving the IAM
#' role credential always returns the version 2.0 credentials. The version
#' 1.0 credentials are not available.
#' @param httpEndpoint Enables or disables the HTTP metadata endpoint on your instances. If
#' this parameter is not specified, the existing state is maintained.
#' 
#' If you specify a value of `disabled`, you cannot access your instance
#' metadata.
#' @param httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests.
#' A larger number means that the instance metadata requests can travel
#' farther. If no parameter is specified, the existing state is maintained.
#' @param httpProtocolIpv6 Enables or disables the IPv6 endpoint for the instance metadata service.
#' This setting applies only when the HTTP metadata endpoint is enabled.
#' 
#' This parameter is available only for instances in the Europe (Stockholm)
#' Amazon Web Services Region (`eu-north-1`).
#'
#' @keywords internal
#'
#' @rdname lightsail_update_instance_metadata_options
lightsail_update_instance_metadata_options <- function(instanceName, httpTokens = NULL, httpEndpoint = NULL, httpPutResponseHopLimit = NULL, httpProtocolIpv6 = NULL) {
  op <- new_operation(
    name = "UpdateInstanceMetadataOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_instance_metadata_options_input(instanceName = instanceName, httpTokens = httpTokens, httpEndpoint = httpEndpoint, httpPutResponseHopLimit = httpPutResponseHopLimit, httpProtocolIpv6 = httpProtocolIpv6)
  output <- .lightsail$update_instance_metadata_options_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_instance_metadata_options <- lightsail_update_instance_metadata_options

#' Updates the specified attribute for a load balancer
#'
#' @description
#' Updates the specified attribute for a load balancer. You can only update one attribute at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_load_balancer_attribute/](https://www.paws-r-sdk.com/docs/lightsail_update_load_balancer_attribute/) for full documentation.
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer that you want to modify
#' (`my-load-balancer`.
#' @param attributeName &#91;required&#93; The name of the attribute you want to update.
#' @param attributeValue &#91;required&#93; The value that you want to specify for the attribute name.
#' 
#' The following values are supported depending on what you specify for the
#' `attributeName` request parameter:
#' 
#' -   If you specify `HealthCheckPath` for the `attributeName` request
#'     parameter, then the `attributeValue` request parameter must be the
#'     path to ping on the target (for example, `/weather/us/wa/seattle`).
#' 
#' -   If you specify `SessionStickinessEnabled` for the `attributeName`
#'     request parameter, then the `attributeValue` request parameter must
#'     be `true` to activate session stickiness or `false` to deactivate
#'     session stickiness.
#' 
#' -   If you specify `SessionStickiness_LB_CookieDurationSeconds` for the
#'     `attributeName` request parameter, then the `attributeValue` request
#'     parameter must be an interger that represents the cookie duration in
#'     seconds.
#' 
#' -   If you specify `HttpsRedirectionEnabled` for the `attributeName`
#'     request parameter, then the `attributeValue` request parameter must
#'     be `true` to activate HTTP to HTTPS redirection or `false` to
#'     deactivate HTTP to HTTPS redirection.
#' 
#' -   If you specify `TlsPolicyName` for the `attributeName` request
#'     parameter, then the `attributeValue` request parameter must be the
#'     name of the TLS policy.
#' 
#'     Use the
#'     [`get_load_balancer_tls_policies`][lightsail_get_load_balancer_tls_policies]
#'     action to get a list of TLS policy names that you can specify.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_load_balancer_attribute
lightsail_update_load_balancer_attribute <- function(loadBalancerName, attributeName, attributeValue) {
  op <- new_operation(
    name = "UpdateLoadBalancerAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_load_balancer_attribute_input(loadBalancerName = loadBalancerName, attributeName = attributeName, attributeValue = attributeValue)
  output <- .lightsail$update_load_balancer_attribute_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_load_balancer_attribute <- lightsail_update_load_balancer_attribute

#' Allows the update of one or more attributes of a database in Amazon
#' Lightsail
#'
#' @description
#' Allows the update of one or more attributes of a database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_relational_database/](https://www.paws-r-sdk.com/docs/lightsail_update_relational_database/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your Lightsail database resource to update.
#' @param masterUserPassword The password for the master user. The password can include any printable
#' ASCII character except "/", """, or "@@".
#' 
#' My**SQL**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **PostgreSQL**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' @param rotateMasterUserPassword When `true`, the master user password is changed to a new strong
#' password generated by Lightsail.
#' 
#' Use the `get relational database master user password` operation to get
#' the new password.
#' @param preferredBackupWindow The daily time range during which automated backups are created for your
#' database if automated backups are enabled.
#' 
#' Constraints:
#' 
#' -   Must be in the `hh24:mi-hh24:mi` format.
#' 
#'     Example: `16:00-16:30`
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your
#' database.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each Amazon Web Services Region, occurring on a random
#' day of the week.
#' 
#' Constraints:
#' 
#' -   Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
#' 
#' -   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be at least 30 minutes.
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Example: `Tue:17:00-Tue:17:30`
#' @param enableBackupRetention When `true`, enables automated backup retention for your database.
#' 
#' Updates are applied during the next maintenance window because this can
#' result in an outage.
#' @param disableBackupRetention When `true`, disables automated backup retention for your database.
#' 
#' Disabling backup retention deletes all automated database backups.
#' Before disabling this, you may want to create a snapshot of your
#' database using the `create relational database snapshot` operation.
#' 
#' Updates are applied during the next maintenance window because this can
#' result in an outage.
#' @param publiclyAccessible Specifies the accessibility options for your database. A value of `true`
#' specifies a database that is available to resources outside of your
#' Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param applyImmediately When `true`, applies changes immediately. When `false`, applies changes
#' during the preferred maintenance window. Some changes may cause an
#' outage.
#' 
#' Default: `false`
#' @param caCertificateIdentifier Indicates the certificate that needs to be associated with the database.
#' @param relationalDatabaseBlueprintId This parameter is used to update the major version of the database.
#' Enter the `blueprintId` for the major version that you want to update
#' to.
#' 
#' Use the
#' [`get_relational_database_blueprints`][lightsail_get_relational_database_blueprints]
#' action to get a list of available blueprint IDs.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_relational_database
lightsail_update_relational_database <- function(relationalDatabaseName, masterUserPassword = NULL, rotateMasterUserPassword = NULL, preferredBackupWindow = NULL, preferredMaintenanceWindow = NULL, enableBackupRetention = NULL, disableBackupRetention = NULL, publiclyAccessible = NULL, applyImmediately = NULL, caCertificateIdentifier = NULL, relationalDatabaseBlueprintId = NULL) {
  op <- new_operation(
    name = "UpdateRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_relational_database_input(relationalDatabaseName = relationalDatabaseName, masterUserPassword = masterUserPassword, rotateMasterUserPassword = rotateMasterUserPassword, preferredBackupWindow = preferredBackupWindow, preferredMaintenanceWindow = preferredMaintenanceWindow, enableBackupRetention = enableBackupRetention, disableBackupRetention = disableBackupRetention, publiclyAccessible = publiclyAccessible, applyImmediately = applyImmediately, caCertificateIdentifier = caCertificateIdentifier, relationalDatabaseBlueprintId = relationalDatabaseBlueprintId)
  output <- .lightsail$update_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_relational_database <- lightsail_update_relational_database

#' Allows the update of one or more parameters of a database in Amazon
#' Lightsail
#'
#' @description
#' Allows the update of one or more parameters of a database in Amazon Lightsail.
#'
#' See [https://www.paws-r-sdk.com/docs/lightsail_update_relational_database_parameters/](https://www.paws-r-sdk.com/docs/lightsail_update_relational_database_parameters/) for full documentation.
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to update parameters.
#' @param parameters &#91;required&#93; The database parameters to update.
#'
#' @keywords internal
#'
#' @rdname lightsail_update_relational_database_parameters
lightsail_update_relational_database_parameters <- function(relationalDatabaseName, parameters) {
  op <- new_operation(
    name = "UpdateRelationalDatabaseParameters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lightsail$update_relational_database_parameters_input(relationalDatabaseName = relationalDatabaseName, parameters = parameters)
  output <- .lightsail$update_relational_database_parameters_output()
  config <- get_config()
  svc <- .lightsail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_relational_database_parameters <- lightsail_update_relational_database_parameters
